; ============================================================================
;
;                     LT-DOS - Little Disk Operating System
;
; ============================================================================

BOOTSEG		EQU	70h		; boot segment of the system

; ------------- Bits

B0		EQU	0000000000000001b
B1		EQU	0000000000000010b
B2		EQU	0000000000000100b
B3		EQU	0000000000001000b
B4		EQU	0000000000010000b
B5		EQU	0000000000100000b
B6		EQU	0000000001000000b
B7		EQU	0000000010000000b
B8		EQU	0000000100000000b
B9		EQU	0000001000000000b
B10		EQU	0000010000000000b
B11		EQU	0000100000000000b
B12		EQU	0001000000000000b
B13		EQU	0010000000000000b
B14		EQU	0100000000000000b
B15		EQU	1000000000000000b

; ------------- Variables in data segment 0

CurPhantom	EQU	504h		; (1) current phantom disk (0 or 1)

; ------------- Constants

TRUE		EQU	1		; true flag
FALSE		EQU	0		; false flag

; ----------------------------------------------------------------------------
;                        Start of system at 0070:0000
; ----------------------------------------------------------------------------
; INPUT:	DL = boot disk number
; ----------------------------------------------------------------------------

Start:		jmp	Init		; jump to system initialization

; ----------------------------------------------------------------------------
;                                 Includes
; ----------------------------------------------------------------------------

%include	"IO.ASM"		; devices (must be first!)
%include	"IO_CON.ASM"		; console device
%include	"IO_COM.ASM"		; COM port device
%include	"IO_LPT.ASM"		; LPT port device
%include	"IO_CLK.ASM"		; date and time device
%include	"IO_DSK.ASM"		; disk device
%include	"DOS.ASM"		; Int 21h services
%include	"DOS_CON.ASM"		; Int 21h console
%include	"DOS_CLK.ASM"		; Int 21h clock
%include	"DOS_AUX.ASM"		; Int 21h AUX device
%include	"DOS_PRN.ASM"		; Int 21h printer
%include	"DOS_NAT.ASM"		; Int 21h national support
%include	"DOS_MEM.ASM"		; Int 21h memory
%include	"DOS_DSK.ASM"		; Int 21h disk
%include	"DOS_BUF.ASM"		; INt 21h buffers
%include	"DOS_FAT.ASM"		; Int 21h FAT
%include	"DOS_PAR.ASM"		; Int 21h filename parser
%include	"DOS_FIL.ASM"		; Int 21h files
%include	"DOS_EXE.ASM"		; Int 21h program
%include	"INIT.ASM"		; initialization (must be last!)
