; ============================================================================
;
;                            LT-DOS - Initialization
;
; ============================================================================

; ----------------------------------------------------------------------------
;                      Interrupt 15h handler (BIOS services)
; ----------------------------------------------------------------------------

MyInt15:	jmp	far [cs:OldInt15] ; jump to old Int 15h routine

; ----------------------------------------------------------------------------
;                      Interrupt 19h handler (boot loader)
; ----------------------------------------------------------------------------

MyInt19:	jmp	far [cs:OldInt19] ; jump to old Int 19h routine

; ----------------------------------------------------------------------------
;                                    Data
; ----------------------------------------------------------------------------

; ------------- Old interrupt table

OldInt:		dw	01h*4		; offset of Int 01h
OldInt01:	dw	MyInt01,0	; old Int 01h address

		dw	03h*4		; offset of Int 03h
OldInt03:	dw	MyInt03,0	; old Int 03h address

		dw	04h*4		; offset of Int 04h
OldInt04:	dw	MyInt04,0	; old Int 04h address

		dw	10h*4		; offset of Int 10h
OldInt10:	dw	MyInt10,0	; old Int 10h address

		dw	13h*4		; offset of Int 13h
OldInt13:	dw	MyInt13,0	; old Int 13h address

		dw	15h*4		; offset of Int 15h
OldInt15:	dw	MyInt15,0	; old Int 15h address

		dw	19h*4		; offset of Int 19h
OldInt19:	dw	MyInt19,0	; old Int 19h address

		dw	1bh*4		; offset of Int 1Bh
OldInt1B:	dw	MyInt1B,0	; old Int 1Bh address

		dw	1eh*4		; offset of Int 1Eh
OldInt1E:	dw	MyInt1E,0	; old Int 1Eh address

		dw	20h*4		; offset of Int 20h
OldInt20:	dw	MyInt20,0	; old Int 20h address

		dw	21h*4		; offset of Int 21h
OldInt21:	dw	MyInt21,0	; old Int 21h address

		dw	23h*4		; offset of Int 23h
OldInt23:	dw	MyInt23,0	; old Int 23h address

		dw	24h*4		; offset of Int 24h
OldInt24:	dw	MyInt24,0	; old Int 24h address

		dw	25h*4		; offset of Int 25h
OldInt25:	dw	MyInt25,0	; old Int 25h address

		dw	26h*4		; offset of Int 26h
OldInt26:	dw	MyInt26,0	; old Int 26h address

		dw	28h*4		; offset of Int 28h
OldInt28:	dw	MyInt28,0	; old Int 28h address

		dw	29h*4		; offset of Int 29h
OldInt29:	dw	MyInt29,0	; old Int 29h address

OldIntNum	EQU	($-OldInt)/6	; number of ionterrupts

; ------------- End of rezident part of system

SystemEnd:

; ----------------------------------------------------------------------------
;                           System initialization
; ----------------------------------------------------------------------------
; INPUT:	DL = boot disk number
; ----------------------------------------------------------------------------

; ------------- Push input parameters from BOOT

Init:		mov	[cs:BootDisk],dl; push boot disk number

; ------------- Init stack pointer (below begin of system, at 0000:0700)

		cli			; disable interrupts
		xor	ax,ax		; AX <- 0
		mov	ss,ax		; SS <- 0 stack segment
		mov	sp,BOOTSEG*16	; SP <- stack offset (below system)

; ------------- Save Int 1Eh disk param table

		cld			; direction up
		mov	ds,ax		; DS <- 0 segment of INT table
		push	cs		; push CS
		pop	es		; ES <- this segment
		lds	si,[4*1Eh]	; DS:SI <- old Int 1Eh address
		mov	di,MyInt1E	; DI <- Int 1Eh disk param table
		mov	cx,16/2		; CX <- length of disk param table
		rep	movsw		; push old disk param table

; ------------- Set some new parameters of disk param table

		mov	byte [es:Int1EHead],15; head settle time for floppy

; ------------- Install new interrupt handlers (here is ES=CS, CH=0, CLI, CLD)

		xor	ax,ax		; AX <- 0
		mov	ds,ax		; DS <- 0 segment of INT table
		mov	cl,OldIntNum	; CX <- number of interrupts
		mov	di,OldInt	; DI <- old interrupt table
InitInt:	mov	si,[cs:di]	; SI <- offset of interrupt
		inc	di		; increment DI
		inc	di		; increment DI
		mov	ax,[es:di]	; AX <- new interrupt handler
		movsw			; push old address LOW
		mov	[si-2],ax	; new interrupt address LOW
		movsw			; push old address HIGH
		mov	[si-2],cs	; new interrupt address HIGH
		loop	InitInt		; install next interrupt handler

; ------------- Initialize other BIOS variables

		mov	[500h],cx	; reset Print Screen status
		mov	[504h],cx	; disk A: selected as last active

; ------------- Prepare function codes for keyboard

		mov	al,[496h]	; AL <- keyboard flags
		and	al,10h		; AL <- 10h = extended keyboard
		mov	[cs:KeyInCode],al ; extended code for input
		or	[cs:KeyTestCode],al ; extended code for test

; ------------- End all interrupts

		sti			; enable interrupts
		mov	al,20h		; AL <- interrupt end command
		out	20h,al		; end all interrupts

; ------------- Init data segment register (from now: DS=CS)

		push	cs		; push CS
		pop	ds		; DS <- this segment

; ------------- Display intro text

		mov	si,IntroText	; SI <- intro text
		call	DispText	; display intro text

; ------------- Determine top of usable memory

		int	12h		; get size of low memory
		mov	cl,6		; CL <- number of rotations
		shl	ax,cl		; AX <- size of memory in paragraphs
		mov	[TopMem],ax	; store top of usable memory

; ------------- Reset day-overflow flag

		mov	ah,0		; AH <- function code
		int	1ah		; reset day-overflow flag

; ------------- Get current day

		mov	ah,4		; AH <- function code
		int	1ah		; get current day
		jnc	InitTime2	; date is OK
		mov	cx,19h*256+80h	; year 1980
		mov	dx,101h		; day 1, month 1
InitTime2:	xchg	ax,cx		; AX <- year
		call	BCDBinD		; unpack bytes
		xchg	ax,cx		; CX <- year
		call	Date2DOS	; calculate date
		mov	[Date],ax	; store date in number of days

; ------------- Initialize serial COM ports

		mov	dx,3		; DX <- index of last COM
InitCOM2:	push	dx		; push DX
		mov	ax,10100011b	; 2400 Baud/no parity/1 stop/8 bits
		int	14h		; initialize COM port
		pop	dx		; pop DX
		dec	dx		; decrement COM number
		jns	InitCOM2	; set next COM port

; ------------- Initialize parallel LPT ports

		mov	dx,2		; DX <- index of last LPT
InitLPT2:	push	dx		; push DX
		mov	ah,1		; AH <- function code
		int	17h		; initialize LPT port
		pop	dx		; pop DX
		dec	dx		; decrement LPT number
		jns	InitLPT2	; set next LPT port

; ------------- Determine count of floppy disks (minimal 2)

		int	11h		; read equipment table
		mov	cl,6		; CL <- number of rotations
		shr	al,cl		; AL <- number of floppy disks - 1
		jnz	InitFlop4	; there are more than 1 floppy
		inc	ax		; minimum 2 floppy
InitFlop4:	inc	ax		; AL = count of floppy disks
		mov	[FloppyNum],al	; count of floppy disks

; ------------- Determine count of hard disks

		mov	dl,80h		; DL <- first hard disk
		mov	ah,8		; AH <- function code
		int	13h		; get number of hard disks
		jc	InitHD8		; there is no hard disk
		or	dl,dl		; is any hard disk?
		jz	InitHD8		; there is no hard disk
		cmp	dl,4		; maximum count of hard disks
		jbe	InitHD2		; hard disk is OK
		mov	dl,4		; limit count of hard disks
InitHD2:	mov	[HDNum],dl	; count of hard disks

; ------------- Init hard disks

		mov	dh,dl		; DH <- count of hard disks
		mov	dl,80h		; first hard disk
		add	dh,dl		; DH <- last hard disk + 1
InitHD3:	push	dx		; push DX







		pop	dx		; pop DX
		inc	dx		; increase hard disk number
		cmp	dl,dh		; was it last disk?
		jb	InitHD3		; init next hard disk




InitHD8:







		int	19h

; ----------------------------------------------------------------------------
;                             Initialization data
; ----------------------------------------------------------------------------

; ------------- Intro text

IntroText:	db	13,10,'============================'
		db	13,10,'Little Disk Operating System'
		db	13,10,'  LT-DOS version 2.20.0001  '
		db	13,10,'============================'
		db	13,10,0
