; ============================================================================
;
;                      Test Program for Linear Boot Sector
;
; This is very simple program for linear boot sector - it displays text and
; waits for a key press. It can be compiled as COM program with "DOS" param.
;
; ============================================================================

; ----------------------------------------------------------------------------
;             Start of program at 0080:0000 (or CS:0100 if COM program)
; ----------------------------------------------------------------------------

SECTION		.text

%ifdef DOS
		org	100h
%else
		org	0
%endif

; ------------- Identification

Start:		jmp	Init

Ident		dw	8A25h		; identification word

; ------------- Display message

Init:		push	cs		; push CS
		pop	ds		; DS <- CS
		mov	si,Message	; message to display
NextChar:	cld			; set direction up
		lodsb			; AL <- load next character from DS:SI
		or	al,al		; AL == 0? (is it end of text?)
		jz	KeyPress	; end of text
		mov	ah,0eh		; AH <- function code		
		mov	bx,7		; BL <- color of text, BH <- page 0
		push	si		; push SI
		int	10h		; print character
		pop	si		; pop SI
		jmp	short NextChar	; next character

; ------------- Waiting for a key

KeyPress:	mov	ah,0		; AH <- function code
		int	16h		; waiting for a key

; ------------- Repeat booting/End program

%ifdef	DOS
		int	20h
%else
		int	19h		; repeat booting
%endif

; ------------- Message to display

Message		db	">>> Here I am! <<<",13,10,0
