; ============================================================================
;
;                          Install Test Boot Sector
;
; This program installs test boot sector on the floppy disk in A:
;
; ============================================================================

SECTION		.text

		org	100h		; start of COM program

; ------------- Prepare address of disk buffer (cannot overlap 64 KB boundary)

Start:		mov	ax,ds		; AX <- program segment
		shl	ax,1
		shl	ax,1
		shl	ax,1
		shl	ax,1		; AX * 16
		add	ax,[Sector]	; add current buffer offset
		add	ax,200h		; test buffer overlapping
		jnc	BufferOK	; buffer is OK
		mov	ax,[Sector]	; AX <- current buffer address
		add	ax,200h		; move over boundary
		mov	[Sector],ax	; new buffer address

; ------------- Open file with boot sector

BufferOK:	mov	ax,3d00h	; AX <- function code (open for reading)
		mov	dx,Filename	; DX <- name of file with boot sector
		int	21h		; open file for reading
		jnc	OpenOK		; file open OK

; ------------- Error - file not found

		mov	ah,9		; AH <- function code
		mov	dx,FoundErr	; DX <- error message
		int	21h		; display error message
		int	20h		; end of program

; ------------- Read file into memory (AX=file identifier)

OpenOK: 	mov	bx,ax		; BX <- file identifier
		mov	cx,512		; CX <- length of boot sector
		mov	dx,[Sector]	; DX <- buffer for reading sector
		mov	ah,3fh		; AH <- function code
		int	21h		; read sector into memory

; ------------- Close file

		mov	ah,3eh		; AH <- function code
		int	21h		; close file

; ------------- Displays prompt text for user

		mov	ah,9		; AH <- function code
		mov	dx,Message	; DX <- message to display
		int	21h		; display message

; ------------- Waiting for a key

		mov	ax,0c08h	; AX <- function code
		int	21h		; waiting for a key
		cmp	al,27		; is it Esc key?
		jne	InitDisk	; it is not Esc, start write
		int	20h		; end of program

; ------------- Display message - Writing sector

InitDisk:	mov	ah,9		; AH <- function code
		mov	dx,StartText	; DX <- text to display
		int	21h		; display message

; ------------- Write boot sector

		mov	si,3		; number of attempts
WriteAgain:	push	si	        ; push attempt counter
		mov	ax,301h		; AH <- function, AL <- num. of sectors
		mov	cx,1		; CH <- cylinder, CL <- sector
		xor	dx,dx		; DH <- 0 head, DL <- 0 disk A:
		mov	bx,[Sector]	; BX <- buffer with sector
		push	ds		; push DS to stack
		pop	es		; ES <- DS
		int	13h		; write BOOT sector
		pop	si		; pop attempt counter
		jnc	WriteOK		; operation OK

; ------------- Reset of disk (e.g. disk change report)

		mov	ah,0		; AH <- function code
		int	13h		; reset disk system
		dec	si		; attempt counter
		jnz	WriteAgain	; next attempt

; ------------- Error - cannot write to a floppy

		mov	ah,9		; AH <- function code
		mov	dx,WriteErr	; DX <- error message
		int	21h		; display error message

WriteOK:	int	20h		; end of program

; ------------- Messages

FoundErr	db	"ERROR: File BOOT.BIN not found!",13,10,"$"
WriteErr	db	"ERROR: Cannot write to disk!",13,10,"$"

Message		db	"Insert formated disk into A: and press",13,10
		db	"any key to continue or Esc to abort...",13,10,"$"

StartText	db	"Writing sector...",13,10,"$"

; ------------- File with boot sector

Filename	db	"BOOT.BIN",0

; ------------- Buffer of boot sector

Sector		dw	Buffer
Buffer:
