; ============================================================================
;
;                              Test Boot Sector
;
; This boot sector is used only for first experiments with booting.
; It displays only information message and continue with booting next device.
;
; ============================================================================

; ----------------------------------------------------------------------------
;           Start of the boot sector (starting at 0000:7C00)
; ----------------------------------------------------------------------------

SECTION		.text

		org	7C00h		; booting address of boot sector

Start:		jmp	Init		; jump to starting routine

Message		db	"My system loaded OK!",13,10
		db	"Press any key...",13,10,0

; ------------- Init stack (lies below beginning of the boot sector)
	
Init:		cli			; disable interrupts
		xor	ax,ax		; AX <- 0
		mov	ds,ax		; DS <- 0 this segment
		mov	ss,ax		; SS <- 0
		mov	sp,7C00h	; SP <- end of stack
		sti			; enable interrupts

; ------------- Display information message

		mov	si,Message	; information message
NextChar:	cld			; set direction up
		lodsb			; AL <- load next character from DS:SI
		or	al,al		; AL == 0? (is it end of text?)
		jz	KeyPress	; end of text
		mov	ah,0eh		; AH <- function code		
		mov	bx,7		; BL <- color of text, BH <- page 0
		int	10h		; print character
		jmp	short NextChar	; next character

; ------------- Waiting for a key

KeyPress:	mov	ah,0		; AH <- function code
		int	16h		; waiting for a key

; ------------- Continue booting with next device

		int	19h		; continue booting

; ------------- Align to sector size

times 512 - 2 - ($ - Start) db	0

		dw	0aa55h		; Boot sector magic
	
