; =============================================================================
;
;                            Litos - Tree list
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                         Initialize tree list entry
; -----------------------------------------------------------------------------
; INPUT:	EBX = tree list entry
; -----------------------------------------------------------------------------

TreeInit:	TREEINIT ebx		; initialize tree list entry
		ret

; -----------------------------------------------------------------------------
;                     Add tree list entry into tree list
; -----------------------------------------------------------------------------
; INPUT:	EAX = new tree list entry
;		EBX = destination (parent) tree list entry
; NOTES:	Only TREE_Child must be initialized in new entry (it must
;		 contain either child list or null), other entries are ignored.
; -----------------------------------------------------------------------------

TreeAdd:	push	ecx		; push ECX
		push	edx		; push EDX
		TREEADD	ebx,eax,ecx,edx	; add new tree list entry into the list
		pop	edx		; pop EDX
		pop	ecx		; pop ECX
		ret

; -----------------------------------------------------------------------------
;             Delete (detach) tree list entry from the tree list
; -----------------------------------------------------------------------------
; INPUT:	EAX = tree list entry to delete (it must not be root entry!)
; -----------------------------------------------------------------------------

TreeDel:	push	ecx		; push ECX
		push	edx		; push EDX
		TREEDEL	eax,ecx,edx	; delete tree list entry
		pop	edx		; pop EDX
		pop	ecx		; pop ECX
		ret
