; =============================================================================
;
;                               Litos - List
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                           Initialize list head
; -----------------------------------------------------------------------------
; INPUT:	EBX = list head
; -----------------------------------------------------------------------------

ListInit:	LISTINIT ebx		; initialize list head
		ret

; -----------------------------------------------------------------------------
;                       Initialize safe list entry
; -----------------------------------------------------------------------------
; INPUT:	EBX = safe list entry
; NOTES:	Safe list entry is not in list if NEXT points to itself.
; -----------------------------------------------------------------------------

ListSafeInit:	LISTEMPTY ebx		; initialize safe list entry
		ret

; -----------------------------------------------------------------------------
;          Add new entry into begin of list or after current entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new entry
;		EBX = list head or current entry
; -----------------------------------------------------------------------------

ListAfter:
ListAdd:	push	ecx		; push ECX
		LISTADD	ebx,eax,ecx	; add new entry into list
		pop	ecx		; pop ECX
		ret

; -----------------------------------------------------------------------------
;         Add new safe entry into begin of list or after current entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new entry
;		EBX = list head or current entry
; NOTES:	Safe list entry is not in list if NEXT points to itself.
; -----------------------------------------------------------------------------

ListSafeAfter:
ListSafeAdd:	LISTTEST eax		; test if list entry is in a list
		jne	ListSafeAdd4	; list entry is already in a list
		push	ecx		; push ECX
		LISTADD	ebx,eax,ecx	; add new entry into list
		pop	ecx		; pop ECX
ListSafeAdd4:	ret

; -----------------------------------------------------------------------------
;           Add new entry into end of list or before current entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new entry
;		EBX = list head or current entry
; -----------------------------------------------------------------------------

ListBefore:
ListLast:	push	ecx		; push ECX
		LISTLAST ebx,eax,ecx	; add new entry into list
		pop	ecx		; pop ECX
		ret

; -----------------------------------------------------------------------------
;         Add new safe entry into end of list or before current entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new safe entry
;		EBX = list head or current entry
; NOTES:	Safe list entry is not in list if NEXT points to itself.
; -----------------------------------------------------------------------------

ListSafeBefore:
ListSafeLast:	LISTTEST eax		; test if list entry is in a list
		jne	ListSafeLast4	; list entry is already in a list
		push	ecx		; push ECX
		LISTLAST ebx,eax,ecx	; add new entry into list
		pop	ecx		; pop ECX
ListSafeLast4:	ret

; -----------------------------------------------------------------------------
;                   Delete (detach) list entry from the list
; -----------------------------------------------------------------------------
; INPUT:	EAX = entry to delete
; -----------------------------------------------------------------------------

ListDel:	push	ebx		; push EBX
		push	ecx		; push ECX
		LISTDEL	eax,ebx,ecx	; delete list entry
		pop	ecx		; pop ECX
		pop	ebx		; pop EBX
		ret

; -----------------------------------------------------------------------------
;         Delete (detach) list entry from the list (using EBX registry)
; -----------------------------------------------------------------------------
; INPUT:	EBX = entry to delete
; -----------------------------------------------------------------------------

ListDelEBX:	push	eax		; push EAX
		push	ecx		; push ECX
		LISTDEL	ebx,eax,ecx	; delete list entry
		pop	ecx		; pop ECX
		pop	eax		; pop EAX
		ret

; -----------------------------------------------------------------------------
;         Delete (detach) list entry from the list (using EDX registry)
; -----------------------------------------------------------------------------
; INPUT:	EDX = entry to delete
; -----------------------------------------------------------------------------

ListDelEDX:	push	ebx		; push EBX
		push	ecx		; push ECX
		LISTDEL	edx,ebx,ecx	; delete list entry
		pop	ecx		; pop ECX
		pop	ebx		; pop EBX
		ret

; -----------------------------------------------------------------------------
;               Delete (detach) safe list entry from the list
; -----------------------------------------------------------------------------
; INPUT:	EAX = safe entry to delete
; NOTES:	Safe list entry is not in list if NEXT points to itself.
; -----------------------------------------------------------------------------

ListSafeDel:	LISTTEST eax		; test if list entry is in a list
		je	ListSafeDel4	; list entry is not in a list
		push	ebx		; push EBX
		push	ecx		; push ECX
		LISTDEL	eax,ebx,ecx	; delete list entry
		pop	ecx		; pop ECX
		pop	ebx		; pop EBX
		LISTEMPTY eax		; mark entry as empty
ListSafeDel4:	ret

; -----------------------------------------------------------------------------
;                       Replace old entry with new one
; -----------------------------------------------------------------------------
; INPUT:	EAX = new entry
;		EBX = old entry
; -----------------------------------------------------------------------------

; ------------- Push registers

ListReplace:	push	ecx		; push ECX
		push	edx		; push EDX

; ------------- Replace entry

		mov	ecx,[ebx+LIST_Prev] ; ECX <- get previous entry
		mov	edx,[ebx+LIST_Next] ; EDX <- get next entry
		LINKLINK ecx,eax	; link new entry to previous entry
		LINKLINK eax,edx	; link next entry to new entry

; ------------- Pop registers

		pop	edx		; pop EDX
		pop	ecx		; pop ECX
		ret

; -----------------------------------------------------------------------------
;                    Exchange entry with next entry
; -----------------------------------------------------------------------------
; INPUT:	EBX = current entry
; -----------------------------------------------------------------------------

; ------------- Push registers

ListXchgNext:	push	eax		; push EAX
		push	ecx		; push ECX

; ------------- Exchange entries

		mov	eax,[ebx+LIST_Prev] ; EAX <- previous entry
		mov	ecx,[ebx+LIST_Next] ; ECX <- next entry
		LINKLINK eax,ecx	; link next entry to previous entry
		mov	eax,[ecx+LIST_Next] ; EAX <- next next entry
		LINKLINK ecx,ebx	; link current entry to next entry
		LINKLINK ebx,eax	; link next entry to current entry

; ------------- Pop registers

		pop	ecx		; pop ECX
		pop	eax		; pop EAX
		ret

; -----------------------------------------------------------------------------
;                 Detach list chain and splice it with other list
; -----------------------------------------------------------------------------
; INPUT:	EAX = source list head (it will become empty)
;		EBX = destination list head
; -----------------------------------------------------------------------------

; ------------- Push registers

ListSplice:	push	ecx		; push ECX
		push	edx		; push EDX
		push	esi		; push ESI

; ------------- Check if source list is already empty

		LISTTEST eax		; is source list empty?
		je	ListSplice2	; source list is empty

; ------------- Detach list chain from source list

		mov	ecx,[eax+LIST_Next] ; ECX <- first entry of source list
		mov	edx,[eax+LIST_Prev] ; EDX <- last entry of source list
		LISTINIT eax		; close source list

; ------------- Atach list chain to destination list

		mov	esi,[ebx+LIST_Next] ; ESI <- first entry of destination
		LINKLINK ebx,ecx	; link first entry to destination
		LINKLINK edx,esi	; link 1st entry 2 to last entry 1

; ------------- Pop registers

ListSplice2:	pop	esi		; pop ESI
		pop	edx		; pop EDX
		pop	ecx		; pop ECX
		ret
