; =============================================================================
;
;                      Litos - Languages and nationality
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                    Initialize nationality descriptors
; -----------------------------------------------------------------------------

; ------------- Go through all nationality descriptors

NationInit:	mov	ebp,NatTab	; EBP <- nationality descriptors

; ------------- Find similar alphabetic tables

NationInit2:	mov	edx,ebp		; EDX <- current nationality descriptor
		lea	ebx,[edx+NAT_Alphabet] ; EBX <- alphabetic order table
NationInit3:	sub	edx,NATIONAL_size ; EDX <- previous descriptor
		cmp	edx,NatTab	; check if table is valid
		jb	NationInit4	; table is not valid
		
; ------------- Compare alphabetic order table

		lea	eax,[edx+NAT_Alphabet] ; EAX <- alphabetic order table
		call	TextEqu		; compare strings
		jc	NationInit3	; tables are not equal

; ------------- Use previous hash table

		mov	eax,[edx+NAT_AlphaHash] ; EAX <- previous hash table
		mov	[ebp+NAT_AlphaHash],eax ; use previous hash table
		jmp	NationInit9

; ------------- Prepare next hash table (-> EDI)

NationInit4:	mov	edi,[AlphaHashTabNxt] ; EDI <- next hash table
		mov	eax,AlphaHashNone ; EAX <- pointer to invalid table
		mov	[ebp+NAT_AlphaHash],edi ; set hash table
		mov	ecx,NAT_MAXAHASH ; ECX <- number of sub-pages
		push	edi		; push EDI
		rep	stosd		; clear hash table
		mov	[AlphaHashTabNxt],edi ; shift pointer
		pop	edi		; pop EDI

; ------------- Prepare registers to generate hash table

		xor	edx,edx		; EDX <- position pointer
		mov	cl,7fh		; CL <- order index - 1

; ------------- Read one character from table (-> EAX)

NationInit5:	inc	ecx		; increase order index
		lea	ebx,[ebp+NAT_Alphabet] ; EBX <- alphabetic order table
		call	TextGetChar	; read one character -> EAX
		jc	NationInit9	; no next character

; ------------- Prepare index of hash sub-page (-> EBX)

		push	eax		; push EAX
		movzx	ebx,ah		; EBX <- hash sub-page

; ------------- Check if hash sub-page is valid

		cmp	dword [edi+ebx*4],AlphaHashNone ; is sub-page valid?
		jne	NationInit6	; sub-page is valid

; ------------- Allocate hash sub-page
		
		push	eax		; push EAX
		mov	eax,[AlphaHashTabNxt] ; EAX <- next hash table
		mov	[edi+ebx*4],eax	; set hash sub-page
		add	eax,256		; shift to next table
		mov	[AlphaHashTabNxt],eax ; store new pointer
		pop	eax		; pop EAX

; ------------- Get hash sub-page (-> EBX)

NationInit6:	mov	ebx,[edi+ebx*4]	; EBX <- hash sub-page

; ------------- Store order index of character

		movzx	eax,al		; EAX <- character LOW
		mov	[ebx+eax],cl	; store order index
		pop	eax		; pop EAX

; ------------- Prepare change small/capital

		call	UniCharToSmaCap	; convert to small/capital

; ------------- Prepare index of hash sub-page (-> EBX)

		movzx	ebx,ah		; EBX <- hash sub-page

; ------------- Check if hash sub-page is valid

		cmp	dword [edi+ebx*4],AlphaHashNone ; is sub-page valid?
		jne	NationInit7	; sub-page is valid

; ------------- Allocate hash sub-page
		
		push	eax		; push EAX
		mov	eax,[AlphaHashTabNxt] ; EAX <- next hash table
		mov	[edi+ebx*4],eax	; set hash sub-page
		add	eax,256		; shift to next table
		mov	[AlphaHashTabNxt],eax ; store new pointer
		pop	eax		; pop EAX

; ------------- Get hash sub-page (-> EBX)

NationInit7:	mov	ebx,[edi+ebx*4]	; EBX <- hash sub-page

; ------------- Store order index of character

		movzx	eax,al		; EAX <- character LOW
		mov	[ebx+eax],cl	; store order index
		jmp	short NationInit5 ; next character

; ------------- Next nationality descriptor

NationInit9:	add	ebp,NATIONAL_size ; next nationality descriptor
		cmp	ebp,NatTab2	; end of table?
		jb	NationInit2	; next descriptor
		ret

; -----------------------------------------------------------------------------
;                        Check national descriptors
; -----------------------------------------------------------------------------

%ifdef DEBUG_NATION

; ------------- Check number of national descriptors

DebCheckNat:	mov	esi,DebNatTextNum
		call	DebOutText
		mov	eax,NatTab2
		sub	eax,NatTab
		xor	edx,edx
		mov	ecx,NATIONAL_size
		div	ecx
		call	DebOutNum
		or	edx,edx
		jnz	DebCheckNat1
		mov	esi,DebNatTextOK
		cmp	eax,NAT_NUM
		je	DebCheckNat2
DebCheckNat1:	mov	esi,DebNatTextER
DebCheckNat2:	call	DebOutText

; ------------- Check size of national hash tables

		mov	esi,DebNatTextSub
		call	DebOutText
		mov	eax,[AlphaHashTabNxt]
		sub	eax,AlphaHashTab
		call	DebOutNum
		mov	ecx,AlphaHashTab2
		sub	ecx,AlphaHashTab
		mov	esi,DebNatTextOK
		cmp	eax,ecx
		je	DebCheckNat3
		mov	esi,DebNatTextER
DebCheckNat3:	call	DebOutText
		ret
%endif

; -----------------------------------------------------------------------------
;                     Debug display national descriptor EAX
; -----------------------------------------------------------------------------

%ifdef DEBUG_NATION

DebDispNat:	imul	eax,eax,NATIONAL_size
		lea	ebx,[eax+NatTab]

		call	DebNewLine

		mov	esi,[ebx+NAT_LangName]
		call	DebOutTextData
		call	DebNewLine

		mov	esi,[ebx+NAT_Alphabet]
		call	DebOutTextData
		call	DebNewLine

		lea	edi,[ebx+NAT_ShortWeek]
		mov	ecx,7
DebDispNat4:	mov	esi,[edi]
		call	DebOutTextData
		call	DebOutSpc
		add	edi,4
		loop	DebDispNat4
		call	DebNewLine

		lea	edi,[ebx+NAT_LongWeek]
		mov	ecx,7
DebDispNat5:	mov	esi,[edi]
		call	DebOutTextData
		call	DebOutSpc
		add	edi,4
		loop	DebDispNat5
		call	DebNewLine

		lea	edi,[ebx+NAT_ShortMonth]
		mov	ecx,12
DebDispNat6:	mov	esi,[edi]
		call	DebOutTextData
		call	DebOutSpc
		add	edi,4
		loop	DebDispNat6
		call	DebNewLine

		lea	edi,[ebx+NAT_LongMonth]
		mov	ecx,12
DebDispNat8:	mov	esi,[edi]
		call	DebOutTextData
		call	DebOutSpc
		add	edi,4
		loop	DebDispNat8
		call	DebNewLine

		call	DebNewLine
		ret
%endif

; -----------------------------------------------------------------------------
;                              Constant Data
; -----------------------------------------------------------------------------

		CONST_SECTION

; ------------- Debug messages

%ifdef DEBUG_NATION
DebNatTextNum:	db	10,'Number od descriptors NAT_NUM: ',0
DebNatTextSub:	db	'Size of nationality hash subpages NATSUBPAGES: ',0
DebNatTextOK:	db	' (OK)',10,0
DebNatTextER:	db	' (ERROR)',10,0
%endif

; ------------- Nationality descriptors
; To change nationality descriptors:
;  - check NAT_NUM
;  - increase NATSUBPAGES with reserve
;  - run DebDispNat (DEBUG_NATION) to determine NATSUBPAGES
;  - correct NATSUBPAGES

		align 4, db 0
NatTab:
NatTabEN:NATION EN,LANG_ENGLISH,SUBLANG_ENGLISH_US,CP_IBM437,":","/",".",39,";"
NatTabCZ:NATION CZ,LANG_CZECH,SUBLANG_NEUTRAL,CP_IBM852,":",".",","," ",";"
NatTab2:

; ------------- English

		align 4, db 0
ShortNameEN:	CTEXTDATA 'EN'
LongNameEN:	CTEXTDATA 'English'
LangNameEN:	CTEXTDATA 'English'
AlphabetEN:	CTEXTDATA 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
ShortTimeEN:	CTEXTDATA 'h:mmt'
LongTimeEN:	CTEXTDATA 'h:mm:ss tt'
ShortDateEN:	CTEXTDATA 'M/d/yy'
LongDateEN:	CTEXTDATA 'MMMM d yyyy'
ShortAMEN:	CTEXTDATA 'a'
ShortPMEN:	CTEXTDATA 'p'
LongAMEN:	CTEXTDATA 'AM'
LongPMEN:	CTEXTDATA 'PM'
ShortBCEEN:	CTEXTDATA 'BC'
ShortCEEN:	CTEXTDATA 'AD'
LongBCEEN:	CTEXTDATA 'BCE'
LongCEEN:	CTEXTDATA 'CE'
ShortWeekEN1:	CTEXTDATA 'Mon'
ShortWeekEN2:	CTEXTDATA 'Tue'
ShortWeekEN3:	CTEXTDATA 'Wed'
ShortWeekEN4:	CTEXTDATA 'Thu'
ShortWeekEN5:	CTEXTDATA 'Fri'
ShortWeekEN6:	CTEXTDATA 'Sat'
ShortWeekEN7:	CTEXTDATA 'Sun'
LongWeekEN1:	CTEXTDATA 'Monday'
LongWeekEN2:	CTEXTDATA 'Tuesday'
LongWeekEN3:	CTEXTDATA 'Wednesday'
LongWeekEN4:	CTEXTDATA 'Thursday'
LongWeekEN5:	CTEXTDATA 'Friday'
LongWeekEN6:	CTEXTDATA 'Saturday'
LongWeekEN7:	CTEXTDATA 'Sunday'
ShortMonthEN1:	CTEXTDATA 'Jan'
ShortMonthEN2:	CTEXTDATA 'Feb'
ShortMonthEN3:	CTEXTDATA 'Mar'
ShortMonthEN4:	CTEXTDATA 'Apr'
ShortMonthEN5:	CTEXTDATA 'May'
ShortMonthEN6:	CTEXTDATA 'Jun'
ShortMonthEN7:	CTEXTDATA 'Jul'
ShortMonthEN8:	CTEXTDATA 'Aug'
ShortMonthEN9:	CTEXTDATA 'Sep'
ShortMonthEN10:	CTEXTDATA 'Oct'
ShortMonthEN11:	CTEXTDATA 'Nov'
ShortMonthEN12:	CTEXTDATA 'Dec'
LongMonth1EN1:
LongMonthEN1:	CTEXTDATA 'January'
LongMonth1EN2:
LongMonthEN2:	CTEXTDATA 'February'
LongMonth1EN3:
LongMonthEN3:	CTEXTDATA 'March'
LongMonth1EN4:
LongMonthEN4:	CTEXTDATA 'April'
LongMonth1EN5:
LongMonthEN5:	CTEXTDATA 'May'
LongMonth1EN6:
LongMonthEN6:	CTEXTDATA 'June'
LongMonth1EN7:
LongMonthEN7:	CTEXTDATA 'July'
LongMonth1EN8:
LongMonthEN8:	CTEXTDATA 'August'
LongMonth1EN9:
LongMonthEN9:	CTEXTDATA 'September'
LongMonth1EN10:
LongMonthEN10:	CTEXTDATA 'October'
LongMonth1EN11:
LongMonthEN11:	CTEXTDATA 'November'
LongMonth1EN12:
LongMonthEN12:	CTEXTDATA 'December'

; ------------- Czech

		align 4, db 0
ShortNameCZ:	CTEXTDATA 'CZ'
LongNameCZ:	CTEXTDATA 'Czech'
LangNameCZ:	CTEXTDATA 0c4h,8ch,'esky'
AlphabetCZ:	CTEXTDATA 'A',0c3h,81h,'BC',0c4h,8ch,'D',0c4h,8eh,'E', \
				0c3h,89h,0c4h,9ah,'FGHI',0c3h,8dh,'JKLMN', \
				0c5h,87h,'O',0c3h,93h,'PQR',0c5h,98h,'S', \
				0c5h,0a0h,'T',0c5h,0a4h,'U',0c3h,9ah, \
				0c5h,0aeh,'VWXY',0c3h,9dh,'Z',0c5h,0bdh
ShortTimeCZ:	CTEXTDATA 'H:mm'
LongTimeCZ:	CTEXTDATA 'H:mm:ss'
ShortDateCZ:	CTEXTDATA 'd/M/yy'
LongDateCZ:	CTEXTDATA 'd/ MMMM yyyy'
ShortAMCZ:	CTEXTDATA 'd'
ShortPMCZ:	CTEXTDATA 'o'
LongAMCZ:	CTEXTDATA 'dop.'
LongPMCZ:	CTEXTDATA 'odp.'
ShortBCECZ:	CTEXTDATA 'pnl'
ShortCECZ:	CTEXTDATA 'nl'
LongBCECZ:	CTEXTDATA 'p',0c5h,99h,'.n.l.'
LongCECZ:	CTEXTDATA 'n.l.'
ShortWeekCZ1:	CTEXTDATA 'Pon'
ShortWeekCZ2:	CTEXTDATA 0c3h,9ah,'te'
ShortWeekCZ3:	CTEXTDATA 'St',0c5h,99h
ShortWeekCZ4:	CTEXTDATA 0c4h,8ch,'tv'
ShortWeekCZ5:	CTEXTDATA 'P',0c3h,0a1h,'t'
ShortWeekCZ6:	CTEXTDATA 'Sob'
ShortWeekCZ7:	CTEXTDATA 'Ned'
LongWeekCZ1:	CTEXTDATA 'Pond',0c4h,9bh,'l',0c3h,0adh
LongWeekCZ2:	CTEXTDATA 0c3h,9ah,'ter',0c3h,0bdh
LongWeekCZ3:	CTEXTDATA 'St',0c5h,99h,'eda'
LongWeekCZ4:	CTEXTDATA 0c4h,8ch,'tvrtek'
LongWeekCZ5:	CTEXTDATA 'P',0c3h,0a1h,'tek'
LongWeekCZ6:	CTEXTDATA 'Sobota'
LongWeekCZ7:	CTEXTDATA 'Ned',0c4h,9bh,'le'
ShortMonthCZ1:	CTEXTDATA 'Led'
ShortMonthCZ2:	CTEXTDATA 0c3h,9ah,'no'
ShortMonthCZ3:	CTEXTDATA 'B',0c5h,99h,'e'
ShortMonthCZ4:	CTEXTDATA 'Dub'
ShortMonthCZ5:	CTEXTDATA 'Kv',0c4h,9bh
ShortMonthCZ6:	CTEXTDATA 0c4h,8ch,'er'
ShortMonthCZ7:	CTEXTDATA 0c4h,8ch,'vc'
ShortMonthCZ8:	CTEXTDATA 'Srp'
ShortMonthCZ9:	CTEXTDATA 'Z',0c3h,0a1h,0c5h,99h
ShortMonthCZ10:	CTEXTDATA 0c5h,98h,0c3h,0adh,'j'
ShortMonthCZ11:	CTEXTDATA 'Lis'
ShortMonthCZ12:	CTEXTDATA 'Pro'
LongMonthCZ1:	CTEXTDATA 'Ledna'
LongMonthCZ2:	CTEXTDATA 0c3h,9ah,'nora'
LongMonthCZ3:	CTEXTDATA 'B',0c5h,99h,'ezna'
LongMonthCZ4:	CTEXTDATA 'Dubna'
LongMonthCZ5:	CTEXTDATA 'Kv',0c4h,9bh,'tna'
LongMonthCZ6:	CTEXTDATA 0c4h,8ch,'ervna'
LongMonthCZ7:	CTEXTDATA 0c4h,8ch,'ervence'
LongMonthCZ8:	CTEXTDATA 'Srpna'
LongMonthCZ9:	CTEXTDATA 'Z',0c3h,0a1h,0c5h,99h,0c3h,0adh
LongMonthCZ10:	CTEXTDATA 0c5h,98h,0c3h,0adh,'jna'
LongMonthCZ11:	CTEXTDATA 'Listopadu'
LongMonthCZ12:	CTEXTDATA 'Prosince'
LongMonth1CZ1:	CTEXTDATA 'Leden'
LongMonth1CZ2:	CTEXTDATA 0c3h,9ah,'nor'
LongMonth1CZ3:	CTEXTDATA 'B',0c5h,99h,'ezen'
LongMonth1CZ4:	CTEXTDATA 'Duben'
LongMonth1CZ5:	CTEXTDATA 'Kv',0c4h,9bh,'ten'
LongMonth1CZ6:	CTEXTDATA 0c4h,8ch,'erven'
LongMonth1CZ7:	CTEXTDATA 0c4h,8ch,'ervenec'
LongMonth1CZ8:	CTEXTDATA 'Srpen'
LongMonth1CZ9:	CTEXTDATA 'Z',0c3h,0a1h,0c5h,99h,0c3h,0adh
LongMonth1CZ10:	CTEXTDATA 0c5h,98h,0c3h,0adh,'jen'
LongMonth1CZ11:	CTEXTDATA 'Listopad'
LongMonth1CZ12:	CTEXTDATA 'Prosinec'

; ------------- Similar languages
; Macro - area of LANG_ENGLISH identifiers (%1 = number of entries)
%macro		LANGNEAR_DEF	1
		%rep	%1
		db	LANG_ENGLISH
		%endrep
%endmacro

LangNear:	LANGNEAR_DEF	(5-0)	; 0...4
		db	LANG_SLOVAK	; 5: LANG_CZECH -> LANG_SLOVAK
		LANGNEAR_DEF	(27-6)	; 6...26
		db	LANG_CZECH	; 27: LANG_SLOVAK -> LANG_CZECH
		LANGNEAR_DEF	(256-28) ; 28...255

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA_SECTION

AlphaHashTabNxt:dd	AlphaHashTab	; next hash subtable

; -----------------------------------------------------------------------------
;                            Uninitialized data
; -----------------------------------------------------------------------------

		BSS_SECTION

; ------------- Alphabetic hash tables (1 KB)

		align	4, resb 1
AlphaHashTab:	resb	NATSUBPAGES
AlphaHashTab2:
		align	4, resb 1
