; =============================================================================
;
;                             Litos - Hash list
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;          Add new entry to begin of hash list or after current entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new hash list entry
;		EBX = hash list head or current hash list entry
; -----------------------------------------------------------------------------

; ------------- Push registers

HashAddAfter:
HashAdd:	push	ecx		; push ECX

; ------------- Link first/next entry and head/current entry to new entry

		mov	ecx,[ebx+HASHH_First] ; ECX <- first/next entry
		mov	[eax+HASHE_Next],ecx ; link first/next entry to new one
		mov	[eax+HASHE_Prev],ebx ; link head/current entry to new

; ------------- Link new entry to first/next entry and to head/current entry

		jecxz	HashAdd2	; no first/next entry
		mov	[ecx+HASHE_Prev],eax ; link new entry to next one
HashAdd2:	mov	[ebx+HASHH_First],eax ; link new entry to head/current

; ------------- Pop registers

		pop	ecx		; pop ECX
		ret

; -----------------------------------------------------------------------------
;                      Add new entry before current entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new hash list entry
;		EBX = current hash list entry
; -----------------------------------------------------------------------------

; ------------- Push registers

HashAddBefore:	push	ecx		; push ECX

; ------------- Link previous entry (or head) and current entry to new entry

		mov	ecx,[ebx+HASHE_Prev] ; ECX <- previous entry (or head)
		mov	[eax+HASHE_Next],ebx ; link current entry to new one
		mov	[eax+HASHE_Prev],ecx ; link previous entry to new one

; ------------- Link new entry to previous entry (or head) and to current entry

		mov	[ebx+HASHE_Prev],eax ; link new entry to current one
		mov	[ecx+HASHE_Next],eax ; link new entry to previous one

; ------------- Pop registers

		pop	ecx		; pop ECX
		ret

; -----------------------------------------------------------------------------
;                         Delete entry from hash list
; -----------------------------------------------------------------------------
; INPUT:	EAX = hash list entry
; -----------------------------------------------------------------------------

; ------------- Push registers

HashDel:	push	ebx		; push EBX
		push	ecx		; push ECX

; ------------- Get next (-> ECX) and previous (-> EBX) entry

		mov	ecx,[eax+HASHE_Next] ; ECX <- next entry
		mov	ebx,[eax+HASHE_Prev] ; EBX <- previous entry

; ------------- Link next entry with previous entry

		mov	[ebx+HASHE_Next],ecx ; link next entry to previous one
		jecxz	HashDel2	; no next entry
		mov	[ecx+HASHE_Prev],ebx ; link previous entry to next one
		
; ------------- Pop registers

HashDel2:	pop	ecx		; pop ECX
		pop	ebx		; pop EBX
		ret

; -----------------------------------------------------------------------------
;                      Replace old entry by new entry
; -----------------------------------------------------------------------------
; INPUT:	EAX = new hash list entry
;		EBX = old hash list entry
; -----------------------------------------------------------------------------

; ------------- Push registers

HashReplace:	push	ecx		; push ECX
		push	edx		; push EDX

; ------------- Get next (-> ECX) and previous (-> EDX) entry

		mov	ecx,[ebx+HASHE_Next] ; ECX <- next entry
		mov	edx,[ebx+HASHE_Prev] ; EDX <- previous entry

; ------------- Link next entry and previous entry to new entry

		mov	[eax+HASHE_Next],ecx ; link next entry to new one
		mov	[eax+HASHE_Prev],edx ; link previous entry to new one

; ------------- Link new entry to next entry and to previous entry

		jecxz	HashReplace2	; no next entry
		mov	[ecx+HASHE_Prev],eax ; link new entry to next entry
HashReplace2:	mov	[edx+HASHE_Next],eax ; link new entry to previous entry

; ------------- Pop registers

		pop	edx		; pop EDX
		pop	ecx		; pop ECX
		ret
