; =============================================================================
;
;                              Litos - User
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                           Lock/unlock user list
; -----------------------------------------------------------------------------
; NOTES:	Use macro USERLOCK to lock, USERUNLOCK to unlock.
; -----------------------------------------------------------------------------

; ------------- Macro - lock user list

%macro		USERLOCK 0
		LOCK_Lock UserListLock		; lock user list
%endmacro

; ------------- Macro - unlock user list

%macro		USERUNLOCK 0
		LOCK_Unlock UserListLock	; unlock user list lock
%endmacro

; -----------------------------------------------------------------------------
;                     Check if current user has admin rights
; -----------------------------------------------------------------------------
; OUTPUT:	NZ = admin
;		ZY = not admin
; -----------------------------------------------------------------------------

; ------------- Push registers

CheckAdmin:	push	ebx		; push EBX

; ------------- Get if current user is admin

		CURRENT	ebx		; EBX <- get current task
		test	byte [ebx+TASK_Flags],TASK_ISADMIN ; check admin flag

; ------------- Pop registers

		pop	ebx		; pop EBX
		ret

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA_SECTION

; ------------- User list lock

		align	4, db 0
UserListLock:	SPINLOCK		; user list lock

; ------------- List of users

		align	4, db 0
UserList:	LINKEDLIST UserRoot, UserRoot ; list head
UserNum:	dd	1		; number of users in the list

; ------------- Root user

		align	4, db 0
UserRoot:	USERINI	UserList, UserList, USER_ADMIN, ROOTUSER_ID, NATTABDEF

; -----------------------------------------------------------------------------
;                            Uninitialized data
; -----------------------------------------------------------------------------

		BSS_SECTION

; ------------- Hash list of users

		align	4, resb 1
UserHashList:	resb	HASHH_size*USERHASH_NUM ; hash list of users
