; =============================================================================
;
;                              Litos - Processor
;
; =============================================================================

		CODE_SECTION

; -----------------------------------------------------------------------------
;                      Update TLB (Translation Lookaside Buffer)
; -----------------------------------------------------------------------------

FlushPageCache:	push	eax		; push EAX
		mov	eax,cr3		; get CR3 register
		mov	cr3,eax		; set CR3 register (flush cache)
		pop	eax		; pop EAX
		ret

; -----------------------------------------------------------------------------
;                         Flush CPU global page cache
; -----------------------------------------------------------------------------

; ------------- Push registers

;FlushTLBGlobal:	push	eax		; push EAX
;		mov	eax,cr4		; get CR4 register
;		push	eax		; push EAX

; ------------- Disable flags

;		and	eax,B0+B1	; clear bit 3
;		mov	cr4,eax		; set CR4 register		

; ------------- Flush CPU page cache

;		mov	eax,cr3		; get CR3 register
;		mov	cr3,eax		; set CR3 register

; ------------- Pop registers

;		pop	eax		; pop EAX
;		mov	cr4,eax		; return CR4 register
;		pop	eax		; pop EAX
;		ret

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA_SECTION

		align	4, db 0
CPUNum:		dd	1		; number of CPUs

CPUMask:	dd	B0		; mask of available CPUs

; ------------- IRQ handler for FPU

		align	8, db 0
FPUIRQHandler:	LISTHEAD		; link to next IRQ handler
		dd	0		; pointer to IRQ descriptor
		dw	INT_ACTIVE	; IRQ flags
		db	13		; current IRQ number
		db	13		; recomended best IRQ number
		dd	B13		; mask of usable IRQs (1=enabled)
		dd	0		; user data (NULL=disabled)
		dd	0		; counter for slow interrupts
		dd	0		; fast handler (NULL=none)
		dd	0		; slow handler (NULL=none)
		dd	0		; callback (NULL=none)
