; =============================================================================
;
;                   Litos - Start kernel, protected mode
;
; =============================================================================

%ifdef DEBUG
;%define	DEBUG_TIME		; uncomment this to display date+time
;%define	DEBUG_INS		; uncomment this to display instruct.
					; (it can be combined with DEBUG_CPU)
;%define	DEBUG_CALEND		; uncomment this to check calendar
;%define	DEBUG_TASK		; uncomment this to test tasks
;%define	DEBUG_ALARM		; uncomment this to test alarm
;%define	DEBUG_RBTREE		; uncomment this to test Red-black tree
%define	DEBUG_DEVLIST		; display list of devices
;%define	DEBUG_ASCII		; display test
;%define	DEBUG_ASCII2		; display test
;%define	DEBUG_ANSI		; display ansi test
;%define	DEBUG_CODEPAGE		; uncomment this to test code pages
;%define	DEBUG_UNICHECK		; check Unicode character types
;%define	DEBUG_FONTNUM		; uncomment this to display font number
;%define	DEBUG_NATION		; display national descriptor
%endif

		CODE_SECTION

; -----------------------------------------------------------------------------
;                  Start kernel (jump here from INIT\INIT_32.ASM)
; -----------------------------------------------------------------------------

; ------------- Initialize memory page map (KERNEL\PAGE.ASM)

StartKernel:	call	PageMapInit	; initialize memory page map

; ------------- Initialize system memory allocator (KERNEL\SYSMEM.ASM)

		call	SysMemInit	; initialize system memory allocator

; ------------- Initialize TSS list (KERNEL\TASK.ASM)

		call	InitTSS		; initialize TSS list

; ------------- Initialize traps (KERNEL\TRAPS.ASM)

		call	TrapInit	; initialize traps

; ------------- Initialize basic system devices (DRIVERS\DEVICE.ASM)

		call	DevBaseInit	; initialize basic devices

; ------------- Read time from CMOS real-time clock (DRIVERS\SYSTEM\CMOS.ASM)

		call	GetCMOSTime	; get CMOS time
;		add	eax,[CMOSTimeOff] ; add CMOS time offset LOW
;		add	edx,[CMOSTimeOff+4] ; add CMOD time offset HIGH
		call	SetCurrentTime	; set current time






; ------------- Recalculate performance coefficients (KERNEL\TIME.ASM)

		call	PerfCoefRecalc	; recalculate performance coefficients










; ------------- Initialize swap area tables (KERNEL\SWAP.ASM)

		call	SwapCacheInit	; initialize swap area tables

; ------------- Initialize alarm list (KERNEL\ALARM.ASM)

		call	AlarmListInit	; initialize alarm list

; ------------- Initialize scheduler (KERNEL\SCHEDULE.ASM)

		call	SchedInit	; initialize scheduler

; ------------- Initialize idle task for this CPU (KERNEL\TASK.ASM)

		xor	edx,edx		; EDX <- 0, index of this CPU
		call	IdleInit	; initialize idle task
		call	ProcRootLink	; link task to root process
		lea	esp,[ebx+TASK_Stack] ; initialize stack address
		mov	[ebx+TASK_ESP],esp ; stack
		ltr	[ebx+TASK_TR]	; load task register
		lldt	[ebx+TASK_LDT]	; load LST selector







; ------------- Initialize console interfaces (DRIVERS\CONSOLE.ASM)

		call	ConInit		; initialize console interfaces















; ------------- Reinitialize alarm list start time (KERNEL\ALARM.ASM)

		call	AlarmReInit	; reinitialize alarm list start time







%ifdef DEBUG_TIME
		call	DebDispTime	; debug display date and time
%endif


; ------------- Initialize character mapping (UTIL\CHARSET.ASM)

		call	CharTabInit	; initialize character mapping

; ------------- Initialize font tables (DRIVERS\FONT\FONT.ASM)

		call	FontInit	; initialize font tables

; ------------- Debug text codepages
%ifdef DEBUG_CODEPAGE
		call	CharTabTest	; test character set tables
%endif
; ------------- Debug cgeck Unicode character types
%ifdef DEBUG_UNICHECK
		call	CheckUniType	; check unicode character types
%endif
; ------------- Debug check fixed fonts
%ifdef DEBUG_FONTNUM
		call	FixFontTest	; test fixed fonts
%endif
; ------------- Initialize nationality descriptors (UTIL\LANG.ASM)

		call	NationInit	; initialize nationality descriptors

; ------------- Initialize standard system drivers and resources

		call	DevStdInit	; initialize system devices

%ifdef	DEBUG_DEVLIST
		call	DevLstDisp	; display list of devices
%endif















; ------------- Initialize display driver

;		call	VGAInit		; initialite display driver

; ------------- Initialize keyboard driver

;		call	KeybInit	; initialize keyboard driver

; ------------- Initialize VT102 terminal emulator

;		call	VTInit		; initialize VT102 terminal emulator


		sti
abcd:		;inc	dword [SYSTEM_ADDR+0b8004h]

%ifdef DEBUG_TIME
;		call	DebDispTime	; debug display date and time
;		pushf
;		call	TimerInt
%endif


;		jmp	abcd




; ------------- Load fonts

		mov	ebx,EGADevDDPB
		mov	ecx,DispCharTab
		mov	edx,CP1250ToUniTab
		mov	esi,DispCharTabLat
		mov	edi,F14
;		call	DispLoadSet
		mov	cl,0
		mov	dl,1
;		call	DispSetFont


;		inc	dword [SYSTEM_ADDR+0b8004h]


; ------------- Debug check and display national descriptors
%ifdef DEBUG_NATION
		call	DebCheckNat	; check national descriptors
		mov	eax,0		; EAX <- descriptor index
		call	DebDispNat	; display national descriptor
		mov	eax,1		; EAX <- descriptor index
		call	DebDispNat	; display national descriptor
%endif





;		mov	eax,100000
;		call	UDelay

;		mov	ebx,DebText10
;		mov	eax,DebText11
;		call	TextTrimUnList
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebNewLine

;		mov	ebx,DebText12
;		mov	esi,[ebx]
;		call	DebOutTextData
 ;
;		mov	eax,DebText12
;		mov	ebx,DebText11
;		call	TextSmaCap
;		mov	esi,[ebx]
;		call	DebOutTextData
 ;
;		mov	eax,DebText11
;		mov	ebx,DebText12
;		call	TextSmall
;		mov	esi,[ebx]
;;		call	DebOutTextData
		
;		mov	eax,DebText12
;		mov	ebx,DebText11
;		call	TextCap
;		mov	esi,[ebx]
;		call	DebOutTextData




;		mov	ecx,NatTabEN
;		mov	ebx,0
;		mov	bh,10
;		mov	bl,0
;		bts	ebx,FORMFLAG_Thsn_b
;;		bts	ebx,FORMFLAG_Alt2_b
;;		bts	ebx,FORMFLAG_Prec_b
;		bts	ebx,FORMFLAG_Alt_b
;		mov	esi,15
;		mov	edi,TESTTESTBUF
;		fld	tword [DebTest1]
;		call	FltToTextBuf
;		mov	byte [edi],0
;		ffreep	st0
;
;		mov	esi,TESTTESTBUF
;		call	DebOutText





%if 0
		mov	eax,07fh

		call	TextFindCharLast
		xchg	eax,edx
		call	DebOutNumSig
		call	DebOutSpc
		xchg	eax,edx

		call	TextFindCharRev
		xchg	eax,edx
		call	DebOutNumSig
		call	DebOutSpc
		xchg	eax,edx

		dec	edx
		call	TextFindCharRev
		xchg	eax,edx
		call	DebOutNumSig
		call	DebOutSpc
		xchg	eax,edx

		dec	edx
		call	TextFindCharRev
		xchg	eax,edx
		call	DebOutNumSig
		call	DebOutSpc
		xchg	eax,edx

		dec	edx
		call	TextFindCharRev
		xchg	eax,edx
		call	DebOutNumSig
		call	DebOutSpc
		xchg	eax,edx
%endif

%macro	DEBKKK 1
		mov	al,"["
		call	DebOutChar
		call	GetCMOSTime	; get CMOS time
		mov	ebp,[%1]
		mov	ebx,[ebp+TEXT_Length]
		add	ebp,TEXT_Text
		mov	esi,150
		mov	edi,TESTTESTBUF
		call	FormAbsDateTime
		mov	byte [edi],"]"
		mov	byte [edi+1],0
		mov	esi,TESTTESTBUF2
		sub	edi,TESTTESTBUF
		mov	dword [esi],CTEXTREF
		mov	dword [esi+4],1
		add	[esi+4],edi
		call	DebOutTextData
		call	DebNewLine

		call	FormAbsDateTimeN
		cmp	esi,edi
		je	%%L1
		mov	eax,esi
		call	DebOutNum
		call	DebOutSpc
		mov	eax,edi
		call	DebOutNum
		mov	esi,%%L2
		call	DebOutText
		jmp	%%L1
 
%%L2:		db	' !!!!!! ERROR !!!!!!!!',10,0

%%L1:

%endmacro

%if 0
		mov	ecx,NatTabEN
		DEBKKK DebTextDT1
		DEBKKK DebTextDT2
		DEBKKK DebTextDT3
		DEBKKK DebTextDT4
		DEBKKK DebTextDT5
		call	DebNewLine

		mov	ecx,NatTabCZ
		DEBKKK DebTextDT1
		DEBKKK DebTextDT2
		DEBKKK DebTextDT3
		DEBKKK DebTextDT4
		DEBKKK DebTextDT5
		call	DebNewLine



;		xor	ecx,ecx

;		call	GetCMOSTime	; get CMOS time
;		mov	ebx,DebText

;		xor	edx,edx

;		call	TextAddShrtTime
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	TextEmpty
;		call	TextAddLongTime
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	TextEmpty
;		call	TextAddShrtDate
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	TextEmpty
;		call	TextAddLongDate
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	DebNewLine


;
;		mov	ecx,NatTabCZ

;		mov	ebx,DebText

;		call	TextEmpty
;		call	TextAddShrtTime
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	TextEmpty
;		call	TextAddLongTime
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	TextEmpty
;		call	TextAddShrtDate
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		call	TextEmpty
;		call	TextAddLongDate
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc
 ;
;		call	DebNewLine
	
%endif


%macro		DEBTESTINT 2

		mov	al,"["
		call	DebOutChar

		mov	edi,TESTTESTBUF
		mov	esi,100
		mov	eax,%1
		mov	ecx,%2
		call	SDWToTextBufN
		mov	byte [TESTTESTBUF+eax],"]"

		mov	dword [TESTTESTBUF+eax+1],0
		mov	dword [TESTTESTBUF+eax+5],0
		mov	dword [TESTTESTBUF+eax+9],0
		mov	dword [TESTTESTBUF+eax+13],0

		mov	eax,%1
		call	SDWToTextBuf
		mov	esi,TESTTESTBUF
		call	DebOutText
		call	DebNewLine

%endmacro

;		DEBTESTINT 0,1
;		DEBTESTINT 123,0
;		DEBTESTINT 123,2
;		DEBTESTINT 123,6
;		DEBTESTINT 1235678,10
;		DEBTESTINT -12345678,0
;		DEBTESTINT -12345678,20


;		mov	ebx,DebText
;		call	TextEmpty
;		fld	tword [DebTestFPU1]
;		mov	eax,DebText2
;		call	TextAddFormatF
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		mov	ebx,DebText
;		call	TextEmpty
;		fld	tword [DebTestFPU1]
;		mov	eax,DebText3
;		call	TextAddFormatF
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		mov	ebx,DebText
;		call	TextEmpty
;		fld	tword [DebTestFPU5]
;		mov	eax,DebText4
;		call	TextAddFormatF
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebOutSpc

;		mov	ebx,DebText
;		call	TextEmpty
;		fld	tword [DebTestFPU5]
;		mov	eax,DebText5
;		call	TextAddFormatF
;		mov	esi,[ebx]
;		call	DebOutTextData
;		call	DebNewLine


;		mov	ebx,DebText
;		call	TextEmpty
;		mov	eax,DebText3
;		mov	edx,12345678h
;		call	TextAddFormatDW
;		mov	esi,[ebx]
;		call	DebOutTextData

;		mov	ebx,DebText
;		call	TextEmpty
;		mov	eax,DebText4
;		fld	tword [DebTestFPU1]
;		call	TextAddFormatF
;		mov	esi,[ebx]
;		call	DebOutTextData

;		mov	ebx,DebText
;		call	TextEmpty
;		mov	eax,DebText5
;		fld	tword [DebTestFPU4]
;		call	TextAddFormatF
;		mov	esi,[ebx]
;		call	DebOutTextData






;		mov	al,"["
;		call	DebOutChar

;		mov	ebx,DebText
;		mov	eax,12345678h
;		mov	edx,87654321h
;		xor	ecx,ecx
;		mov	cl,10
;		mov	ch,75
;		bts	ecx,FORMFLAG_Cent_b
;		bts	ecx,FORMFLAG_Thsn_b
;		fld	tword [DebTestFPU1]
;		xor	esi,esi
;		call	TextAddFormMix
;		ffreep	st0

;		fld	tword [DebTestFPU3]
;		mov	esi,NatTabCZ
;		call	TextAddFormExp
;		ffreep	st0

;		fld	tword [DebTestFPU4]
;		call	TextAddFormMix
;		ffreep	st0


;		mov	esi,[ebx]
;		call	DebOutTextData

;		mov	al,"]"
;		call	DebOutChar

;		call	DebNewLine





%if 0

;		fld	tword [DebTestFPU5]
;		fmul	qword [DebTestFPU52]
;		fstp	tword [DebTestFPU5]

;		fld	tword [DebTestFPU10]
;		fmul	qword [DebTestFPU52]
;		fstp	tword [DebTestFPU10]

;		fld	tword [DebTestFPU15]
;		fmul	qword [DebTestFPU52]
;		fstp	tword [DebTestFPU15]


;		fld	tword [DebTestFPU4]
;		fmul	qword [DebTestFPU53]
;		fstp	tword [DebTestFPU4]

;		fld	tword [DebTestFPU9]
;		fmul	qword [DebTestFPU53]
;		fstp	tword [DebTestFPU9]

;		fld	tword [DebTestFPU14]
;		fmul	qword [DebTestFPU53]
;		fstp	tword [DebTestFPU14]



%macro	DISPHEX 0

		pusha
;		mov	bh,0
;		bts	ebx,FORMFLAG_Alt2_b
		bts	ebx,FORMFLAG_Prec_b
;		bts	ebx,FORMFLAG_Alt_b
;		bts	ebx,FORMFLAG_Zero_b
;		bts	ebx,FORMFLAG_Thsn_b
;		bts	ebx,FORMFLAG_Left_b

		mov	byte [TESTTESTBUF],"["		

		mov	esi,eax
		mov	edi,edx
		call	PerfGetUS
		push	eax
		mov	edx,edi
		mov	eax,esi

		call	FltToTextBufN
		call	DebOutNum
		call	DebOutSpc
		mov	eax,esi

		mov	ebp,1000
%%K1:		mov	ecx,NatTabEN
		mov	edi,TESTTESTBUF+1
		mov	esi,70
		call	ExpCToTextBuf
		dec	ebp
;		jnz	%%K1

		call	FltToTextBufN
		add	eax,TESTTESTBUF+1
		cmp	eax,edi
		je	%%K12

;		mov	esi,%%K13
;		call	DebOutText
;		jmp	$
;%%K13:		db	'ERRRR',0

%%K12:


		ffreep	st0

		call	PerfGetUS
		mov	ebx,eax

		mov	al,"]"
		stosb
		mov	al,0
		stosb
		mov	esi,TESTTESTBUF
		call	DebOutText

		call	DebOutSpc

		pop	ecx

		mov	eax,ebx
		sub	eax,ecx
		sub	eax,[DebTestXXX]
		call	DebOutNum

		call	DebNewLine

		popa


		pusha
		mov	bh,30
		bts	ebx,FORMFLAG_Alt2_b
		bts	ebx,FORMFLAG_Prec_b
;		bts	ebx,FORMFLAG_Zero_b
		bts	ebx,FORMFLAG_Thsn_b
		bts	ebx,FORMFLAG_Cent_b
;		bts	ebx,FORMFLAG_Left_b

		mov	byte [TESTTESTBUF],"["		

		mov	esi,eax
		mov	edi,edx
		call	PerfGetUS
		push	eax
		mov	edx,edi
		mov	eax,esi

;		call	FltToTextBufN
;		call	DebOutNum
;		call	DebOutSpc
;		mov	eax,esi

		mov	ebp,1000
%%K2:		mov	ecx,NatTabEN
		mov	edi,TESTTESTBUF+1
		mov	esi,70
		call	ExpSToTextBuf
		dec	ebp
;		jnz	%%K2

		call	FltToTextBufN
		add	eax,TESTTESTBUF+1
		cmp	eax,edi
		je	%%K22

;		mov	esi,%%K23
;		call	DebOutText
;		jmp	$
;%%K23:		db	'ERRRR',0

%%K22:



		ffreep	st0

		call	PerfGetUS
		mov	ebx,eax

		mov	al,"]"
		stosb
		mov	al,0
		stosb
		mov	esi,TESTTESTBUF
		call	DebOutText

		call	DebOutSpc

		pop	ecx

		mov	eax,ebx
		sub	eax,ecx
		sub	eax,[DebTestXXX]
		call	DebOutNum

		call	DebNewLine

		popa





;		add	bh,1

%endmacro




		call	PerfGetUS
		push	eax
		mov	edx,edi
		mov	eax,esi

		mov	ebp,1000
K1A1:		mov	ecx,NatTabEN
		mov	edi,TESTTESTBUF+1
		mov	esi,80
		dec	ebp
;		jnz	K1A1

		call	PerfGetUS
		mov	ebx,eax
		pop	ecx
		mov	eax,ebx
		sub	eax,ecx
		mov	[DebTestXXX],eax
		call	DebOutNum

		call	DebNewLine




		xor	ebx,ebx
;		mov	bh,0

;		mov	edx,0 ;12h
;		mov	eax,1234567890 ;3456789Ah

		mov	bl,0


		fld	tword [DebTestFPU2]
		fld	tword [DebTestFPU1]
;		xor	edx,edx
;		xor	eax,eax
		DISPHEX


		mov	bl,2

;		xor	edx,edx
;		mov	eax,9h

		fld	tword [DebTestFPU4]
		fld	tword [DebTestFPU3]

		DISPHEX

		mov	bl,4

		xor	edx,edx
		mov	eax,12345h

		fld	tword [DebTestFPU6]
		fld	tword [DebTestFPU5]
		DISPHEX

		mov	bl,6

		fld	tword [DebTestFPU8]
		fld	tword [DebTestFPU7]
		DISPHEX


		mov	bl,8

		fld	tword [DebTestFPU10]
		fld	tword [DebTestFPU9]
		DISPHEX

		mov	bl,12
 ;
		fld	tword [DebTestFPU12]
		fld	tword [DebTestFPU11]
		DISPHEX

		mov	bl,17

		fld	tword [DebTestFPU14]
		fld	tword [DebTestFPU13]
		DISPHEX

		mov	bl,22

		fld	qword [DebTestFPU14]
		fld	tword [DebTestFPU15]
		DISPHEX


;		fld1
;		fldz
;		fdivp	st1,st0
;		fld	st0
;		DISPHEX


		xor	edx,edx
		mov	eax,1234567890
;		DISPHEX


		mov	edx,7048h
		mov	eax,860DDF79h

		neg	eax
		adc	edx,0
		neg	edx

;		DISPHEX

		mov	edx,112210F4h
		mov	eax,7DE98115h

		neg	eax
		adc	edx,0
		neg	edx

;		DISPHEX

		mov	edx,0b1234567h
		mov	eax,12345678h

;		DISPHEX

%endif


%if 0
		mov	eax,100000
		call	UDelay
		call	DebNewLine

		fld	tword [DebTestFPU5]
		fmul	qword [DebTestFPU52]
		fstp	tword [DebTestFPU5]

		fld	tword [DebTestFPU10]
		fmul	qword [DebTestFPU52]
		fstp	tword [DebTestFPU10]

		fld	tword [DebTestFPU15]
		fmul	qword [DebTestFPU52]
		fstp	tword [DebTestFPU15]


%macro		TIMEDELM 1

		call	PerfGetUS
		xchg	eax,ebx

		mov	ecx,1000
%%TimeDel12:	mov	edi,TESTTESTBUF+98
		fld	tword [%1]
		call	FloatToTextBuf
		loop	%%TimeDel12

		call	PerfGetUS

		mov	esi,edi
		inc	esi
		call	DebOutText

		call	DebOutSpc

		sub	eax,ebx
		call	DebOutNum

		call	DebOutTab

		call	PerfGetUS
		xchg	eax,ebx

		mov	ecx,1000
%%TimeDel14:	mov	edi,TESTTESTBUF+98
		fld	tword [%1]
		call	Floa2ToTextBuf
		loop	%%TimeDel14

		call	PerfGetUS

		mov	esi,edi
		inc	esi
		call	DebOutText

		call	DebOutSpc

		sub	eax,ebx
		call	DebOutNum

		call	DebNewLine
%endmacro


		TIMEDELM DebTestFPU1
		TIMEDELM DebTestFPU2
		TIMEDELM DebTestFPU3
		TIMEDELM DebTestFPU4
		TIMEDELM DebTestFPU5

		call	DebNewLine

		TIMEDELM DebTestFPU6
		TIMEDELM DebTestFPU7
		TIMEDELM DebTestFPU8
		TIMEDELM DebTestFPU9
		TIMEDELM DebTestFPU10

		call	DebNewLine

		TIMEDELM DebTestFPU11
		TIMEDELM DebTestFPU12
		TIMEDELM DebTestFPU13
		TIMEDELM DebTestFPU14
		TIMEDELM DebTestFPU15
%endif


;		mov	eax,123
;		call	DWordToTextBuf
;		call	QWordToTextBuf


;%macro	TESTLOOP 3
;		mov	byte [TESTTESTBUF+99],0
;		call	PerfGetUS
;		mov	ebx,eax
;		mov	ecx,1000
;		mov	eax,%1
;		mov	edx,%2		
;%%L1:		mov	edi,TESTTESTBUF+98
;		call	%3
;		loop	%%L1
;		call	PerfGetUS
;		sub	eax,ebx
;		call	DebOutNum
;		mov	al,"("
;		call	DebOutChar
;		mov	esi,edi
;		inc	esi
;		call	DebOutText
;		mov	al,")"
;		call	DebOutChar
;%endmacro
;
;		call	PerfGetUS
;		mov	ebx,eax
;		mov	ecx,1000
;		mov	eax,123
;		mov	edx,123
;TestTxtA1:	mov	edi,TESTTESTBUF+99
;		loop	TestTxtA1
;		call	PerfGetUS
;		sub	eax,ebx
;		call	DebOutNum
;		call	DebNewLine
;		call	DebNewLine

;		TESTLOOP 1,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 1,0,QWordToTextBuf
;		call	DebNewLine

;		TESTLOOP 12,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 12,0,QWordToTextBuf
;		call	DebNewLine

;		TESTLOOP 123,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 123,0,QWordToTextBuf
;		call	DebNewLine

;		TESTLOOP 1234,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 1234,0,QWordToTextBuf
;		call	DebNewLine
 ;
;		TESTLOOP 12345,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 12345,0,QWordToTextBuf
;		call	DebNewLine

;		TESTLOOP 123456,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 123456,0,QWordToTextBuf
;		call	DebNewLine
 ;
;		TESTLOOP 1234567,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 1234567,0,QWordToTextBuf
;		call	DebNewLine

;		TESTLOOP 12345678,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 12345678,0,QWordToTextBuf
;		call	DebNewLine
 ;
;		TESTLOOP 123456789,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 123456789,0,QWordToTextBuf
;;		call	DebNewLine

;		TESTLOOP 1234567890,0,DWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 1234567890,0,QWordToTextBuf
;		call	DebNewLine
 ;
;		call	DebNewLine

;		TESTLOOP 0DFDC1C35h, 2,QWordToTextBuf
;		call	DebOutSpc
;		TESTLOOP 0EB1F0AD2h, 0AB54A98Ch,QWordToTextBuf
;		call	DebNewLine
 ;
;		call	DebNewLine

		




; ------------- Check EISA bus

;		mov	esi,0fffd9h	; ESI <- bus identification
;		cmp	dword [esi],"EISA" ; is EISA bus?
;		jne	StartKernel2	; it is not EISA
;		cmp	byte [esi+4],0	; ASCIIT terminator
;		jne	StartKernel2	; it is not EISA
;		inc	byte [IsEISA]	; set EISA flag

; ------------- Check PCI/ISA bus

;StartKernel2:	cmp	dword [esi],"PCI/" ; is PCI/ISA bus?
;		jne	StartKernel3	; it is not EISA
;		cmp	dword [esi+4],"ISA" ; is PCI/ISA bus?
;		jne	StartKernel3	; it is not EISA
;		inc	byte [IsPCIISA]	; set PCI/ISA flag

; ------------- Debug display instruction statistics
%ifdef DEBUG_INS
		call	DebDispIns	; dispaly instructions
%endif
; ------------- Debug test red-black tree
%ifdef DEBUG_RBTREE
		call	TestRBTree	; test red-black tree
%endif
; ------------- Debug test calendar
%ifdef DEBUG_CALEND
		call	DebTestCal	; debug test calendar
%endif
; ------------- Enable interrupts

		sti

;abcd:		jmp	abcd

%ifdef DEBUG_ANSI

		mov	edi,SYSTEM_ADDR+0b8000h
		mov	al,0dbh
		mov	ah,0
		mov	ecx,16
ABCD:		stosw
		stosw
		inc	ah
		loop	ABCD

		mov	eax,kkkktxt
		mov	ecx,kkkktxt2-kkkktxt
		call	ConMWriteAct

		jmp	kkkktxt2

kkkktxt:	
	db	CSI,'40m',CSI,'H',LF,CSI,'16C',CSI,'0;32m',CSI,'19C'
	db	CSI,'37m',CSI,'5C',CSI,'1;30m',CSI,'0;33m'
	db	CSI,'1;30m',CSI,'0;33m'
	db	CSI,'1;30m',CSI,'0m',CSI,'31m',CSI,'7C'
	db	CSI,'1;37m   ',CSI,'0;32m   '
	db	CSI,'1;37m',CSI,'10C',CSI,'0m',CSI,'8C',CSI,'33m'
	db	CSI,'19C',CSI,'8C',CSI,'37m',CSI,'31m',CSI,'6C'
	db	CSI,'1;37m',CSI,'0;32m'
	db	CSI,'1;37m',CSI,'8C',CSI,'0m   ',CSI,'33m'
	db	'   ',CSI,'31m'
	db	CSI,'7C',CSI,'1;37m',CSI,'0;32m'
	db	CSI,'1;37m',CSI,'9C',CSI,'0m   ',CSI,'33m '
	db	CSI,'1;34m        ڿ  Ŀ Ŀ  '
	db	CSI,'0;33m   ',CSI,'31m',CSI,'11C',CSI,'32m'
	db	CSI,'13C',CSI,'37m   ',CSI,'33m ',CSI,'1;34m'
	db	'      Ŀ Ŀ ',CSI,'0;33m   '
	db	CSI,'31m',CSI,'10C',CSI,'37m',CSI,'1;33m',CSI,'34m'
	db	'o',CSI,'33m',CSI,'34mo',CSI,'33m'
	db	CSI,'0m',CSI,'12C   ',CSI,'33m  '
	db	CSI,'1;34m           '
	db	CSI,'0;33m   ',CSI,'31m',CSI,'9C',CSI,'37m'
	db	CSI,'1;33m',CSI,'41m ',CSI,'40m'
	db	CSI,'0m',CSI,'10C  ',CSI,'33m',CSI,'9C'
	db	CSI,'1;34mĿĿڿ ',CSI,'9C',CSI,'0;33m   '
	db	CSI,'31m',CSI,'8C',CSI,'37m'
	db	CSI,'1;33m',CSI,'47m ',CSI,'0;41m ',CSI,'1;33;47m '
	db	CSI,'40m',CSI,'0m',CSI,'7C',CSI,'1;33m'
	db	CSI,'30;47m',CSI,'40m ',CSI,'0;33m',CSI,'9C'
	db	CSI,'1;34m    ',CSI,'9C',CSI,'0;33m'
	db	'   ',CSI,'31m',CSI,'7C',CSI,'37m',CSI,'47m  '
	db	CSI,'1;33;40m',CSI,'47m',CSI,'41m',CSI,'47m'
	db	CSI,'40m',CSI,'40m',CSI,'0m '
	db	CSI,'1m  ',CSI,'33m ',CSI,'0;33m',CSI,'9C'
	db	CSI,'1;34m ',CSI,'9C'
	db	CSI,'0;33m   ',CSI,'31m',CSI,'7C',CSI,'37m'
	db	CSI,'32;47m  ',CSI,'1;33m',CSI,'40m',CSI,'41m'
	db	CSI,'40m',CSI,'0;5;30;41m'
	db	CSI,'0;1;33;41m',CSI,'40m',CSI,'47m ',CSI,'0m'
	db	CSI,'1m',CSI,'33m '
	db	CSI,'0;33m   '
	db	CSI,'31m   ',CSI,'32m',CSI,'37m'
	db	CSI,'32m',CSI,'47m',CSI,'37;40m',CSI,'32;47m'
	db	CSI,'37;40m',CSI,'5;31;47m ',CSI,'0m'
	db	CSI,'32;47m',CSI,'37;40m',CSI,'32;47m',CSI,'40m'
	db	CSI,'37m',CSI,'32;47m',CSI,'1;37;40m',CSI,'33m '
	db	'',CSI,'47m',CSI,'40m',CSI,'6C',CSI,'30m'
	db	CSI,'36mڿڿ',CSI,'30m',CSI,'36mڿڿڿ ڿڿ',CSI,'9C'
	db	CSI,'0;31m ',CSI,'32m'
	db	CSI,'37;42m ',CSI,'32;40m',CSI,'37m',CSI,'42m '
	db	CSI,'40m',CSI,'42m ',CSI,'40m',CSI,'32;47m'
	db	CSI,'37;40m',CSI,'42m',CSI,'32;40m',CSI,'1;37m'
	db	CSI,'15C',CSI,'30m',CSI,'36mô'
	db	CSI,'30m',CSI,'36môÿ ĳ',CSI,'9C',CSI,'0;31m'
	db	CSI,'32m  ',CSI,'42m  ',CSI,'40m'
	db	CSI,'40m',CSI,'42m  ',CSI,'40m'
	db	CSI,'1;37m',CSI,'16C',CSI,'30m ',CSI,'36m'
	db	CSI,'30m',CSI,'36m   ',CSI,'9C'
	db	CSI,'0;31m',CSI,'32m    '
	db	CSI,'1;37;42m',CSI,'40m',CSI,'42m '
	db	CSI,'40m',CSI,'48C',CSI,'0;31m',CSI,'32m    '
	db	CSI,'33;42m',CSI,'32;40m'
	db	CSI,'49C',CSI,'31m',CSI,'32m    ',CSI,'1;37m'
	db	CSI,'0;33m',CSI,'1;37;43m',CSI,'40m'
	db	CSI,'43m',CSI,'0;33m',CSI,'1;37m',CSI,'49C'
	db	CSI,'0;31m',CSI,'32m  '
	db	CSI,'1;37;42m',CSI,'0;33m',CSI,'1;37;43m'
	db	CSI,'0;33m',CSI,'1;37;42m',CSI,'49C',CSI,'40m'
	db	CSI,'42m',CSI,'0;31m ',CSI,'32m '
	db	CSI,'42m   ',CSI,'43m',CSI,'42m         ',CSI,'40m'
	db	CSI,'42m',CSI,'49C',CSI,'31;40m  '
	db	CSI,'32m ',CSI,'43m',CSI,'40m'
	db	CSI,'49C',CSI,'31m    ',CSI,'32m '
	db	CSI,'1;37m',CSI,'50C',CSI,'0;31m'
	db	CSI,'7C',CSI,'1;37m  '
	db	CSI,'49C',CSI,'0;31m',CSI,'6C'
	db	CSI,'33m  ',CSI,'48C'
	db	CSI,'31m',CSI,'5C',CSI,'33m  '
	db	CSI,'12C',CSI,'1;37mANS By: ',CSI,'0;31mOp'
	db	CSI,'1mus ',CSI,'33mOut',CSI,'32mla',CSI,'34mnd ',CSI,'35m<'
	db	CSI,'31mA',CSI,'35m.',CSI,'33mA',CSI,'35m.'
	db	CSI,'34mA',CSI,'35m>',CSI,'6C',CSI,'0;31m',CSI,'0m'

kkkktxt2:

%endif

%ifdef DEBUG_ASCII2

		mov	ebx,EGADevDDPB

		mov	ecx,0
		mov	edx,1
		call	DispSetCursor

		mov	ecx,8
		mov	edx,14
		call	DispSetCurSize

		mov	al,0
		call	DispSetVisible

		mov	al,1
		call	DispSetVisible

		mov	edx,EGA8Pal
		call	DispSetPalEGA

		call	DispClear

		mov	ecx,DispCharTab
;		mov	edx,CP437ToUniTab

		mov	edx,CP1250ToUniTab

		mov	esi,DispCharTabLat
		mov	edi,F14
		call	DispLoadSet

		mov	cl,0
		mov	dl,1
		call	DispSetFont

		mov	edx,DispKA3
		mov	esi,DispKT3
		mov	ebp,8
		call	DispKKKK

%endif


%ifdef DEBUG_ASCII

		mov	ebx,EGADevDDPB	; EBX <- driver parameter block

		xor	ecx,ecx
		xor	edx,edx
		call	TXTSetCursor

		mov	al,13h
		call	TXTSetColor

		mov	ecx,100
		mov	edx,100
		mov	al," "
		call	TXTFillUp

		mov	al,17h
		call	TXTSetColor

		xor	ecx,ecx
		xor	edx,edx
		call	TXTSetCur

		mov	edx,BootMessage+2
		mov	ecx,BootMessage2-BootMessage-5
		call	TXTWriteStr

		xor	ecx,ecx
		xor	edx,edx
		mov	dl,2
		call	TXTSetCur

		mov	al,13h
		call	TXTSetColor

		mov	edx,DispTestText
		mov	ecx,DispTestText2-DispTestText
		call	TXTWriteStr


		mov	edx,F08X16
		call	EGASetFont

		mov	edx,EgaStdPal ;EGA8Pal ;EGAStdPal
		call	EGASetPal

		mov	esi,6
		mov	edi,4
		xor	ebp,ebp
		call	DispASCII

		mov	esi,41
		mov	edi,4
		mov	ebp,256
		call	DispASCII

		mov	al,17h
		call	TXTSetColor

		xor	ecx,ecx
		xor	edx,edx
		mov	dl,23
		call	TXTSetCur
		mov	ebx,VTEBuff	; EBX <- VT102 first terminal
		mov	[ebx+VTE_PosX],ecx
		mov	[ebx+VTE_PosY],edx
%endif

;PageFaultTest:	mov	[0fffffff0h],esi ; test Page Fault

; ------------- Initialize keyboard

;		call	KeybSetSetup	; setup keyboard

; ------------- Generate initialization task

		call	TaskClone	; clone idle task
		or	eax,eax		; is it cloned task?
		jz	InitTask	; jump to initialization task

; ------------- Debug alarm test (it shifts characters in 1st line)
%ifdef	DEBUG_ALARM		
		xor	ecx,ecx		; ECX <- 0 (character position)
		mov	eax,1		; EAX <- 1 (interval)
AlarmTest1:	mov	edx,AlarmTestFunc ; EDX <- alarm test function
		call	AlarmCreate	; create alarm structure (-> EBX)
		inc	ecx		; increase character position
		inc	eax		; EAX <- increase interval
		cmp	ecx,60		; position 0 to 59?
		jb	AlarmTest2	; it is position 0 to 59
		mov	edx,ecx		; EDX <- position
		sub	edx,59		; EDX <- 1, 2, ...
		mov	eax,300		; EAX <- 300
		mul	edx		; EAX <- 300ms to 6 s
AlarmTest2:	push	ecx		; push ECX (character position)
		push	eax		; push EAX (interval)
		mov	ecx,eax		; ECX <- alarm repeat interval
		call	AlarmSetInt	; set alarm interval
		call	AlarmStart	; start alarm
		pop	eax		; pop EAX (interval)
		pop	ecx		; pop ECX (character position)
		cmp	ecx,80		; all characters?
		jb	AlarmTest1	; create next alarm
%endif
; ------------- Debug clone tasks
%ifdef	DEBUG_TASK
		mov	esi,7
		xor	eax,eax
		mov	ax,[VideoSegm]
		shl	eax,4
		add	eax,SYSTEM_ADDR
		add	eax,80*2*18
		xchg	eax,edi
		mov	bh,7bh
DebCloneTask2:	call	TaskClone
		or	eax,eax
		jz	DebTask
		sub	edi,2*80*2
		sub	bh,10h
		dec	esi
		jnz	DebCloneTask2
%endif
; ---- Idle loop

Idle:
%ifdef	DEBUG_TASK
		mov	ah,bh
		mov	al,"I"
		stosw
		mov	al,"d"
		stosw
		mov	al,"l"
		stosw
		mov	al,"e"
		stosw
		mov	al," "
		stosw
		mov	al,":"
		stosw
		add	edi,2*2
%endif
IdleLoop:

%ifdef DEBUG_TIME
		call	DebDispTime	; debug display date and time
%endif

;%ifdef DEBUG_ASCII
		call	ConReadAct
		jc	KKKK2
		call	ConWriteAct

KKKK2:
;%endif

%ifdef	DEBUG_TASK
		inc	byte [edi]
%endif
		jmp	IdleLoop


; ------------- Initialization task (idle task cannot sleep)

InitTask:

; ------------- Initialize floppy disk driver

		call	FDInit		; initialize floppy disk driver

; ------------- Display list of devices
%ifdef	DEBUG_DEVLIST
;		call	DevLstDisp	; display list of devices
%endif



; ------------- Debug display memory
%ifdef DEBUG_MEM
		call	SysMemDispMem
%endif



;		sti

InitTaskSleep:
;		inc	dword [SYSTEM_ADDR+0b8004h]


		mov	eax,20
		call	Sleep
		inc	byte [800B8000h + 25*80*2-2]

		jmp	short InitTaskSleep


; ------------- Debug test task
%ifdef	DEBUG_TASK
DebTask:	mov	ah,bh
		mov	al,"T"
		stosw
		mov	al,"a"
		stosw
		mov	al,"s"
		stosw
		mov	al,"k"
		stosw
		mov	al,bh
		shr	al,4
		add	al,"0"
		stosw
		mov	al,":"
		stosw
		add	edi,2*2

DebTask2:	mov	edx,2
		mov	eax,50
		call	RandIntDWord

		call	Sleep

		mov	edx,1*TIME_1MS
		mov	eax,20*TIME_1MS
		call	RandIntDWord
		xchg	eax,ebx
		call	GetSysTimeLOW
		add	ebx,eax

DebTask3:	inc	byte [edi]
		call	GetSysTimeLOW
		cmp	eax,ebx
		jl	DebTask3

		jmp	DebTask2
%endif




%ifdef DEBUG_ASCII2

; display ASCII tables: table addresses EDX, titles ESI, number of tables EBP

DispKKKK:	mov	ch,3
DispKKKK30:	mov	cl,5
DispKKKK31:	push	ecx
		push	edx
		push	esi

		mov	edx,[edx]

		mov	al,80
		mul	ch
		mov	ch,0
		add	ax,cx
		movzx	edi,ax
		shl	edi,1
		add	edi,[ebx+DDPB_Addr]
		mov	ecx,16
KKKK32:		lodsb
		mov	ah,7
		stosw
		loop	KKKK32
		add	edi,160-2*16
		mov	esi,edx

		mov	ecx,80h
KKKK3:		xor	eax,eax
		lodsw
		mov	edx,"?"
		call	DispMapChar
		or	ah,16h
		stosw
		inc	ecx
		test	cl,0fh
		jnz	KKKK3
		add	edi,160-2*16
		test	cl,cl
		jnz	KKKK3

		pop	esi
		pop	edx
		pop	ecx
		dec	ebp
		jz	KKKK4

		add	esi,16
		add	edx,4

		add	cl,18
		cmp	cl,70
		jb	DispKKKK31
		add	ch,10
		cmp	ch,20
		jb	DispKKKK30
KKKK4:		ret

DispKT1:	db	'     ASCII      '
	   	db	' DEC VT100 GRAPH'
		db	'   IBM 437 USA  '
		db	'  IBM 737 Greek '
		db	' IBM 775 Baltic '
		db	' IBM 850 Latin 1'
		db	' IBM 852 Latin 2'
		db	' IBM 857 Turkish'
        
DispKT2:	db	'     ASCII      '
		db	' IBM 858 Latin 1'
		db	' IBM 860 Portug.'
		db	' IBM 861 Iceland'
		db	'IBM 863 FrCanada'
		db	' IBM 865 Nordic '
		db	'  IBM 869 Greek '
		db	' IBM 895 Kamenic'
        
DispKT3:	db	'     ASCII      '
		db	'   IBM 437 USA  '
		db	'   Win 1250 CE  '
		db	'Win 1252 Latin 1'
		db	' Win 1253 Greek '
		db	'Win 1254 Turkish'
		db	' Win 1257 Baltic'
		db	'Win 1258 Vietnam'
        
DispKT4:	db	'     ASCII      '
		db	'ISO 8859-1 Lat 1'
		db	'ISO 8859-2 Lat 2'
		db	'ISO 8859-3 Lat 3'
		db	'ISO 8859-4 Balt '
		db	'ISO 8859-7 Greek'
		db	'ISO 8859-9 Turk '
		db	'ISO 8859-15 Lat9'

DispKT5:	db	'     ASCII      '
		db	' IBM 720 Arabic '
		db	'Win 1256 Arabic '
		db	'ISO 8859-6 Arab '

DispKT6:	db	'     ASCII      '
		db	'IBM 855 Cyrillic'
		db	'IBM 866 Russian '
		db	'Win1251 Cyrillic'
		db	'ISO 8859-5 Cyril'

DispKT7:	db	'     ASCII      '
		db	' IBM 862 Hebrew '
		db	'Win 1255 Hebrew '
		db	'ISO 8859-8 Hebr '

DispKT8:	db	' Font 00h..7fh  '
		db	' Font 80h..ffh  '
		db	'Font 100h..17fh '
		db	'Font 180h..1ffh '

DispKA1:	dd	DispCharTab
		dd	CP1ToUniTab
		dd	CP437ToUniTab
		dd	CP737ToUniTab
		dd	CP775ToUniTab
		dd	CP850ToUniTab
		dd	CP852ToUniTab
		dd	CP857ToUniTab

DispKA2:	dd	DispCharTab
		dd	CP858ToUniTab
		dd	CP860ToUniTab
		dd	CP861ToUniTab
		dd	CP863ToUniTab
		dd	CP865ToUniTab
		dd	CP869ToUniTab
		dd	CP895ToUniTab

DispKA3:	dd	DispCharTab
		dd	CP437ToUniTab
		dd	CP1250ToUniTab
		dd	CP1252ToUniTab
		dd	CP1253ToUniTab
		dd	CP1254ToUniTab
		dd	CP1257ToUniTab
		dd	CP1258ToUniTab

DispKA4:	dd	DispCharTab
		dd	CP28591ToUniTab
		dd	CP28592ToUniTab
		dd	CP28593ToUniTab
		dd	CP28594ToUniTab
		dd	CP28597ToUniTab
		dd	CP28599ToUniTab
		dd	CP28605ToUniTab

DispKA5:	dd	DispCharTab
		dd	CP720ToUniTab
		dd	CP1256ToUniTab
		dd	CP28596ToUniTab

DispKA6:	dd	DispCharTab
		dd	CP855ToUniTab
		dd	CP866ToUniTab
		dd	CP1251ToUniTab
		dd	CP28595ToUniTab

DispKA7:	dd	DispCharTab
		dd	CP862ToUniTab
		dd	CP1255ToUniTab
		dd	CP28598ToUniTab

DispKA8:	dd	DispCharTab
		dd	CP437ToUniTab
		dd	DispCharTabLat
		dd	DispCharTabLat+2*128

%endif


; -----------------------------------------------------------------------------
;                       Test - display ASCII table
; -----------------------------------------------------------------------------
; INPUT:	EBX = driver parameter block
;		ESI = position
;		EDI = row
;		EBP = first character (0 or 256)
; -----------------------------------------------------------------------------
%ifdef DEBUG_ASCII
DispASCII:	push	eax
		push	ecx
		push	edx
		push	ebp

		mov	ecx,esi
		mov	edx,edi
		call	TXTSetCur

		mov	al,0e0h
		or	ebp,ebp
		jz	DispASCII1
		mov	al,0e8h
DispASCII1:	xor	ebp,ebp

		push	eax
		call	TXTSetColor

		mov	al,201
		call	TXTWriteChr

		mov	al,205
		mov	ecx,31
		mov	edx,1
		call	TXTFillUp

		lea	ecx,[esi+8]
		mov	edx,edi
		call	TXTSetCur

		mov	al,7
DispASCII12:	call	TXTSetColor
		push	eax
		shr	al,4
		add	al,"0"
		cmp	al,"9"
		jbe	DispASCII14
		add	al,7
DispASCII14:	call	TXTWriteChr
		pop	eax
		and	al,0f0h
		add	al,10h
		jnc	DispASCII12

		pop	eax
		call	TXTSetColor

		lea	ecx,[esi+32]
		mov	edx,edi
		call	TXTSetCur

		mov	al,187
		call	TXTWriteChr


DispASCII2:	mov	ecx,esi
		mov	edx,ebp
		shr	edx,4
		lea	edx,[edi+1+edx]
		call	TXTSetCur

		mov	al,186
		call	TXTWriteChr

DispASCII4:	mov	eax,ebp
		call	TXTWriteChr
		inc	ebp
		test	ebp,0fh
		jz	DispASCII6
		mov	al," "
		call	TXTWriteChr
		jmp	short DispASCII4

DispASCII6:	mov	al,186
		call	TXTWriteChr
		test	ebp,0ffh
		jnz	DispASCII2


		mov	ecx,esi
		mov	edx,edi
		add	edx,17
		call	TXTSetCur

		mov	al,200
		call	TXTWriteChr

		push	edx
		mov	al,205
		mov	ecx,31
		mov	edx,1
		call	TXTFillUp
		pop	edx

		push	edx

		mov	al,DCHOUT_GETCOLOR
		call	TXTInfo
		push	eax

		lea	ecx,[esi+8]
		call	TXTSetCur

		mov	al,70h
DispASCII62:	call	TXTSetColor
		push	eax
		and	al,0fh
		add	al,"0"
		cmp	al,"9"
		jbe	DispASCII64
		add	al,7
DispASCII64:	call	TXTWriteChr
		pop	eax
		and	al,0fh
		add	al,1
		cmp	al,0fh
		jbe	DispASCII62

		pop	eax
		call	TXTSetColor

		pop	edx

		lea	ecx,[esi+32]
		call	TXTSetCur

		mov	al,188
		call	TXTWriteChr

		pop	ebp
		pop	edx
		pop	ecx
		pop	eax
		ret
%endif

; -----------------------------------------------------------------------------
;                        Debug display date and time
; -----------------------------------------------------------------------------

%ifdef DEBUG_TIME

;dt0	db 0

DebDispTime:	mov	byte [VideoPos],0

; ------------- Get current date and time

		call	GetCurrentTime

		mov	ebx,DebDateTime

;		call	AbsToDateTime

;		mov	byte [ebx+DATETIME_Day],1
;		mov	byte [ebx+DATETIME_Month],1
;		mov	word [ebx+DATETIME_Year],1583

;		call	DateTimeExt

;		call	DateTimeToAbs

		call	AbsToDateTimeExt
		call	DateTimeToAbs


;		cmp	byte [dt0],0
;		jne	DebDispTime2
;		inc	byte [dt0]

;		pushf
;		cli
		
;		mov	ecx,1000
;		push	eax
;		push	edx
;		call	PerfGetUS
;		xchg	eax,esi
;		pop	edx
;		pop	eax
;dt1:		call	AbsToDateTime
;		loop	dt1
;		push	eax
;		push	edx
;		call	PerfGetUS
;		sub	eax,esi
;		call	DebOutNum
;		call	DebNewLine
;		pop	edx
;		pop	eax


;		mov	ecx,1000
;		push	eax
;		push	edx
;		call	PerfGetUS
;		xchg	eax,esi
;		pop	edx
;		pop	eax
;dt12:		call	DateTimeExt
;		loop	dt12
;		push	eax
;		push	edx
;		call	PerfGetUS
;		sub	eax,esi
;		call	DebOutNum
;		call	DebNewLine
;		pop	edx
;		pop	eax

;		mov	ecx,1000
;		push	eax
;		push	edx
;		call	PerfGetUS
;		xchg	eax,esi
;		pop	edx
;		pop	eax
;dt2:		call	DateTimeToAbs
;		loop	dt2
;		push	eax
;		push	edx
;		call	PerfGetUS
;		sub	eax,esi
;		call	DebOutNum
;		call	DebNewLine
;		pop	edx
;		pop	eax
 
;		mov	ecx,1000
;		push	eax
;		push	edx
;		call	PerfGetUS
;		xchg	eax,esi
;		pop	edx
;		pop	eax
;		push	eax
;		push	edx
;dt22:		push	ecx
;		mov	al,12
;		mov	cx,2007
;		mov	dl,2
;		call	DateToAbsDay
;		pop	ecx
;		loop	dt22
;		pop	edx
;		pop	eax
;		push	eax
;		push	edx
;		call	PerfGetUS
;		sub	eax,esi
;		call	DebOutNum
;		call	DebNewLine
;		pop	edx
;		pop	eax


;		popf

DebDispTime2:	xchg	eax,edx
		call	DebOutHexD
		mov	al,"'"
		call	DebOutChar
		xchg	eax,edx
		call	DebOutHexD
		call	DebOutSpc

; ------------- Display date

		movzx	eax,byte [ebx+DATETIME_Month]
		call	DebOutNum
		mov	al,"/"
		call	DebOutChar
		movzx	eax,byte [ebx+DATETIME_Day]
		call	DebOutNum
		mov	al,"/"
		call	DebOutChar
		movsx	eax,word [ebx+DATETIME_Year]
		call	DebOutNumSig
		call	DebOutSpc

; ------------- Display time

		movzx	eax,byte [ebx+DATETIME_Hour]
		call	DebOutNum
		mov	al,':'	
		call	DebOutChar
		movzx	eax,byte [ebx+DATETIME_Min]
		call	DebOutNum
		mov	al,':'	
		call	DebOutChar
		movzx	eax,byte [ebx+DATETIME_Sec]
		call	DebOutNum
;		mov	al,'.'	
;		call	DebOutChar
;		mov	eax,[ebx+DATETIME_NSec]
;		call	DebOutNum

		call	DebOutSpc
		movzx	eax,byte [ebx+DATETIME_WDay]
		call	DebOutNum

		call	DebOutSpc
		movzx	eax,word [ebx+DATETIME_YDay]
		call	DebOutNum

		call	DebOutSpc
		movzx	eax,byte [ebx+DATETIME_Week]
		call	DebOutNum

		call	DebOutSpc
		call	DebOutSpc
		call	DebOutSpc
		call	DebOutSpc
		ret
%endif
; -----------------------------------------------------------------------------
;                   Debug display instruction statistics
; -----------------------------------------------------------------------------

%ifdef DEBUG_INS

; ------------- Measure instructions

DebDispIns:	mov	byte [VideoRow],3
		mov	byte [VideoPos],0

; ------------- Display simulated text (for screenshot)
;%define DISPINS
%ifdef DISPINS
		call	DebOutClear
		mov	esi,DebInsTxt
DebDispInsX2:	lodsb
		cmp	al,0
		je	DebDispInsX6
		cmp	al,13
		je	DebDispInsX3
		cmp	al,10
		jne	DebDispInsX4
		cmp	byte [VideoPos],40
		mov	byte [VideoPos],40
		jb	DebDispInsX2
DebDispInsX3:	call	DebNewLine
		jmp	short DebDispInsX2
DebDispInsX4:	call	DebOutChar
		jmp	short DebDispInsX2
DebDispInsX6:	ret
%endif

BIGREP		EQU	500
LOWREP		EQU	100

; ------------- Short delay to quiet down (0.2 second)

		TSC_OK			; is time-stamp counter supported?
		jnz	TSCOK2		; time-stamp counter is supported
		sti
TSCOK2:		mov	eax,200000
		call	UDelay

; ------------- Start time

		call	PerfGetUS	; get current time
		mov	[DebStartTime],eax ; push start time

; ------------- Prepare base delay

		cli
		call	DebDispStart	; start measure
		call	DebDispStop	; stop measure
		TSC_OK			; is time-stamp counter supported?
		jnz	TSCOK3		; time-stamp counter is supported
		sti
TSCOK3:		mov	[DebPerf],eax	; correction

; ------------- Prepare delay 2x"mov reg32,N" (BIGREP)

		cli
		call	DebDispStart	; start measure
		%rep BIGREP
		mov	eax,1234567
		mov	edx,234
		%endrep
		call	DebDispStop	; stop measure
		TSC_OK			; is time-stamp counter supported?
		jnz	TSCOK4		; time-stamp counter is supported
		sti
TSCOK4:		mov	[DebPerf2],eax	; correction

; ------------- Prepare delay "add reg32,N" (LOWREP)

		cli
		call	DebDispStart	; start measure
		%rep LOWREP
		add	ecx,128
		%endrep
		call	DebDispStop	; stop measure
		TSC_OK			; is time-stamp counter supported?
		jnz	TSCOK5		; time-stamp counter is supported
		sti
TSCOK5:		mov	[DebPerf4],eax	; correction

; ------------- Macro - start measure (%1 = text)

%macro	DEBPERF1 1
		jmp	short %%L2	; skip text
%%L1:		db	%1,0		; text to display
%%L2		mov	esi,%%L1
		call	DebOutText	; display text
		mov	al,":"
		call	DebOutChar
		call	DebOutSpc
		cli
		call	DebDispStart	; start measure
%endmacro

; ------------- Macro - end measure (%1=loops, %2=input/%3=output correction)

%macro	DEBPERF2 3
		call	DebDispStop	; stop measure
		TSC_OK			; is time-stamp counter supported?
		jnz	%%TSCOK6	; time-stamp counter is supported
		sti
%%TSCOK6:	mov	[%3],eax	; save output correction
		sub	eax,[%2]	; do input correction
%if %1 > 1
		xor	edx,edx
		mov	ebx,%1
		div	ebx
%endif
		call	DebOutNum	; display time
%if %1 > 1
		cmp	eax,100
		jae	%%L3
		mov	al,"."
		call	DebOutChar
		xor	eax,eax
		xchg	eax,edx
		mov	ebx,%1/10
		div	ebx
		call	DebOutNum
%%L3:

%endif
		call	DebOutSpc
%ifdef DEBUG_INS_CLOCK
		mov	al,"c"
		call	DebOutChar
		mov	al,"l"
		call	DebOutChar
		mov	al,"k"
%else
		mov	al,"n"
		call	DebOutChar
		mov	al,"s"
%endif
		call	DebOutChar
		cmp	byte [VideoPos],40
		mov	byte [VideoPos],40
		jb	%%L4
		call	DebNewLine
%%L4:
%endmacro

; ------------- Macto - unsupported text (%1 = text)

%macro	DEBPERFERR 1
		jmp	short %%L2	; skip text
%%L1:		db	%1,0		; text to display
%%L2		mov	esi,%%L1
		call	DebOutText	; display text
		mov	al,":"
		call	DebOutChar
		call	DebOutSpc
		mov	al,"-"
		call	DebOutChar
		cmp	byte [VideoPos],40
		mov	byte [VideoPos],40
		jb	%%L3
		call	DebNewLine
%%L3:

%endmacro
		DEBPERF1 'mov reg8,N'
		%rep BIGREP
		mov	al,123
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		DEBPERF1 'mov reg16,N'
		%rep BIGREP
		mov	ax,1234
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		DEBPERF1 'mov reg32,N'
		%rep BIGREP
		mov	eax,12345
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf1

		DEBPERF1 'mov reg32,reg32'
		%rep BIGREP
		mov	eax,ebx
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		DEBPERF1 'inc reg32'
		%rep BIGREP
		inc	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf3

		DEBPERF1 'dec reg32'
		%rep BIGREP
		dec	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		xor	ecx,ecx
		DEBPERF1 'mov reg32,[addr+offset]'
		%rep BIGREP
		mov	eax,[DebMove1+ecx*4]
		inc	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf3,DebPerf0

		xor	ecx,ecx
		DEBPERF1 'mov [addr+offset],reg32'
		%rep BIGREP
		mov	[DebMove2+ecx*4],ecx
		inc	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf3,DebPerf0


		xor	ecx,ecx
		DEBPERF1 'mov reg32,[addr+offset+1]'
		%rep BIGREP
		mov	eax,[DebMove3+ecx*8+1]
		inc	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf3,DebPerf0

		xor	ecx,ecx
		DEBPERF1 'mov [addr+offset+1],reg32'
		%rep BIGREP
		mov	[DebMove4+ecx*8+1],ecx
		inc	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf3,DebPerf0


		DEBPERF1 'xchg reg32,reg32'
		%rep BIGREP
		xchg	eax,ebx
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		mov	ecx,123456
		DEBPERF1 'add reg32,reg32'
		%rep BIGREP
		add	eax,ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		mov	ecx,456789
		DEBPERF1 'mul reg32'
		%rep BIGREP
		mov	eax,1234567
		mul	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf1,DebPerf0

		mov	ecx,45899
		DEBPERF1 'div reg32'
		%rep BIGREP
		mov	eax,1234567
		mov	edx,234
		div	ecx
		%endrep
		DEBPERF2 BIGREP,DebPerf2,DebPerf0


		DEBPERF1 'push reg32'
		mov	[DebPushESP],esp
		mov	esp,TestPush1
		%rep BIGREP
		push	eax
		%endrep
		mov	esp,[DebPushESP]
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		DEBPERF1 'pop reg32'
		mov	[DebPushESP],esp
		mov	esp,TestPush2+BIGREP*4
		%rep BIGREP
		pop	eax
		%endrep
		mov	esp,[DebPushESP]
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		DEBPERF1 'pusha'
		mov	[DebPushESP],esp
		mov	esp,TestPushA1
		%rep (BIGREP/8)
		pusha
		%endrep
		mov	esp,[DebPushESP]
		DEBPERF2 (BIGREP/8),DebPerf,DebPerf0

		DEBPERF1 'popa'
		mov	[DebPushESP],esp
		mov	esp,TestPushA2+(BIGREP/8)*8*4
		%rep (BIGREP/8)
		popa
		%endrep
		mov	esp,[DebPushESP]
		DEBPERF2 (BIGREP/8),DebPerf,DebPerf0


		DEBPERF1 'jmp short'
		%rep BIGREP
		jmp short $+2
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		DEBPERF1 'jmp near'
		%rep BIGREP
		jmp near $+5
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		DEBPERF1 'jc short (jump)'
		stc
		%rep BIGREP
		jc short $+2
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		DEBPERF1 'jc short (not jump)'
		clc
		%rep BIGREP
		jc short $+2
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		mov	ecx,123456
		DEBPERF1 'loop'
		%rep BIGREP
		loop $+2
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		DEBPERF1 'nop'
		%rep BIGREP
		nop
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0


		DEBPERF1 'call addr'
		%rep BIGREP
		call $+5
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0
		%rep BIGREP
		pop	eax
		%endrep

		%assign RETADDR 0
		%rep BIGREP
		push	dword (DebRet-RETADDR)
		%assign RETADDR RETADDR + 1
		%endrep
		DEBPERF1 'ret'
		%rep BIGREP
		ret
		%endrep
DebRet:
		DEBPERF2 BIGREP,DebPerf,DebPerf0

		call	PerfGetUS	; get current time
		sub	[DebStartTime],eax ; start time I/O correction

		DEBPERF1 'out N,al'
		%rep LOWREP
		out	80h,al
		%endrep
		DEBPERF2 LOWREP,DebPerf,DebPerf0

		DEBPERF1 'in al,N'
		%rep LOWREP
		in	al,80h
		%endrep
		DEBPERF2 LOWREP,DebPerf,DebPerf0


		mov	dx,80h
		DEBPERF1 'out dx,al'
		%rep LOWREP
		out	dx,al
		%endrep
		DEBPERF2 LOWREP,DebPerf,DebPerf0

		mov	dx,80h
		DEBPERF1 'in al,dx'
		%rep LOWREP
		in	al,dx
		%endrep
		DEBPERF2 LOWREP,DebPerf,DebPerf0

		call	PerfGetUS	; get current time
		add	[DebStartTime],eax ; start time I/O correction


		TSC_OK			; is time-stamp counter supported?
		jnz	DebTS2		; time-stamp counter is supported

		DEBPERFERR 'rdtsc'
		%rep BIGREP
		mov	eax,12345	; time correction
		%endrep
		jmp	near DebTS4

DebTS2:		DEBPERF1 'rdtsc'
		%rep BIGREP
		rdtsc
		%endrep
		DEBPERF2 BIGREP,DebPerf,DebPerf0

DebTS4:		FPU_OK			; FPU present or emulated?
		jz	DebTS5		; FPU not present nor emulated

		mov	ecx,DebFpu1
		DEBPERF1 'fnsave'
		%rep LOWREP
		fnsave	[ecx]
		add	ecx,128
		%endrep
		DEBPERF2 LOWREP,DebPerf4,DebPerf0


		mov	ecx,DebFpu2
		DEBPERF1 'fsave'
		%rep LOWREP
		fsave	[ecx]
		add	ecx,128
		%endrep
		DEBPERF2 LOWREP,DebPerf4,DebPerf0

		mov	ecx,DebFpu3
		DEBPERF1 'frstor'
		%rep LOWREP
		frstor	[ecx]
		add	ecx,128
		%endrep
		DEBPERF2 LOWREP,DebPerf4,DebPerf0

		jmp	DebTS6

DebTS5:
		DEBPERFERR 'fnsave'
		DEBPERFERR 'fsave'
		DEBPERFERR 'frstor'
		DEBPERFERR 'fxsave'
		DEBPERFERR 'fxrstor'

		mov	eax,[DebPerf1]
		sub	eax,[DebPerf0]
		jnc	DebTS52
		xor	eax,eax
DebTS52:	shr	eax,5
		sub	[DebStartTime],eax ; time difference
		jmp	DebNoFX2

DebTS6:		test dword [CPUInfo+CPU_Features],B24
		jz near DebNoFX

		mov	ecx,DebFpu4
		DEBPERF1 'fxsave'
		%rep LOWREP
		fxsave	[ecx]
		add	ecx,512
		%endrep
		DEBPERF2 LOWREP,DebPerf4,DebPerf0

		mov	ecx,DebFpu5
		DEBPERF1 'fxrstor'
		%rep LOWREP
		fxrstor	[ecx]
		add	ecx,512
		%endrep
		DEBPERF2 LOWREP,DebPerf4,DebPerf0

		jmp	DebNoFX2

DebNoFX:
		DEBPERFERR 'fxsave'
		DEBPERFERR 'fxrstor'

		mov	ecx,DebFpu4
		%rep LOWREP
		fsave	[ecx]		; time correction
		add	ecx,128
		%endrep

		mov	ecx,DebFpu5
		%rep LOWREP
		frstor	[ecx]		; time correction
		add	ecx,128
		%endrep


DebNoFX2:	DEBPERF1 'memfill stosd (4KB)'
		mov	edi,TestBuff1
		mov	ecx,4096/4
		rep	stosd
		DEBPERF2 1,DebPerf,DebPerf0

		DEBPERF1 'memcopy movsd (4KB)'
		mov	esi,TestBuff3
		mov	edi,TestBuff4
		mov	ecx,4096/4
		rep	movsd
		DEBPERF2 1,DebPerf,DebPerf0

		test	byte [CPUInfo+CPU_Flags],B1 ; MMX
		jnz	DebMMX2		; MMX OK

                DEBPERFERR 'memfill MMX0 (4KB)'
		DEBPERFERR 'memcopy MMX0 (4KB)'
		DEBPERFERR 'memfill MMX0..7 (4KB)'
		DEBPERFERR 'memcopy MMX0..7 (4KB)'

		mov	edi,TestBuff2
		mov	ecx,4096/4
		rep	stosd		; time correction

		mov	esi,TestBuff5
		mov	edi,TestBuff6
		mov	ecx,4096/4
		rep	movsd		; time correction


		mov	edi,TestBuff7
		mov	ecx,4096/4
		rep	stosd		; time correction

		mov	esi,TestBuff8
		mov	edi,TestBuff9
		mov	ecx,4096/4
		rep	movsd		; time correction
		jmp	near DebMMX5


DebMMX2:	DEBPERF1 'memfill MMX0 (4KB)'
		mov	edi,TestBuff2
		mov	ecx,4096/128
DebStoreMMX:
		%assign MMXINX 0
		%rep 16
		movq	[edi+MMXINX*8],mm0
		%assign MMXINX MMXINX+1
		%endrep
		add	edi,128
		loop	DebStoreMMX
		DEBPERF2 1,DebPerf,DebPerf0

		DEBPERF1 'memcopy MMX0 (4KB)'
		mov	esi,TestBuff5
		mov	edi,TestBuff6
		mov	ecx,4096/128
DebMoveMMX:
		%assign MMXINX 0
		%rep 16
		movq	mm0,[esi+MMXINX*8]
		movq	[edi+MMXINX*8],mm0
		%assign MMXINX MMXINX+1
		%endrep
		add	edi,128
		add	esi,128
		dec	ecx
		jnz	DebMoveMMX
		DEBPERF2 1,DebPerf,DebPerf0


		DEBPERF1 'memfill MMX0..7 (4KB)'
		mov	edi,TestBuff7
		mov	ecx,4096/128
DebStoreMMX2:
		%assign MMXINX 0
		%rep 2
		movq	[edi+MMXINX*8],mm0
		movq	[edi+(MMXINX+1)*8],mm1
		movq	[edi+(MMXINX+2)*8],mm2
		movq	[edi+(MMXINX+3)*8],mm3
		movq	[edi+(MMXINX+4)*8],mm4
		movq	[edi+(MMXINX+5)*8],mm5
		movq	[edi+(MMXINX+6)*8],mm6
		movq	[edi+(MMXINX+7)*8],mm7
		%assign MMXINX MMXINX+8
		%endrep
		add	edi,128
		loop	DebStoreMMX2
		DEBPERF2 1,DebPerf,DebPerf0


		DEBPERF1 'memcopy MMX0..7 (4KB)'
		mov	esi,TestBuff8
		mov	edi,TestBuff9
		mov	ecx,4096/128
DebMoveMMX2:
		%assign MMXINX 0
		%rep 2
		movq	mm0,[esi+MMXINX*8]
		movq	mm1,[esi+(MMXINX+1)*8]
		movq	mm2,[esi+(MMXINX+2)*8]
		movq	mm3,[esi+(MMXINX+3)*8]
		movq	mm4,[esi+(MMXINX+4)*8]
		movq	mm5,[esi+(MMXINX+5)*8]
		movq	mm6,[esi+(MMXINX+6)*8]
		movq	mm7,[esi+(MMXINX+7)*8]
		movq	[edi+MMXINX*8],mm0
		movq	[edi+(MMXINX+1)*8],mm1
		movq	[edi+(MMXINX+2)*8],mm2
		movq	[edi+(MMXINX+3)*8],mm3
		movq	[edi+(MMXINX+4)*8],mm4
		movq	[edi+(MMXINX+5)*8],mm5
		movq	[edi+(MMXINX+6)*8],mm6
		movq	[edi+(MMXINX+7)*8],mm7
		%assign MMXINX MMXINX+8
		%endrep
		add	edi,128
		add	esi,128
		dec	ecx
		jnz	DebMoveMMX2
		DEBPERF2 1,DebPerf,DebPerf0

; ------------- Total time

DebMMX5:	mov	byte [VideoPos],(80-(DebTimeLenTxt2-DebTimeLenTxt+5))/2
		mov	esi,DebTimeLenTxt
		call	DebOutText
		call	PerfGetUS	; get current time
		sub	eax,[DebStartTime] ; time difference
		call	DebOutNum	; display time
		ret

; ------------- Start measure

DebDispStart:	TSC_OK			; is time-stamp counter supported?
		jz	near SpkTimerStart ; time-stamp not supported
		call	PerfGetNS	; get current time in nanoseconds
		mov	[DebPushEAX],eax ; push start time
		ret

; ------------- Stop measure

DebDispStop:	TSC_OK			; is time-stamp counter supported?
		jz	near SpkTimerGet ; time-stamp not supported
		call	PerfGetNS	; get new current time in nanoseconds
		sub	eax,[DebPushEAX] ; time difference
		ret

%endif

%ifdef	DEBUG_ALARM		
AlarmTestFunc:	inc	byte [800B8000h+ecx*2]	; alarm test - shift character
		ret
%endif

; -----------------------------------------------------------------------------
;                              Constant Data
; -----------------------------------------------------------------------------

		CONST_SECTION

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA_SECTION

;IsEISA:	db	0		; 1=is EISA bus, 0=no
;IsPCIISA:	db	0		; 1=is PCI/ISA bus, 0=no

; ------------- Debug time structure
%ifdef DEBUG_TIME
DebDateTime:	times	DATETIME_size db 0
%endif

; ------------- Current display device parameter block

;CurDDPB:	times	DDPB_size db 0

%ifdef DEBUG_INS
; ------------- Simulated debug text (for screenshot)

%ifdef DISPINS
DebInsTxt:	db	'CPU type: Pentium 3, Vendor: AMD, '
		db	'Family: 6, Model: 10, '
		db	'Freq.: 1658556 kHz',13
		db	'Features: MMX SSE 3DNow! 3DNow!ext MMX+(AMD) '
		db	'FPU TSC',13,13
		db	'mov reg8,N: 3.4 ns',10
		db	'mov reg16,N: 6.2 ns',10
		db	'mov reg32,N: 7.9 ns',10
		db	'mov reg32,reg32: 2.9 ns',10
		db	'inc reg32: 1.5 ns',10
		db	'dec reg32: 1.6 ns',10
		db	'mov reg32,[addr+offset]: 15.5 ns',10
		db	'mov [addr+offset],reg32: 15.0 ns',10
		db	'mov reg32,[addr+offset+1]: 17.2 ns',10
		db	'mov [addr+offset+1],reg32: 19.7 ns',10
		db	'xchg reg32,reg32: 1.3 ns',10
		db	'add reg32,reg32: 3.5 ns',10
		db	'mul reg32: 3.5 ns',10
		db	'div reg32: 14.2 ns',10
		db	'push reg32: 1.6 ns',10
		db	'pop reg32: 8.0 ns',10
		db	'pusha: 61.2 ns',10
		db	'popa: 50.2 ns',10
		db	'jmp short: 8.1 ns',10
		db	'jmp near: 12.6 ns',10
		db	'jc short (jump): 7.3 ns',10
		db	'jc short (not jump): 3.6 ns',10
		db	'loop: 9.2 ns',10
		db	'nop: 1.3 ns',10
		db	'call addr: 14.8 ns',10
		db	'ret: 13.3 ns',10
		db	'out N,al: 1447 ns',10
		db	'in al,N: 1445 ns',10
		db	'out dx,al: 1445 ns',10
		db	'in al,dx: 1444 ns',10
		db	'rdtsc: 6.5 ns',10
		db	'fnsave: 249 ns',10
		db	'fsave: 273 ns',10
		db	'frstor: 285 ns',10
		db	'fxsave: 345 ns',10
		db	'fxrstor: 451 ns',10
		db	'memfill stosd (4KB): 7922 ns',10
		db	'memcopy movsd (4KB): 13869 ns',10
		db	'memfill MMX0 (4KB): 6196 ns',10
		db	'memcopy MMX0 (4KB): 12140 ns',10
		db	'memfill MMX0..7 (4KB): 5986 ns',10
		db	'memcopy MMX0..7 (4KB): 12053 ns',10
		db	'                    ',
		db	'Total time (without IN/OUT) [us]: 474'
		db	0
%endif ; DISPINS

%ifdef DEBUG_INS_CLOCK
DebTimeLenTxt:	db	'Total time (without IN/OUT) [clock]: ',0
%else
DebTimeLenTxt:	db	'Total time (without IN/OUT) [us]: ',0
%endif
DebTimeLenTxt2:


;DebTimeFPU1:	dq	12345.6789
;DebTimeFPU2:	dq	56789.2323

%endif


DebTestFPU1:	dt	1234.5678901234567890
DebTestFPU2:	dt	1234567890123456789.0
DebTestFPU3:	dt	0.0001234567890123456789
DebTestFPU4:	dt	1.234567890123456789e4930
DebTestFPU5:	dt	1.234567890123456789e-25 ;4931

DebTestFPU6:	dt	5234.5678901234567890
DebTestFPU7:	dt	5234567890123456789.0
DebTestFPU8:	dt	0.0005234567890123456789
DebTestFPU9:	dt	-5.234567890123456789e44 ;4930
DebTestFPU10:	dt	-5.234567890123456789e-18 ;4931

DebTestFPU11:	dt	9234.5678901234567890
DebTestFPU12:	dt	9234567890123456789.0
DebTestFPU13:	dt	0.0009234567890123456789
DebTestFPU14:	dt	9.2934567890123456789e26 ;4930
DebTestFPU15:	dt	-9.234567890123456789e-36 ;4931

DebTestFPU52:	dq	1.0e-15
DebTestFPU53:	dq	9.9345674901234567890e16

DebTest1:	dt	1.23456e0

;DebTest1EM100:	dt	1.0e-100
;DebTest1EM1002:	dt	1.00000000000000001e-100
;DebTest1EM1003:	dt	0.99999999999999999e-100

;DebTest1EM1000:	dt	1.0e-1000
;DebTest1EM10002:dt	1.00000000000000001e-1000
;DebTest1EM10003:dt	0.99999999999999999e-1000

;DebTest1E100:	dt	1.0e100
;DebTest1E1002:	dt	1.00000000000000001e100
;DebTest1E1003:	dt	0.99999999999999999e100

;DebTest1E1000:	dt	1.0e1000
;DebTest1E10002:	dt	1.00000000000000001e1000
;DebTest1E10003:	dt	0.99999999999999999e1000

;DebTestXXX:	dd	0

DebText2:	CTEXT	'[%.0f]'	; DebTestFPU1
;DebText3:	CTEXT	'[%.0F]'
;DebText4:	CTEXT	'[%.3e]'	; DebTestFPU5
;DebText5:	CTEXT	'[%.3E]'

DebTextDT1:	CTEXT	'a aa aaa aaaa d dd ddd dddd g gg ggg h hh hhh H HH HHH'
DebTextDT2:	CTEXT	'm mm mmm M MM MMM MMMM MMMMM s ss sss t tt ttt w ww www'
DebTextDT3:	CTEXT	'y yy yyy yyyy yyyyy Y YY YYY YYYY YYYYY :: // .. ,, ;;'
DebTextDT4:	CTEXT	'f ff fff ffff fffffffffff'
DebTextDT5:	CTEXT	'F FF FFF FFFF FFFFFFFFFFF'

;DebText10: CTEXT  '  ',13,'1234567890  ',0efh,0bfh,0bfh,10,0dfh,0bfh,7fh,'98765432123  ',13,10,' '
;DebText11: CTEXT 13,10,' 56'

;DebText12:	CTEXT 0c4h,8ch,'esky',10


DebText:	EMPTYTEXT

; -----------------------------------------------------------------------------
;                            Uninitialized data
; -----------------------------------------------------------------------------

		BSS_SECTION

; ------------- Debug instruction buffers
%ifdef DEBUG_INS
		align	4, resb 1
DebStartTime:	resd	1		; start time
DebPushEAX:	resd	1		; push register EAX (with time)
DebPushESP:	resd	1		; push register ESP
DebPerf:	resd	1		; basic correction
DebPerf0:	resd	1		; unused output correction
DebPerf1:	resd	1		; correction "mov reg32,N" (BIGREP)
DebPerf2:	resd	1		; correction 2x"mov reg32,N" (BIGREP)
DebPerf3:	resd	1		; correction "inc reg32" (BIGREP)
DebPerf4:	resd	1		; correction "add reg32,reg32" (LOWREP)

		align	4, resb 1
DebMove1:	resb	BIGREP*4	; mov reg32,[addr]
		align	4, resb 1
DebMove2:	resb	BIGREP*4	; mov [addr],reg32
		align	4, resb 1
DebMove3:	resb	BIGREP*4*2	; mov reg32,[addr+1]
		align	4, resb 1
DebMove4:	resb	BIGREP*4*2	; mov [addr+1],reg32

		align	4, resb 1
TestPush1:	resb	4*BIGREP
		align	4, resb 1
TestPush2:	resb	4*BIGREP
		align	4, resb 1
TestPushA1:	resb	8*4*(BIGREP/8)
		align	4, resb 1
TestPushA2:	resb	8*4*(BIGREP/8)

		align	32, resb 1
DebFpu1:	resb	128*LOWREP	; fnsave
		align	4, resb 1
DebFpu2:	resb	128*LOWREP	; fsave
		align	4, resb 1
DebFpu3:	resb	128*LOWREP	; frstor
		align	4, resb 1
DebFpu4:	resb	512*LOWREP	; fxsave
		align	4, resb 1
DebFpu5:	resb	512*LOWREP	; fxrstor

		align	4, resb 1
TestBuff1:	resb	4096
		align	4, resb 1
TestBuff2:	resb	4096
		align	4, resb 1
TestBuff3:	resb	4096
		align	4, resb 1
TestBuff4:	resb	4096
		align	4, resb 1
TestBuff5:	resb	4096
		align	4, resb 1
TestBuff6:	resb	4096
		align	4, resb 1
TestBuff7:	resb	4096
		align	4, resb 1
TestBuff8:	resb	4096
		align	4, resb 1
TestBuff9:	resb	4096

%endif


TESTTESTBUF2:	resd	2
TESTTESTBUF:	resb	200
