; =============================================================================
;
;               Litos - Initialization, debug (real and protect mode)
;
; =============================================================================

		CODE16_SECTION

%ifdef DEBUG

; -----------------------------------------------------------------------------
;                            BIOS display HEX number
; -----------------------------------------------------------------------------
; INPUT:	BIOSDispHexByte: AL = byte to display
;		BIOSDispHexWord: AX = word to display
;		BIOSDispHexDWrd: DX:AX = double word to display
; -----------------------------------------------------------------------------

; ------------- Display HEX double word in DX:AX

BIOSDispHexDWrd:xchg	ax,dx		; AX <- high word
		call	BIOSDispHexWord	; display HEX word
		xchg	ax,dx		; AX <- LOW word
	
; ------------- Display delimiting character

		push	ax		; push AX
		mov	al,"'"		; AL <-. delimiting character
		call	BIOSDispChar	; display delimiting character
		pop	ax		; pop AX

; ------------- Display HEX word in AX

BIOSDispHexWord:xchg	al,ah		; AL <- high byte
		call	BIOSDispHexByte	; display HEX byte
		xchg	al,ah		; AL <- low byte

; ------------- Display HEX byte in AL

BIOSDispHexByte:push	ax		; push AX
		shr	al,1
		shr	al,1
		shr	al,1
		shr	al,1		; AL >> 4
		call	BIOSDispHexCh	; display HEX digit
		pop	ax		; pop AX

; ------------- Display HEX digit in AL (low nibble)

BIOSDispHexCh:	push	ax		; push AX
		and	al,0fh		; mask low nibble
		add	al,"0"		; convert to ASCII characters
		cmp	al,"9"		; is it decimal digit?
		jbe	BIOSDispHexCh2	; it is OK
		add	al,"A"-"9"-1	; convert to ASCII character
BIOSDispHexCh2:	call	BIOSDispChar	; display character
		pop	ax		; pop AX
		ret

; -----------------------------------------------------------------------------
;                            BIOS display number
; -----------------------------------------------------------------------------
; INPUT:	AX = number to display
; -----------------------------------------------------------------------------

; ------------- Push registers

BIOSDispNum:	push	ax		; push AX
		push	bx		; push BX
		push	cx		; push CX
		push	dx		; push DX

; ------------- Decode digits of number (into stack)

		xor	cx,cx		; CX <- 0 counter of digits
BIOSDispNum2:	xor	dx,dx		; DX <- 0 digit HIGH
		mov	bx,10		; BX <- 10 divider
		div	bx		; divide one number
		add	dl,"0"		; convert to character
		push	dx		; push DX with a digit into stack
		inc	cx		; increase counter of digits
		or	ax,ax		; is it already zero?
		jnz	BIOSDispNum2	; decode other digit

; ------------- Display number

BIOSDispNum3:	pop	ax		; pop AX with a digit
		call	BIOSDispChar	; display character
		loop	BIOSDispNum3	; display next character

; ------------- Pop registers

		pop	dx		; pop DX
		pop	cx		; pop CX
		pop	bx		; pop BX
		pop	ax		; pop AX
		ret

; -----------------------------------------------------------------------------
;                             BIOS display new line
; -----------------------------------------------------------------------------
; INPUT:	DS = data segment
; -----------------------------------------------------------------------------

BIOSDispNewLine:push	ax		; push AX
		mov	al,13		; AL <- CR
		call	BIOSDispChar	; display CR
		mov	al,10		; AL <- LF
		call	BIOSDispChar	; display LF
		pop	ax		; pop AX
		ret

; -----------------------------------------------------------------------------
;                        BIOS display space character
; -----------------------------------------------------------------------------
; INPUT:	DS = data segment
; -----------------------------------------------------------------------------

BIOSDispSpc:	push	ax		; push AX
		mov	al," "		; AL <- space character
		call	BIOSDispChar	; BIOS display space character
		pop	ax		; pop AX
		ret

; -----------------------------------------------------------------------------
;                          32-bit code section
; -----------------------------------------------------------------------------

		CODE_SECTION

; -----------------------------------------------------------------------------
;                   Debug display number with signum
; -----------------------------------------------------------------------------
; INPUT:	EAX = number to display
; -----------------------------------------------------------------------------

DebOutNumSig:	push	eax

		or	eax,eax
		jns	DebOutNumSig2
		neg	eax
		push	eax
		mov	al,"-"
		call	DebOutChar
		pop	eax

DebOutNumSig2:	call	DebOutNum

		pop	eax
		ret

; -----------------------------------------------------------------------------
;                            Debug display number
; -----------------------------------------------------------------------------
; INPUT:	EAX = number to display
; -----------------------------------------------------------------------------

; ------------- Push registers

DebOutNum:	push	eax		; push EAX
		push	ebx		; push EBX
		push	ecx		; push ECX
		push	edx		; push EDX

; ------------- Decode digits of number (into stack)

		xor	ecx,ecx		; ECX <- 0, counter of digits
		mov	ebx,10		; EBX <- 10 divider
DebOutNum2:	xor	edx,edx		; EDX <- 0, digit HIGH
		div	ebx		; divide one number
		add	dl,"0"		; convert to character
		push	edx		; push EDX with a digit into stack
		inc	ecx		; increase counter of digits
		or	eax,eax		; is it already zero?
		jnz	DebOutNum2	; decode other digit

; ------------- Display number

DebOutNum3:	pop	eax		; pop AX with a digit
		call	DebOutChar	; display character
		loop	DebOutNum3	; display next character

; ------------- Pop registers

		pop	edx		; pop EDX
		pop	ecx		; pop ECX
		pop	ebx		; pop EBX
		pop	eax		; pop EAX
		ret

; -----------------------------------------------------------------------------
;                         Debug display HEX number
; -----------------------------------------------------------------------------
; INPUT:	AL, AX, EAX
; -----------------------------------------------------------------------------

DebOutHexD0:	push	eax
		shr	eax,16
		call	DebOutHexW
		pop	eax
		jmp	short DebOutHexW

DebOutHexD:	push	eax
		shr	eax,16
		call	DebOutHexW

		mov	al,"'"
		call	DebOutChar

		pop	eax

DebOutHexW:	push	eax
		mov	al,ah
		call	DebOutHexB
		pop	eax

DebOutHexB:	push	eax
		shr	al,4
		call	DebOutHexCh
		pop	eax

DebOutHexCh:	push	eax
		and	al,0fh
		or	al,30h
		cmp	al,39h
		jbe	DebOutHexCh2
		add	al,7	
DebOutHexCh2:	call	DebOutChar
		pop	eax
		ret

; -----------------------------------------------------------------------------
;                        Debug display text
; -----------------------------------------------------------------------------
; INPUT:	ESI = ASCIIZ text
; -----------------------------------------------------------------------------

DebOutText:	push	eax
		push	esi

DebOutText2:	lodsb
		or	al,al
		jz	DebOutText4
		call	DebOutChar
		jmp	short DebOutText2

DebOutText4:	pop	esi
		pop	eax
		ret

; ------------- Macro - display debug text

%macro		DEBUGTEXT 1

		jmp	short %%L2
%%L1:		db	%1,0
%%L2:		push	esi
		mov	esi,%%L1
		call	DebOutText
		pop	esi

%endmacro

; -----------------------------------------------------------------------------
;                        Debug display TEXT
; -----------------------------------------------------------------------------
; INPUT:	ESI = TEXTDATA text string UTF-8
; -----------------------------------------------------------------------------

DebOutTextData:	push	eax
		push	ebx
		push	ecx
		push	edx
		push	esi

		mov	ecx,[esi+TEXT_Length]
		add	esi,TEXT_Text
		mov	ebx,EGADevDDPB
DebOutTextData2:jecxz	DebOutTextData4
		xor	edx,edx
		call	CharUTF8Read

		cmp	eax,32
		jb	DebOutTextData3

;		mov	edx,"?"
;		call	DispMapChar

DebOutTextData3:call	DebOutChar
		jmp	short DebOutTextData2

DebOutTextData4:pop	esi
		pop	edx
		pop	ecx
		pop	ebx
		pop	eax
		ret

; -----------------------------------------------------------------------------
;                        Debug set new line
; -----------------------------------------------------------------------------

DebNewLine:	inc	byte [VideoRow]
		cmp	byte [VideoRow],25
		jb	DebOutCR
		mov	byte [VideoRow],0
DebOutCR:	mov	byte [VideoPos],0
		ret

; -----------------------------------------------------------------------------
;                       Debug display space character
; -----------------------------------------------------------------------------

DebOutSpc:	push	eax
		mov	al," "
		call	DebOutChar
		pop	eax
		ret

; -----------------------------------------------------------------------------
;                        Debug display tabelator
; -----------------------------------------------------------------------------

DebOutTab:	call	DebOutSpc
		cmp	byte [VideoPos],80
		jae	DebNewLine
		test	byte [VideoPos],7
		jnz	DebOutTab
		ret

; -----------------------------------------------------------------------------
;                       Debug display character
; -----------------------------------------------------------------------------
; INPUT:	AL = character to display
; -----------------------------------------------------------------------------

; ------------- Push registers

DebOutChar:	push	eax
		push	edx
		push	edi

; ------------- New line

		cmp	al,10
		je	DebOutChar7

; ------------- Character color

		mov	ah,[VideoCol]
		push	eax

; ------------- Address of video memory (-> EDI)

		xor	eax,eax
		mov	ax,[VideoSegm]
		shl	eax,4
		add	eax,SYSTEM_ADDR
		xchg	eax,edi

; ------------- Address of character position

		movzx	eax,byte [VideoRow]
		mul	word [VideoBytes]
		add	edi,eax
		movzx	eax,byte [VideoPos]
		shl	eax,1
		add	edi,eax

; ------------- Store character

		pop	eax
		stosw

; ------------- Increase character position

		inc	byte [VideoPos]
		mov	al,[VideoPos]
		cmp	al,[VideoCols]
		jb	DebOutChar8
DebOutChar7:	call	DebNewLine

; ------------- Pop registers

DebOutChar8:	pop	edi
		pop	edx
		pop	eax
		ret

; -----------------------------------------------------------------------------
;                          Debug clear display  
; -----------------------------------------------------------------------------

; ------------- Push registers

DebOutClear:	push	eax
		push	ecx
		push	edi

; ------------- Address of video memory (-> EDI)

		xor	eax,eax
		mov	ax,[VideoSegm]
		shl	eax,4
		add	eax,SYSTEM_ADDR
		xchg	eax,edi

; ------------- Length of videomemory (-> ECX)

		xor	eax,eax
		mov	al,[VideoCols]
		mul	byte [VideoRows]
		xchg	eax,ecx

; ------------- Clear display

		mov	ah,[VideoCol]
		mov	al,32
		rep	stosw

; ------------- Clear row and position

		mov	byte [VideoRow],0
		mov	byte [VideoPos],0

; ------------- Pop registers

		pop	edi
		pop	ecx
		pop	eax
		ret

%endif
