; =============================================================================
;
;                Litos - Advanced Power Management, real mode
;
; =============================================================================

%ifdef DEBUG
;%define	DEBUG_APM		; uncomment this to display APM info
%endif

		CODE16_SECTION

; -----------------------------------------------------------------------------
;                        Init advanced power management
; -----------------------------------------------------------------------------
; INPUT:	DS = data segment
; DESTROYS:	All registers except DS
; -----------------------------------------------------------------------------

; ------------- Installation check

InitAPM:	mov	ax,5300h	; AX <- function code
		xor	bx,bx		; BX <- 0 device ID of system BIOS
		xor	cx,cx		; CX <- 0 preset flags
		stc			; preset error flag
		int	15h		; installation check
		jc	short InitAPM6	; error, no APM
		cmp	bx,504Dh	; check magic, "PM"
		jne	short InitAPM6	; error, no APM
		test	cl,B1		; is 32-bit mode supported?
		jz	short InitAPM6	; 32-bit mode is not supported, error

; ------------- Store APM parameters

		mov	[APMVersion],ax	; store APM version
		mov	[APMFlags],cx	; store APM flags

; ------------- Disconnect interface

		mov	ax,5304h	; AX <- function code
		xor	bx,bx		; BX <- 0 device ID of system BIOS
		int	15h		; disconnect real mode interface

; ------------- Connect 32-bit protected mode interface

		mov	si,4000h	; SI <- preset if not supported
		mov	di,si		; DI <- preset if not supported
		mov	ax,5303h	; AX <- function code
		xor	bx,bx		; BX <- 0 device ID of system BIOS
		int	15h		; connect 32-bit mode interface
		jnc	InitAPM4	; OK
		mov	byte [APMVerMaj],0 ; error, APM is not supported
%ifdef DEBUG_APM
		jmp	short InitAPM6
%else
		ret
%endif
; ------------- Store interface parameters

InitAPM4:	mov	[APMEntry],ebx	; offset of entry point
		mov	[APMCode32],ax	; segment of 32-bit code
		mov	[APMCode16],cx	; segment of 16-bit code
		mov	[APMData],dx	; segment of data
		mov	[APMCodeLen],si	; segment length of code
		mov	[APMDataLen],di	; segment length of data

; ------------- Disconnect interface

		mov	ax,5304h	; AX <- function code
		xor	bx,bx		; BX <- 0 device ID of system BIOS
		int	15h		; disconnect real mode interface
InitAPM6:
; ------------- Debug - display APM info
%ifdef DEBUG_APM
		mov	si,APMMsg	; SI <- debug text
		call	BIOSDispText	; display debug text
		movzx	ax,byte [APMVerMaj] ; AX <- major version
		call	BIOSDispNum	; display major version
		mov	al,"."		; AL <- "."
		call	BIOSDispChar	; display decimal point
		movzx	ax,byte [APMVerMin] ; AX <- minor version
		call	BIOSDispNum	; display minor version
		mov	si,APMMsg2	; SI <- debug text
		call	BIOSDispText	; display debug text
		mov	ax,[APMFlags]	; AX <- APM flags
		call	BIOSDispHexWord	; display flags
		mov	si,APMMsg3	; SI <- debug text
		call	BIOSDispText	; display debug text
%endif
		ret

; -----------------------------------------------------------------------------
;                                   Data
; -----------------------------------------------------------------------------

		DATA16_SECTION

%ifdef DEBUG_APM
APMMsg:		db	13,10,'--- APM:',13,10
		db	'Version (0.x=not supported): ',0
APMMsg2:	db	13,10,'Flags: ',0
APMMsg3:	db	13,10,0
%endif

		align	4, db 0
APMVersion:
APMVerMin:	db	0		; APM minor version
APMVerMaj:	db	0		; APM major version (0=not supported)

APMFlags:	dw	0		; APM flags
					;   B0: 16-bit protected mode supported
					;   B1: 32-bit protected mode supported
					;   B2: CPU idle call reduces CPU speed
					;   B3: BIOS power management disabled
					;   B4: BIOS power manag. disengaged

		align	4, db 0
APMEntry:	dd	0		; offset of entry point
APMCode32:	dw	0		; segment of 32-bit code
APMCode16:	dw	0		; segment of 16-bit code
APMData:	dw	0		; segment of data
APMCodeLen:	dw	0		; segment length of code
APMDataLen:	dw	0		; segment length of data
