; =============================================================================
;
;                         Litos - Virtual memory
;
; =============================================================================

VIRTMEM_MID	EQU	SYSTEM_ADDR/2	; middle of task virtual space

; ------------- Table of virtual memory region functions

struc		VMFUNC

VMF_Open:	resd	1		; 0: open the region
					;   INPUT: EBX = pointer to VMREG
VMF_Close:	resd	1		; 4: close the region
					;   INPUT: EBX = pointer to VMREG
VMF_NoPage:	resd	1		; 8: page does not exist
					;   INPUT: EAX = fault address
					;	   EBX = virtual memory region
					;	   CL = flags, B0=write access
					;	   EDX = process descriptor
					;	   ESI = pointer to PTE
					;   OUTPUT: CY = memory error
					;   NOTES: Virtual memory spin-lock
					;	   must be locked.
					;	   It locks page cache.
endstruc

; ------------- Virtual memory region

struc		VMREG

		resb	RBNODE_size	; 0: red-black tree node
VMR_Start:	resd	1		; 18h: start address (=first byte)
VMR_End:	resd	1		; 1Ch: end address (=last byte)
					;   (size = end-start+1)
VMR_Flags:	resd	1		; 20h: flags (see below)
VMR_File:	resd	1		; 24h: mapped file (NULL=none)
VMR_Offset:	resd	2		; 28h: offset in mapped file
VMR_Share:	resb	LIST_size	; 30h: safe list of share regions
					;      or list of file mapping
VMR_Parent:	resd	1		; 38h: pointer to parent PROCESS
VMR_FuncTab:	resd	1		; 3Ch: pointer to functions VMFUNC

endstruc				; size 40h = 64 bytes

; ------------- Virtual memory region flags

VMR_READ	EQU	B0		; pages can be read
VMR_WRITE	EQU	B1		; pages can be written
VMR_EXEC	EQU	B2		; pages can be executed
VMR_SHARE	EQU	B3		; pages are shared by several processes
VMR_ALLACCESS	EQU	VMR_READ+VMR_WRITE+VMR_EXEC ; all access

VMR_MAYREAD	EQU	B4		; VM_READ flag may be set
VMR_MAYWRITE	EQU	B5		; VM_WRITE flag may be set
VMR_MAYEXEC	EQU	B6		; VM_EXEC flag may be set
VMR_MAYSHARE	EQU	B7		; VM_SHARE flag may be set
VMR_MAYALLACCESS EQU	VMR_MAYREAD+VMR_MAYWRITE+VMR_MAYEXEC ; may all access

VMR_GROWSDOWN	EQU	B8		; can expand toward lower addresses
VMR_GROWSUP	EQU	B9		; can expand toward higher addresses
;VMR_SHM	EQU	B10		; region is used for IPC shared memory
;VMR_DENYWRITE	EQU	B11		; maps a file tha cannot be written
;VMR_EXECUTABLE	EQU	B12		; the region maps an executable file
VMR_LOCKED	EQU	B13		; pages are locked,cannot swap them out
;VMR_IO		EQU	B14		; memory mapped I/O
;VMR_SEQ_READ	EQU	B15		; applic. accesses pages sequentially
;VMR_RAND_READ	EQU	B16		; applic. accesses pages randomly
;VMR_DONTCOPY	EQU	B17		; don't copy region on fork
;VMR_DONTEXPAND	EQU	B18		; cannot expand through mremap()
;VMR_RESERVED	EQU	B19		; does not swap out the region

VMR_COMMIT	EQU	B25		; pages are commited (else reserved)
VMR_FINDUP	EQU	B26		; search free region up
VMR_FINDDOWN	EQU	B27		; search free region down
VMR_OVERWRITE	EQU	B28		; overwrite existing region

VMR_STACK	EQU	VMR_ALLACCESS+VMR_MAYALLACCESS+VMR_GROWSDOWN ; stack

VMR_FLAGMASK1	EQU	VMR_ALLACCESS+VMR_SHARE+VMR_MAYALLACCESS+VMR_MAYSHARE
VMR_FLAGMASK2	EQU	VMR_GROWSDOWN+VMR_GROWSUP
VMR_FLAGMASK	EQU	VMR_FLAGMASK1+VMR_FLAGMASK2
