; =============================================================================
;
;                      Litos - Unicode character type
;
; =============================================================================

UNINOASC	EQU	"?"		; invalid ASCII alternative

CHTYPEMAX	EQU	2cffh		; maximal Unicode character type
					; ... on change run DebCheckNat!
NAT_MAXAHASH	EQU	(CHTYPEMAX/256+1) ; maximal alphabetic sub-table
NATSUBPAGES	EQU	1128		; size of nationality hash subpages

; ------------- Unicode character type

struc		UNITYPE

UNI_Flags:	resb	1		; 0: character flags (see below)
UNI_ASCII:	resb	1		; 1: ASCII alternative (UNINOASC=none)
UNI_Change:	resw	1		; 2: change small/cap. letter (0=none)

endstruc				; size 4 bytes

; ------------- Unicode character flags

CHNONE		EQU	0		; invalid character (hardcoded)

CHCTR		EQU	B0		; control character (flow control)
CHSPC		EQU	B1		; space (printable gap)
CHMRK		EQU	B2		; mark !?,.[]:'()
CHSIG		EQU	B3		; sign @#$%&*= (significant characters)
CHDIG		EQU	B4		; digit 0123456789
CHMOD		EQU	B5		; modifier (combined on same position)
CHCAP		EQU	B6		; capital letter (and other letters)
CHSMA		EQU	B7		; small letter

; ------------- Macro - Initialized Unicode character type
; %1 = character flags, %2 = ASCII alternative, %3 = change small/capital

%macro		UNITP	3
		db	%1		; character flags
		db	%2		; ASCII alternative (UNINOASC=none)
		dw	%3		; change small/capital letter (0=none)
%endmacro

; ------------- Macro - get pointer to descriptor of Unicode character type
; %1 = register with input character, %2 = input character LOW byte register,
; %3 = input character HIGH byte register, %4 = temporary register (can be
; the same with input character), %5 = output register with pointer to UNITYPE
; Input character must be in valid range 0 to CHTYPEMAX.

%macro		GETUNITYPE 5
		movzx	%5,%3		; %5 <- character HIGH
		mov	%5,[CHTypeTab+%5*4] ; %5 <- subtable
		movzx	%4,%2		; %4 <- character LOW
		lea	%5,[%5+%4*UNITYPE_size] ; %5 <- descriptor address
%endmacro
