; =============================================================================
;
;                              Litos - Tree list
;
; =============================================================================

; ------------- Tree list entry

struc		TREE

		resb	LIST_size	; 0: sibling list
TREE_Child:	resd	1		; 8: pointer to a child (NULL=none)
TREE_Parent:	resd	1		; 0Ch: pointer to parent (NULL=none)

endstruc				; size 16 bytes

; ------------- Macro - initialized tree list entry

%macro		TREEHEAD 0
		LISTHEAD		; sibling list
		dd	NULL		; no children
		dd	NULL		; pointer to parent (NULL=none)
%endmacro

; ------------- Macro - initialize tree list entry (%1=tree list entry)

%macro		TREEINIT 1
		LISTINIT %1		; initialize sibling list
		and	dword [%1+TREE_Child],byte 0 ; no children
		and	dword [%1+TREE_Parent],byte 0 ; no parent
%endmacro

; ------------- Macro - add tree list entry into tree list
; %1=destination entry (parent), %2=new entry, %3 and %4=temporary registers
; TREE_Child must contain either child list or NULL, other entries are ignored

%macro		TREEADD	4
		mov	%3,[%1+TREE_Child] ; get a child
		or	%3,%3		; is any child?
		jz	%%L		; there is no child
		LISTADD	%3,%2,%4	; add new entry into sibling list
%%L:		mov	[%1+TREE_Child],%2 ; set new entry as new child
		mov	[%2+TREE_Parent],%1 ; link parent to new entry
%endmacro

; ------------- Macro - delete (detach) tree list entry from the tree list
; %1=tree list entry (it must not be root!), %2 and %3=temporary registers

%macro		TREEDEL	3
		LISTDEL	%1,%2,%3	; detach from sibling list
		mov	%3,[%1+TREE_Parent] ; get parent
		cmp	%1,%2		; is list empty?
		jne	%%L		; list is not empty
		xor	%2,%2		; invalid child
%%L:		mov	[%3+TREE_Child],%2 ; set new child

%endmacro
