; =============================================================================
;
;                         Litos - Format text string
;
; =============================================================================
; Precision:
;  extended double (10 bytes, 80 bits) - 19 digits, exp. -4931 (-4950) to +4932
;  double (8 bytes, 64 bits) - 16 digits, exp. 
;  single (4 bytes, 32 bits) - 7 digits, exp.

; ------------- Formatting parameters (order of entries is hardcoded)

struc		FORMPAR

FORMPAR_Prec:	resb	1		; 0: precision:
					;     text - maximum number of chars
					;     integer - min. number of digits
					;     float and expon. - min. number of
					;	digits after decimal point
					;     mixed - total number of
					;	significant decimal digits
					;	(max. 18 digits)
FORMPAR_Width:	resb	1		; 1: minimal width of field
FORMPAR_TypeFlg:			; 2: type and flags (see below)
FORMPAR_Flags1:	resb	1		; 	2: flags 1 (see below)
FORMPAR_Flags2:	resb	1		; 	3: flags 2 (see below)

endstruc				; size 4 bytes

FORMPAR_TypeF_b	EQU	16		; bit offset of type and flags entry

; ------------- Formatting parameter type of argument

FORMTYPE_Mask	EQU	1fh		; mask of formatting parameter type
FORMTYPE_Mask0	EQU	0fh		; mask without capital letter flag
FORMTYPE_Bit	EQU	FORMPAR_TypeF_b	; mask - bit offset in FORMPAR

FORMTYPE_Par	EQU	0		; width/prec. parameter "*" (hardcoded)
FORMTYPE_Char	EQU	1		; single character "c", "C"
FORMTYPE_String	EQU	2		; string "s", "S"
FORMTYPE_ArgDW	EQU	FORMTYPE_String	; last "always 1 DWORD" argument type

FORMTYPE_Int	EQU	3		; signed decimal int "d", "D", "i"
FORMTYPE_UInt	EQU	4		; unsigned decimal integer "u", "U"
FORMTYPE_Bin	EQU	5		; unsigned binary integer "b", "B"
FORMTYPE_Oct	EQU	6		; unsigned octal integer "o", "O"
FORMTYPE_Hex	EQU	7		; unsigned hex integer "x", "X"
FORMTYPE_ArgInt	EQU	FORMTYPE_Hex	; last "integer" argument type

FORMTYPE_Float	EQU	8		; floating point without exp. "f", "F"
FORMTYPE_Exp	EQU	9		; exponential "e", "E"
FORMTYPE_Mix	EQU	10		; mixed (float. or exp.) "g", "G"

FORMTYPE_Cap	EQU	10h		; type flag - capital letter variant
FORMTYPE_Cap_b	EQU	(4+FORMPAR_TypeF_b) ; capital letter flag
					; F,E,G: does not round

; ------------- Formatting flags - bit offset in FORMPAR

FORMFLAG_Left_b	EQU	5+FORMPAR_TypeF_b ; left-justify "-"
FORMFLAG_Sign_b	EQU	6+FORMPAR_TypeF_b ; always use sign "+"
FORMFLAG_Spc_b	EQU	7+FORMPAR_TypeF_b ; prefix space if it is positive " "
FORMFLAG_Zero_b	EQU	8+FORMPAR_TypeF_b ; add zeroes "0" instead of spaces
FORMFLAG_Long_b	EQU	9+FORMPAR_TypeF_b ; long variant "l", "L", "I64"
FORMFLAG_Shrt_b	EQU	10+FORMPAR_TypeF_b ; short variant "h", "H", "I16"
FORMFLAG_Alt_b	EQU	11+FORMPAR_TypeF_b ; use alternate form "#"
					;  o,O,x,X,b,B: prefix 0, 0x, 0b
					;  e,E,f,F: always decimal point
					;  g,G: always decimal, don't truncate
FORMFLAG_Alt2_b	EQU	12+FORMPAR_TypeF_b ; use alternate form "##"
					;  o,O,x,X,b,B: suffix o, h, b
					;  e,E,f,F: truncate trailing zeroes
					;  g,G: always decimal point, truncate
FORMFLAG_Thsn_b	EQU	13+FORMPAR_TypeF_b ; use thousand separator "~"
FORMFLAG_Cent_b	EQU	14+FORMPAR_TypeF_b ; center "@" (ignored if "-" or "0")
FORMFLAG_Prec_b	EQU	15+FORMPAR_TypeF_b ; precision alternate flag ".."
					;   e,E,f: precision=signif.digits
					;   g,G: precision=fract.digits

; ------------- Formatting flags 1

FORMFLAG1_Left	EQU	B5		; left-justify "-"
FORMFLAG1_Sign	EQU	B6		; always use sign "+"
FORMFLAG1_Space	EQU	B7		; prefix space if it is positive " "

; ------------- Formatting flags 2

FORMFLAG2_Zero	EQU	B0		; add zeroes "0" instead of spaces
FORMFLAG2_Long	EQU	B1		; long variant "l", "L", "I64"
FORMFLAG2_Shrt	EQU	B2		; short variant "h", "H", "I16"
FORMFLAG2_Alt	EQU	B3		; use alternate form "#"
					;  o,O,x,X,b,B: prefix 0, 0x, 0b
					;  e,E,f,F: always decimal point
					;  g,G: always decimal, don't truncate
FORMFLAG2_Alt2	EQU	B4		; use alternate form "##"
					;  o,O,x,X,b,B: suffix o, h, b
					;  e,E,f,F: truncate trailing zeroes
					;  g,G: always decimal point, truncate
FORMFLAG2_Thsnd	EQU	B5		; use thousand separator "~"
FORMFLAG2_Cent	EQU	B6		; center "@" (ignored if left-justify
					;   or if use zeroes instead of spaces)
FORMFLAG2_Prec	EQU	B7		; precision alternate flag ".."
					;   e,E,f: precision=signif.digits
					;   g,G: precision=fract.digits
