; =============================================================================
;
;                            Litos - Text string
;
; =============================================================================

CTEXTREF	EQU	80000000h	; flag - constant text (hardcoded)
CTEXTREFHIGH	EQU	80h		; constant text, high byte
TEXTBIGPOS	EQU	7FFF0000h	; big positive position (with reserve)

; ------------- Text string data

struc		TEXTDATA

TEXT_Ref:	resd	1		; 0: reference counter (read-only < 0)
TEXT_Length:	resd	1		; 4: text length (in bytes)
TEXT_Text:				; 8: text (in UTF-8)

endstruc				; size: 8 + text length

; ------------- Text string

struc		TEXT
		resd	1		; 0: pointer to TEXTDATA structure
endstruc				; size: 4 bytes

; ------------- Macro - text string variable (%1 = pointer to TEXTDATA)

%macro		TEXTSTR 1
		dd	%1		; pointer to TEXTDATA
%endmacro

; ------------- Multi-Language text string (with language identifier)

struc		LANGTEXT
		resb	TEXT_size	; 0: text string
LANGTEXT_Lang:	resb	LANG_size	; 4: language identifier LANG
LANGTEXT_Num:	resw	1		; 6: number of languages in
					;    multi-language text array, it is
					;    valid only in first text entry,
					;    it may not be 0 in first entry
endstruc				; size: 8 bytes

; ------------- Macro - multi-language text string variable
; %1 = pointer to TEXTDATA, %2 = language main identifier, %3 sub-language
; identifier, %4 = number of languages in array (only first entry is valid)

%macro		LANGTEXTSTR 4
		dd	%1		; pointer to TEXTDATA
		LANGINI	%2,%3		; language identifier LANG
		dw	%4		; number of languages in array
%endmacro

; Sample of multi-language text:
;
; SampleName:	LANGTEXTSTR SampleTextEN,LANG_ENGLISH,SUBLANG_ENGLISH_US,3
; 		LANGTEXTSTR SampleTextCZ,LANG_CZECH,  SUBLANG_DEFAULT,   0
; 		LANGTEXTSTR SampleTextGE,LANG_GERMAN, SUBLANG_GERMAN,    0
;
; SampleTextEN:	CTEXTDATA 'Text sample'
; SampleTextCZ:	CTEXTDATA 'Priklad textu'
; SampleTextGE:	CTEXTDATA 'Text Beispiel'

; ------------- Macro - constant text string data (%1 = text in '')

%macro		CTEXTDATA 1+
		dd	CTEXTREF	; reference counter (= constant text)
		dd	%%L3-%%L2	; text length (in bytes)
%%L2:		db	%1		; text (in UTF-8)
%%L3:
		align	4, db 0
%endmacro

; ------------- Macro - constant text string with data (%1 = text in '')

%macro		CTEXT 1+
		TEXTSTR %%L1		; text string variable
%%L1:		CTEXTDATA %1		; text string
		align	4, db 0
%endmacro

; ------------- Macro - empty text string

%macro		EMPTYTEXT 0
		TEXTSTR EmptyTextData
%endmacro
