; =============================================================================
;
;                             Litos - Spin-lock
;
; =============================================================================
; Spin-lock is used to lock kernel control paths between processors to avoid 
; race-conditions. Spin-lock is a double-word with value 0 (spin-lock unlocked)
; or 1 (spin-lock locked). Spin-lock cannot be locked more times in the same
; CPU, so it should be used with interrupt disabled (to avoid task switching
; during lock).
; =============================================================================

SPINLOCK_size	EQU	4		; size of spin-lock

; ------------- Macro - initialized spin-lock

%define		SPINLOCK  dd	0

; ------------- Macro - initialize spin-lock (%1 = pointer)

%macro		LOCK_Init 1
%ifdef	SMP
		and	dword [%1],byte 0 ; initialize spin-lock
%endif
%endmacro

; ------------- Macro - lock spin-lock (%1 = pointer or address)

%macro		LOCK_Lock 1
%ifdef	SMP
%%L1:		lock			; CPU instruction lock
		bts	dword [%1],0	; try to lock spin-lock
		jc	%%L1		; next try to lock spin-lock
%endif
%endmacro

; ------------- Macro - try to lock spin-lock, returning CY
; %1 = pointer or address, returns CY = cannot lock

%macro		LOCK_TryLockC 1
%ifdef	SMP
		lock			; CPU instruction lock
		bts	dword [%1],0	; try to lock spin-lock
%else
		clc			; wihout SMP locked OK
%endif
%endmacro

; ------------- Macro - try to lock spin-lock
; %1 = pointer or address, %2 = address to jump if spin-lock cannot be locked

%macro		LOCK_TryLock 2
%ifdef	SMP
		lock			; CPU instruction lock
		bts	dword [%1],0	; try to lock spin-lock
		jc	%2		; spin-lock was already locked
%endif
%endmacro

; ------------- Macro - unlock spin-lock (%1=pointer or address, saves FLAGS)

%macro		LOCK_Unlock 1
%ifdef	SMP
		mov	byte [%1],0	; unlock spin-lock
%endif
%endmacro
