; =============================================================================
;
;                       Litos - Red-black balanced tree
;
; =============================================================================

; ------------- Red-black common head

struc		RBCOMMON

		resb	LIST_size	; 0: list of entries
RB_ColorFlags:
RB_Color:	resb	1		; 8: color of node (see below)
RB_Flags:	resb	1		; 9: flags (see below)
RB_DataW:	resw	1		; 0Ah: possible data of tree node, WORD

endstruc				; size 12 bytes

; ------------- Red-black color of node

RB_RED		EQU	0		; red color of node (hardcoded)
RB_BLACK	EQU	1		; black color of node

; ------------- Red-black flags

RB_ROOT		EQU	B0		; this is the root (else this is node)

; ------------- Red-black balanced tree root

struc		RBROOT

		resb	RBCOMMON_size	; common head (list and flags)
RBR_Node:	resd	1		; 0Ch: pointer to first node (0=empty)
RBR_Count:	resd	1		; 10h: number of nodes in the tree

endstruc				; size 14h = 20 bytes

; ------------- Red-black balanced tree node

struc		RBNODE

		resb	RBCOMMON_size	; common head (list and flags)
RBN_Parent:	resd	1		; 0Ch: parent node (NULL=root)
RBN_Left:	resd	1		; 10h: left node (lower, 0=none)
RBN_Right:	resd	1		; 14h: right node (higher, 0=none)
					;      (hardcoded: right = left + 4)
RBN_Data:				; 18h: possible data of tree node

endstruc				; size 18h = 24 bytes

; ------------- Macro - initialized red-black tree root

%macro		RBTREE	0

		LISTHEAD		; list of entries
		db	RB_BLACK	; color of node
		db	RB_ROOT		; flags
		dw	0		; data WORD
		dd	0		; pointer to first node (0=none)
		dd	0		; number of nodes
%endmacro

; ------------- Macro - initialized red-black tree node

%macro		RBTREENODE 0

		LISTHEAD		; list of entries
		db	RB_RED		; color of node
		db	0		; flags
		dw	0		; data WORD
		dd	0		; parent node (NULL=root)
		dd	0		; left node (NULL=none)
		dd	0		; right node (NULL=none)
%endmacro
