; =============================================================================
;
;                              Litos - List
;
; =============================================================================

; ------------- List entry or list head
; List head is empty (contains no entries), if LIST_Next points to itself.
; List entry normally has undefined pointers if it is not in a list
; (it need not to be initialized) but it can be used as safe entry, where
; LIST_Next points to itself as flag that the entry is not linked in any list.

struc		LIST

LIST_Next:	resd	1		; 0: pointer to next (first) entry
					; should be first entry, more optimized
LIST_Prev:	resd	1		; 4: pointer to previous (last) entry

endstruc				; size 8 bytes

; ------------- Macro - initialized list head (or initialized safe list entry)

%define		LISTHEAD dd	$,$

; ------------- Macro - initialized linked list entry
; %1 = pointer to next entry, %2 = pointer to previous entry

%macro		LINKEDLIST 2
		dd	%1,%2
%endmacro

; ------------- Macro - initialize list head (%1 = pointer to list head)

%macro		LISTINIT 1
		mov	[%1+LIST_Next],%1 ; next (first) entry in chain
		mov	[%1+LIST_Prev],%1 ; previous (last) entry in chain
%endmacro

; ------------- Macro - link two entries together (%1=1st entry, %2=2nd entry)

%macro		LINKLINK 2
		mov	[%1+LIST_Next],%2 ; link second entry after first one
		mov	[%2+LIST_Prev],%1 ; link first entry previous second
%endmacro

; ------------- Macro - add new entry into begin of list or after current entry
; %1 = list head or current entry, %2 = new entry, %3 = temporary register

%macro		LISTADD	3
		mov	%3,[%1+LIST_Next] ; get next (first) entry
		LINKLINK %1,%2		; link head/current with new entry
		LINKLINK %2,%3		; link new entry with next entry
%endmacro

; ------------- Macro - add new entry into end of list or before current entry
; %1 = list head or current entry, %2 = new entry, %3 = temporary register

%macro		LISTLAST 3
		mov	%3,[%1+LIST_Prev] ; get previous (last) entry
		LINKLINK %3,%2		; link new entry with previous entry
		LINKLINK %2,%1		; link head/current with new entry
%endmacro

; ------------- Macro - delete (detach) entry from the list
; %1 = entry to delete, %2 and %3 = temporary registers
; %1 and %3 can be the same, in that case content of %1 will be changed
; On output: %2 = old previous entry, %3 = old next entry

%macro		LISTDEL	3
		mov	%2,[%1+LIST_Prev] ; get previous entry
		mov	%3,[%1+LIST_Next] ; get next entry
		LINKLINK %2,%3		; link previous entry with next entry
%endmacro

; ------------- Macro - detach entry from the previous entry
; %1 = entry to delete, %2 = previous entry, %3 = temporary registers

%macro		LISTDELPREV 3
		mov	%3,[%1+LIST_Next] ; get next entry
		LINKLINK %2,%3		; link previous entry with next entry
%endmacro

; ------------- Macro - test if list is empty (output: ZY = list is empty)
; %1 = pointer to list head

%macro		LISTTEST 1
		cmp	dword [%1+LIST_Next],%1 ; check if list is empty
%endmacro

; ------------- Macro - mark safe list entry as empty (%1 = safe list entry)

%macro		LISTEMPTY 1
		mov	dword [%1+LIST_Next],%1 ; mark safe list entry as empty
%endmacro
