; =============================================================================
;
;                      Litos - Languages and nationality
;
; =============================================================================

NAT_NUM		EQU	2		; number of nationality descriptors
NAT_DEF		EQU	0		; index of default nation. descriptor
;%define	NATTABDEF NatTabCZ	; default nationality descriptor
%define		NATTABDEF NatTabEN	; default nationality descriptor

; ------------- Language identifier

struc		LANG

LANG_SubID:	resb	1		; 0: sub-language identifier
LANG_ID:	resb	1		; 1: language main identifier

endstruc				; size 2 bytes

; ------------- Macro - initialized language identifier
; %1 = language main identifier, %2 = sub-language identifier

%macro		LANGINI	2
		db	%2		; sub-language identifier
		db	%1		; language main identifier
%endmacro

; ------------- Nationality descriptor
; Text strings may be max. 255 characters long.

struc		NATIONAL

NAT_ShortName:	resb	TEXT_size	; 0: short name of national
NAT_LongName:	resb	TEXT_size	; 4: long name of national
NAT_LangName:	resb	TEXT_size	; 8: long name of national in language
NAT_Language:	resb	LANG_size	; 0Ch: language identifier
NAT_CodePage:	resw	1		; 0Eh: default character code page
NAT_Alphabet:	resb	TEXT_size	; 10h: alphabetic order table
NAT_AlphaHash:	resd	1		; 14h: hash table to get sorting order
NAT_ShortTime:	resb	TEXT_size	; 18h: short time formatting string
NAT_LongTime:	resb	TEXT_size	; 1Ch: long time formatting string
NAT_ShortDate:	resb	TEXT_size	; 20h: short date formatting string
NAT_LongDate:	resb	TEXT_size	; 24h: long date formatting string
NAT_TimeSep:	resb	1		; 28h: ASCII time separator
NAT_DateSep:	resb	1		; 29h: ASCII date separator
NAT_DecimalSep:	resb	1		; 2Ah: ASCII decimal separator
NAT_ThsndSep:	resb	1		; 2Bh: ASCII thousand separator
NAT_EntrySep:	resb	1		; 2Ch: ASCII data entry separator
		resb	3		; 2Dh: ...padding
NAT_ShortAMPM:	resb	TEXT_size*2	; 30h: short AM/PM text
NAT_LongAMPM:	resb	TEXT_size*2	; 38h: long AM/PM text
					;  AM=ante meridiem, PM=post meridiem
NAT_ShortBCECE:	resb	TEXT_size*2	; 40h: short BCE/CE text
NAT_LongBCECE:	resb	TEXT_size*2	; 48h: long BCE/CE text
					;  BCE=Before Common Era, CE=Common Era
NAT_ShortWeek:	resb	TEXT_size*7	; 50h: 3-char names of days in week
NAT_LongWeek:	resb	TEXT_size*7	; 6Ch: long names of days in week
NAT_ShortMonth:	resb	TEXT_size*12	; 88h: 3-char names of months
NAT_LongMonth:	resb	TEXT_size*12	; 0B8h: long names of months
NAT_LongMonth1:	resb	TEXT_size*12	; 0E8h: long names of months, 1st case

endstruc				; size 118h = 280 bytes

; ------------- Macro - get default nationality descriptor (%1 = register)

%macro		DEFAULT_NAT 1

		CURRENT_USER %1		; get current user
		mov	%1,[%1+USER_National] ; get user's nationality
%endmacro

; ------------- Macro - initialized nationality descriptor
; %1=nation name, %2=language main identifier, %3=sub-language identifier,
; %4=code page, %5=time separator, %6=date separator, %7=decimal separator
; %8=thousand separator, %9=entry separator


%macro		NATION	9
		dd	ShortName %+ %1	; short name of national
		dd	LongName %+ %1	; long name of national
		dd	LangName %+ %1	; long name of national in language
		LANGINI	%2,%3		; language identifier
		dw	%4		; default character code page
		dd	Alphabet %+ %1	; alphabetic order table
		dd	NULL		; hash table to get sorting order
		dd	ShortTime %+ %1	; short time formatting string
		dd	LongTime %+ %1	; long time formatting string
		dd	ShortDate %+ %1	; short date formatting string
		dd	LongDate %+ %1	; long date formatting string
		db	%5		; time separator
		db	%6		; date separator
		db	%7		; decimal separator
		db	%8		; thousand separator
		db	%9		; entry separator
		db	0,0,0	        ; ...padding
		dd	ShortAM %+ %1	; short AM text
		dd	ShortPM %+ %1	; short PM text
		dd	LongAM %+ %1	; long AM text
		dd	LongPM %+ %1	; long PM text
		dd	ShortBCE %+ %1	; short BCE text
		dd	ShortCE %+ %1	; short CE text
		dd	LongBCE %+ %1	; long BCE text
		dd	LongCE %+ %1	; long CE text
		dd	ShortWeek %+ %1	%+ 1 ; 3-char names of days in week
		dd	ShortWeek %+ %1	%+ 2
		dd	ShortWeek %+ %1	%+ 3
		dd	ShortWeek %+ %1	%+ 4
		dd	ShortWeek %+ %1	%+ 5
		dd	ShortWeek %+ %1	%+ 6
		dd	ShortWeek %+ %1	%+ 7
		dd	LongWeek %+ %1 %+ 1 ; long names of days in week
		dd	LongWeek %+ %1 %+ 2
		dd	LongWeek %+ %1 %+ 3
		dd	LongWeek %+ %1 %+ 4
		dd	LongWeek %+ %1 %+ 5
		dd	LongWeek %+ %1 %+ 6
		dd	LongWeek %+ %1 %+ 7
		dd	ShortMonth %+ %1 %+ 1 ; 3-char names of months
		dd	ShortMonth %+ %1 %+ 2
		dd	ShortMonth %+ %1 %+ 3
		dd	ShortMonth %+ %1 %+ 4
		dd	ShortMonth %+ %1 %+ 5
		dd	ShortMonth %+ %1 %+ 6
		dd	ShortMonth %+ %1 %+ 7
		dd	ShortMonth %+ %1 %+ 8
		dd	ShortMonth %+ %1 %+ 9
		dd	ShortMonth %+ %1 %+ 10
		dd	ShortMonth %+ %1 %+ 11
		dd	ShortMonth %+ %1 %+ 12
		dd	LongMonth %+ %1	%+ 1 ; long names of months
		dd	LongMonth %+ %1	%+ 2
		dd	LongMonth %+ %1	%+ 3
		dd	LongMonth %+ %1	%+ 4
		dd	LongMonth %+ %1	%+ 5
		dd	LongMonth %+ %1	%+ 6
		dd	LongMonth %+ %1	%+ 7
		dd	LongMonth %+ %1	%+ 8
		dd	LongMonth %+ %1	%+ 9
		dd	LongMonth %+ %1	%+ 10
		dd	LongMonth %+ %1	%+ 11
		dd	LongMonth %+ %1	%+ 12
		dd	LongMonth1 %+ %1 %+ 1 ; long names of months, 1st case
		dd	LongMonth1 %+ %1 %+ 2
		dd	LongMonth1 %+ %1 %+ 3
		dd	LongMonth1 %+ %1 %+ 4
		dd	LongMonth1 %+ %1 %+ 5
		dd	LongMonth1 %+ %1 %+ 6
		dd	LongMonth1 %+ %1 %+ 7
		dd	LongMonth1 %+ %1 %+ 8
		dd	LongMonth1 %+ %1 %+ 9
		dd	LongMonth1 %+ %1 %+ 10
		dd	LongMonth1 %+ %1 %+ 11
		dd	LongMonth1 %+ %1 %+ 12
%endmacro

; ------------- Language main identifier

LANG_DEFAULT	EQU	0		; default or undefined language
LANG_ARABIC	EQU	1
LANG_BULGARIAN	EQU	2
LANG_CATALAN	EQU	3
LANG_CHINESE	EQU	4
LANG_CZECH	EQU	5
LANG_DANISH	EQU	6
LANG_GERMAN	EQU	7
LANG_GREEK	EQU	8
LANG_ENGLISH	EQU	9
LANG_SPANISH	EQU	10
LANG_FINNISH	EQU	11
LANG_FRENCH	EQU	12
LANG_HEBREW	EQU	13
LANG_HUNGARIAN	EQU	14
LANG_ICELANDIC	EQU	15
LANG_ITALIAN	EQU	16
LANG_JAPANESE	EQU	17
LANG_KOREAN	EQU	18
LANG_DUTCH	EQU	19
LANG_NORWEGIAN	EQU	20
LANG_POLISH	EQU	21
LANG_PORTUGUESE	EQU	22
; reserved	EQU	23
LANG_ROMANIAN	EQU	24
LANG_RUSSIAN	EQU	25
LANG_CROATIAN	EQU	26
LANG_SERBIAN	EQU	LANG_CROATIAN
LANG_SLOVAK	EQU	27
LANG_ALBANIAN	EQU	28
LANG_SWEDISH	EQU	29
LANG_THAI	EQU	30
LANG_TURKISH	EQU	31
LANG_URDU	EQU	32
LANG_INDONESIAN	EQU	33
LANG_UKRAINIAN	EQU	34
LANG_BELARUSIAN	EQU	35
LANG_SLOVENIAN	EQU	36
LANG_ESTONIAN	EQU	37
LANG_LATVIAN	EQU	38
LANG_LITHUANIAN	EQU	39
; reserved	EQU	40
LANG_FARSI	EQU	41
LANG_VIETNAMESE	EQU	42
LANG_ARMENIAN	EQU	43
LANG_AZERI	EQU	44
LANG_BASQUE	EQU	45
; reserved	EQU	46
LANG_MACEDONIAN	EQU	47
; reserved	EQU	48-53
LANG_AFRIKAANS	EQU	54
LANG_GEORGIAN	EQU	55
LANG_FAEROESE	EQU	56
LANG_HINDI	EQU	57
; reserved	EQU	58-61
LANG_MALAY	EQU	62
LANG_KAZAK	EQU	63
LANG_KYRGYZ	EQU	64
LANG_SWAHILI	EQU	65
; reserved	EQU	66
LANG_UZBEK	EQU	67
LANG_TATAR	EQU	68
LANG_BENGALI	EQU	69
LANG_PUNJABI	EQU	70
LANG_GUJARATI	EQU	71
LANG_ORIYA	EQU	72
LANG_TAMIL	EQU	73
LANG_TELUGU	EQU	74
LANG_KANNADA	EQU	75
LANG_MALAYALAM	EQU	76
LANG_ASSAMESE	EQU	77
LANG_MARATHI	EQU	78
LANG_SANSKRIT	EQU	79
LANG_MONGOLIAN	EQU	80
; reserved	EQU	81-85
LANG_GALICIAN	EQU	86
LANG_KONKANI	EQU	87
LANG_MANIPURI	EQU	88
LANG_SINDHI	EQU	89
LANG_SYRIAC	EQU	90
; reserved	EQU	91-95
LANG_KASHMIRI	EQU	96
LANG_NEPALI	EQU	97
; reserved	EQU	98-100
LANG_DIVEHI	EQU	101
; reserved	EQU	102-126
LANG_INVARIANT	EQU	127

; ------------- Sub-language identifier - LANG_DEFAULT

SUBLANG_NEUTRAL			EQU	0	; can be used for all languages
SUBLANG_DEFAULT			EQU	1	; can be used for all languages
SUBLANG_SYS_DEFAULT		EQU	2

; ------------- Sub-language identifier - LANG_ARABIC

SUBLANG_ARABIC_SAUDI_ARABIA	EQU	1
SUBLANG_ARABIC_IRAQ		EQU	2
SUBLANG_ARABIC_EGYPT		EQU	3
SUBLANG_ARABIC_LIBYA		EQU	4
SUBLANG_ARABIC_ALGERIA		EQU	5
SUBLANG_ARABIC_MOROCCO		EQU	6
SUBLANG_ARABIC_TUNISIA		EQU	7
SUBLANG_ARABIC_OMAN		EQU	8
SUBLANG_ARABIC_YEMEN		EQU	9
SUBLANG_ARABIC_SYRIA		EQU	10
SUBLANG_ARABIC_JORDAN		EQU	11
SUBLANG_ARABIC_LEBANON		EQU	12
SUBLANG_ARABIC_KUWAIT		EQU	13
SUBLANG_ARABIC_UAE		EQU	14
SUBLANG_ARABIC_BAHRAIN		EQU	15
SUBLANG_ARABIC_QATAR		EQU	16

; ------------- Sub-language identifier - LANG_AZERI

SUBLANG_AZERI_LATIN		EQU	1
SUBLANG_AZERI_CYRILLIC		EQU	2

; ------------- Sub-language identifier - LANG_CHINESE

SUBLANG_CHINESE_TRADITIONAL	EQU	1
SUBLANG_CHINESE_SIMPLIFIED	EQU	2
SUBLANG_CHINESE_HONGKONG	EQU	3
SUBLANG_CHINESE_SINGAPORE	EQU	4
SUBLANG_CHINESE_MACAU		EQU	5

; ------------- Sub-language identifier - LANG_DUTCH

SUBLANG_DUTCH			EQU	1
SUBLANG_DUTCH_BELGIAN		EQU	2

; ------------- Sub-language identifier - LANG_ENGLISH

SUBLANG_ENGLISH_US		EQU	1	; USA
SUBLANG_ENGLISH_UK		EQU	2
SUBLANG_ENGLISH_AUS		EQU	3	; Australian
SUBLANG_ENGLISH_CAN		EQU	4	; Canadian
SUBLANG_ENGLISH_NZ		EQU	5	; New Zealand
SUBLANG_ENGLISH_EIRE		EQU	6	; Irish
SUBLANG_ENGLISH_SOUTH_AFRICA	EQU	7
SUBLANG_ENGLISH_JAMAICA		EQU	8
SUBLANG_ENGLISH_CARIBBEAN	EQU	9
SUBLANG_ENGLISH_BELIZE		EQU	10
SUBLANG_ENGLISH_TRINIDAD	EQU	11
SUBLANG_ENGLISH_ZIMBABWE	EQU	12
SUBLANG_ENGLISH_PHILIPPINES	EQU	13

; ------------- Sub-language identifier - LANG_FRENCH

SUBLANG_FRENCH			EQU	1
SUBLANG_FRENCH_BELGIAN		EQU	2
SUBLANG_FRENCH_CANADIAN		EQU	3
SUBLANG_FRENCH_SWISS		EQU	4
SUBLANG_FRENCH_LUXEMBOURG	EQU	5
SUBLANG_FRENCH_MONACO		EQU	6

; ------------- Sub-language identifier - LANG_GERMAN

SUBLANG_GERMAN			EQU	1
SUBLANG_GERMAN_SWISS		EQU	2
SUBLANG_GERMAN_AUSTRIAN		EQU	3
SUBLANG_GERMAN_LUXEMBOURG	EQU	4
SUBLANG_GERMAN_LIECHTENSTEIN	EQU	5

; ------------- Sub-language identifier - LANG_ITALIAN

SUBLANG_ITALIAN			EQU	1
SUBLANG_ITALIAN_SWISS		EQU	2

; ------------- Sub-language identifier - LANG_KASHMIRI

SUBLANG_KASHMIRI		EQU	1
SUBLANG_KASHMIRI_SASIA 		EQU	2
SUBLANG_KASHMIRI_INDIA		EQU	2

; ------------- Sub-language identifier - LANG_MALAY

SUBLANG_MALAY_MALAYSIA		EQU	1
SUBLANG_MALAY_BRUNEI_DARUSSALAM	EQU	2

; ------------- Sub-language identifier - LANG_NEPALI

SUBLANG_NEPALI			EQU	1
SUBLANG_NEPALI_INDIA		EQU	2

; ------------- Sub-language identifier - LANG_NORWEGIAN

SUBLANG_NORWEGIAN_BOKMAL	EQU	1
SUBLANG_NORWEGIAN_NYNORSK	EQU	2

; ------------- Sub-language identifier - LANG_PORTUGUESE

SUBLANG_PORTUGUESE_BRAZILIAN	EQU	1
SUBLANG_PORTUGUESE		EQU	2

; ------------- Sub-language identifier - LANG_SERBIAN

SUBLANG_SERBIAN			EQU	1
SUBLANG_SERBIAN_LATIN		EQU	2
SUBLANG_SERBIAN_CYRILLIC	EQU	3

; ------------- Sub-language identifier - LANG_SPANISH

SUBLANG_SPANISH			EQU	1
SUBLANG_SPANISH_MEXICAN		EQU	2
SUBLANG_SPANISH_MODERN		EQU	3	; Spain
SUBLANG_SPANISH_GUATEMALA	EQU	4
SUBLANG_SPANISH_COSTA_RICA	EQU	5
SUBLANG_SPANISH_PANAMA		EQU	6
SUBLANG_SPANISH_DOMINICAN_REPUBLIC EQU	7
SUBLANG_SPANISH_VENEZUELA	EQU	8
SUBLANG_SPANISH_COLOMBIA	EQU	9
SUBLANG_SPANISH_PERU		EQU	10
SUBLANG_SPANISH_ARGENTINA	EQU	11
SUBLANG_SPANISH_ECUADOR		EQU	12
SUBLANG_SPANISH_CHILE		EQU	13
SUBLANG_SPANISH_URUGUAY		EQU	14
SUBLANG_SPANISH_PARAGUAY	EQU	15
SUBLANG_SPANISH_BOLIVIA		EQU	16
SUBLANG_SPANISH_EL_SALVADOR	EQU	17
SUBLANG_SPANISH_HONDURAS	EQU	18
SUBLANG_SPANISH_NICARAGUA	EQU	19
SUBLANG_SPANISH_PUERTO_RICO	EQU	20

; ------------- Sub-language identifier - LANG_SWEDISH

SUBLANG_SWEDISH			EQU	1
SUBLANG_SWEDISH_FINLAND		EQU	2

; ------------- Sub-language identifier - LANG_URDU

SUBLANG_URDU_PAKISTAN		EQU	1
SUBLANG_URDU_INDIA		EQU	2

; ------------- Sub-language identifier - LANG_UZBEK

SUBLANG_UZBEK_LATIN		EQU	1
SUBLANG_UZBEK_CYRILLIC		EQU	2
