; =============================================================================
;
;                             Litos - Hash list
;
; =============================================================================

; HASHH_First and HASHE_Next must be on the same offset (= on begin of struc)

; ------------- Hash list head

struc		HASHH

HASHH_First:	resd	1		; 0: pointer to first entry (0=empty)

endstruc				; size 4 bytes

; ------------- Hash list entry

struc		HASHE

HASHE_Next:	resd	1		; 0: pointer to next entry (0=none)
					;    (pointer must be first entry!)
HASHE_Prev:	resd	1		; 4: pointer to previous entry

endstruc				; size 8 bytes

; ------------- Macro - initialized hash list head

%define		HASHHEAD dd	NULL

; ------------- Macro - initialized hash list entry

%macro		HASHENTRY 0

		dd	NULL		; pointer to next entry (NULL=none)
		dd	NULL		; pointer to previous entry

%endmacro

; ------------- Macro - initialized hash list (%1 = hash list size)

%macro		HASHLIST 1
 %rep %1
		HASHHEAD
 %endrep
%endmacro

; ------------- Macro - initialize hash list head (%1 = pointer to head)

%macro		HASHHINIT 1
		and	dword [%1+HASHH_First],byte NULL ; no first entry
%endmacro

; ------------- Macro - test if hash list is empty (output: ZY = list is empty)
; %1 = pointer to hash list head

%macro		HASHHTEST 1
		cmp	dword [%1+HASHH_First],byte NULL ; is list empty?
%endmacro
