; =============================================================================
;
;                           Litos - Character sets
;
; =============================================================================

FONTMAX		EQU	266Bh		; maximal UNICODE character
FONTMAP		EQU	(FONTMAX/256+1)	; number of UNICODE mapping pages (=39)
CHINV		EQU	0		; invalid character (hardcoded)

; ------------- Character set

struc		CHARSET

CHSET_CodePage:	resw	1		; 0: code page (see below)
CHSET_Res:	resb	1		; 2: ...reserved (set to 0)
CHSET_Flags:	resb	1		; 3: flags (see below)
CHSET_ToUni:	resd	1		; 4: table to Unicode
CHSET_FromUni:	resd	1		; 8: table from Unicode
CHSET_ReadChar:	resd	1		; 0Ch: read character from buffer func.
					;	INPUT:	EBX = CHARSET pointer
					;		ECX = remaining bytes
					;		EDX = invalid char.
					;		ESI = source buffer
					;	OUTPUT:	EAX = Unicode char
					;		ECX = next remaining
					;		ESI = next source
CHSET_WriteChar:resd	1		; 10h: write character into buffer fnc.
					;	INPUT:	EAX = Unicode char
					;		EBX = CHARSET pointer
					;		DL = invalid char.
					;		EDI = dest. buffer
					;		EBP = remaining bytes
					;	OUTPUT:	EDI = next destination
					;		EBP = next remaining
					;	DESTROYS: EAX
CHSET_SizeChar:	resd	1		; 14h: get size of character
					;	INPUT:	EAX = Unicode char
					;		EBX = CHARSET pointer
					;		EDI = data counter
					;	OUTPUT:	EDI = next data counter
					;	DESTROYS: EAX

endstruc				; size 18h = 24 bytes

; ------------- Flags

CHSET_MBYTE	EQU	B0		; multibyte character set

; ------------- Supported code pages
; On changes verify tables with DEBUG_CODEPAGE debug flag.

CHARSETNUM	EQU	44		; number of character sets

				; special single byte codes
CP_ASCII	EQU	0		; ASCII
CP_DEC		EQU	1		; DEC VT100 graphics
				; OEM Codepages (DOS)
CP_IBM437	EQU	437		; IBM-437 (United States)
CP_IBM720	EQU	720		; Asmo-720 (Arabic)
CP_IBM737	EQU	737		; IBM-737 (Greek)
CP_IBM775	EQU	775		; IBM-775 (Baltic)
CP_IBM850	EQU	850		; IBM-850 (Latin 1, West Europe)
CP_IBM852	EQU	852		; IBM-852 (Latin 2, Central European)
CP_IBM855	EQU	855		; IBM-855 (Cyrillic, primarily Russian)
CP_IBM857	EQU	857		; IBM-857 (Turkish)
CP_IBM858	EQU	858		; IBM-858 (Latin 1 + Euro)
CP_IBM860	EQU	860		; IBM-860 (Portuguese)
CP_IBM861	EQU	861		; IBM-861 (Icelandic)
CP_IBM862	EQU	862		; IBM-862 (Hebrew)
CP_IBM863	EQU	863		; IBM-863 (French Canadian)
CP_IBM865	EQU	865		; IBM-865 (Nordic)
CP_IBM866	EQU	866		; IBM-866 (Russian)
CP_IBM869	EQU	869		; IBM-869 (Modern Greek)
CP_IBM895	EQU	895		; IBM-895 (Kamenickych, Czech)
				; Windows Single Byte Character Set Codepages
CP_WIN874	EQU	874		; Windows-874 (Thai)
CP_WIN1250	EQU	1250		; Windows-1250 (Central Europe)
CP_WIN1251	EQU	1251		; Windows-1251 (Cyrillic)
CP_WIN1252	EQU	1252		; Windows-1252 (Latin 1 Windows)
CP_WIN1253	EQU	1253		; Windows-1253 (Greek)
CP_WIN1254	EQU	1254		; Windows-1254 (Turkish)
CP_WIN1255	EQU	1255		; Windows-1255 (Hebrew)
CP_WIN1256	EQU	1256		; Windows-1256 (Arabic)
CP_WIN1257	EQU	1257		; Windows-1257 (Baltic)
CP_WIN1258	EQU	1258		; Windows-1258 (Vietnam)
				; ISO Codepages
CP_ISO88591	EQU	28591		; ISO 8859-1 (Latin 1 Western European)
CP_ISO88592	EQU	28592		; ISO 8859-2 (Latin 2 Central European)
CP_ISO88593	EQU	28593		; ISO 8859-3 (Latin 3)
CP_ISO88594	EQU	28594		; ISO 8859-4 (Baltic)
CP_ISO88595	EQU	28595		; ISO 8859-5 (Cyrillic)
CP_ISO88596	EQU	28596		; ISO 8859-6 (Arabic)
CP_ISO88597	EQU	28597		; ISO 8859-7 (Greek)
CP_ISO88598	EQU	28598		; ISO 8859-8 (Hebrew)
CP_ISO88599	EQU	28599		; ISO 8859-9 (Turkish)
CP_ISO885915	EQU	28605		; ISO 8859-15 (Latin 9)
				; multibyte codepages
CP_UTF16LE	EQU	1200		; Unicode UTF-16LE (little endian, PC)
CP_UTF16BE	EQU	1201		; Unicode UTF-16BE (big endian, MAC)
CP_UTF32LE	EQU	12000		; Unicode UTF-32LE (little endian, PC)
CP_UTF32BE	EQU	12001		; Unicode UTF-32BE (big endian, MAC)
CP_UTF8		EQU	65001		; Unicode UTF-8

CP_UNICODE	EQU	CP_UTF32LE	; native Unicode code page
