; =============================================================================
;
;                              Litos - Calendar
;
; =============================================================================

; Last day of Julian calendar: 10/4/1582,
; First day of Gregorian calendar: 10/15/1582
SPLITYEAR	EQU	1582		; split year Julian -> Gregorian
SPLITDATE	EQU	577737		; split day 10/15/1582

MINYEAR		EQU	-29226		; minimal year
MAXYEAR		EQU	+29227		; maximal year

MINDAY		EQU	-10675162	; minimal day
MAXDAY		EQU	+10674943	; maximal day

; MINTIME: -9223339968000000000
MINTIMEH	EQU	80001D2Ah	; minimal absolute time HIGH
MINTIMEL	EQU	9CB28000h	; minimal absolute time LOW

; MAXTIME: +9223151615999999999
MAXTIMEH	EQU	7FFF3787h	; maximal absolute time HIGH
MAXTIMEL	EQU	453FFFFFh	; maximal absolute time LOW

; ------------- Date-time structure
; Hardcoded in CMOSDevGetTime

struc		DATETIME

DATETIME_NSec:	resd	1		; 0: nanosecond (0 to 999'999'999)
DATETIME_Time:				; time entries (second, minute, hour)
DATETIME_Sec:	resb	1		; 4: second (0 to 59)
DATETIME_Min:	resb	1		; 5: minute (0 to 59)
DATETIME_Hour:	resb	1		; 6: hour (0 to 23)
DATETIME_WDay:	resb	1		; 7: day of week (1=Monday..7=Sunday)
DATETIME_Date:				; date entries (day, month, year)
DATETIME_Day:	resb	1		; 8: day in month (1 to 31)
DATETIME_Month:	resb	1		; 9: month (1 to 12)
DATETIME_Year:	resw	1		; 0Ah: year (year > 0 means CE,
					;	 year <= 0 means "1-BCE", e.g.
					; 	0 is 1 BCE, -1 is 2 BCE, ...)
					; (CE="Common Era" or AD="Anno Domini",
					;     BCE="Before the Common Era" or
					;     BC="Before Christ"

; Extended entries, generated with DateTimeExt function

DATETIME_YDay:	resw	1		; 0Ch: day in year (0 to 365)
DATETIME_Week:	resb	1		; 0Eh: week (1 to 53)
DATETIME_Flags:	resb	1		; 0Fh: flags
					;	B0: leap year,366 days else 365
					;	    (year 1582 has 355 days)
					;	B1: Gregorian calendar
					;	B2: 53 weeks (else 52)
					;	    (year 1582 has 51 weeks)
					;	B3: last week of previous year
					;	    (week=51 to 53, use year-1)
					;	B4: first week of next year
					;	    (week=1, use year+1)

endstruc				; size 16 bytes

; ------------- Macro - convert absolute time to Windows FILETIME
; %1 = time LOW, %2  time HIGH (correction: 584390 days = 504912960000000000)

%macro		ABSTOFILETIME 2
		sub	%1,774A8000h	; correction LOW
		sbb	%2,701CFA9h	; correction HIGH
%endmacro

; ------------- Macro - convert Windows FILETIME to absolute time
; %1 = time LOW, %2  time HIGH (correction: 584390 days = 504912960000000000)

%macro		FILETIMETOABS 2
		add	%1,774A8000h	; correction LOW
		adc	%2,701CFA9h	; correction HIGH
%endmacro
