; =============================================================================
;
;                              Litos - Buffer array
;
; =============================================================================

; ------------- Buffer array head

struc		BUFHEAD

		resb	LIST_size	; 0: list of free buffer entries
BUFH_Lock:	resb	SPINLOCK_size	; 8: lock of buffer array
BUFH_EntrySize:	resd	1		; 0Ch: size of buffer entry (min. 8)
BUFH_BlockSize:	resd	1		; 10h: size of block (power of 2)
BUFH_BlockMask:	resd	1		; 14h: block mask (to get block head)
BUFH_Entries:	resd	1		; 18h: number of entries per block
BUFH_Reserve:	resd	1		; 1Ch: reserved block (NULL=none)

endstruc				; size 20h = 32 bytes

; ------------- Buffer block

struc		BUFBLOCK

BUFB_Used:	resd	1		; 0: counter of used buffers
		resd	1		; 4: ...padding
BUFB_Data:				; 8: first buffer entry

endstruc				; size of head: 8 bytes

; ------------- Macro - initialized buffer array head
; %1 = size of one buffer entry, %2 = size of buffer block (must be power of 2)

%macro		BUFFER	2

		LISTHEAD		; list of free buffer entries
		SPINLOCK		; lock of buffer array
		dd	%1		; size of one buffer entry (min. 8)
		dd	%2		; size of buffer block (power of 2)
		dd	~(%2-1)		; block mask (to get block head)
		dd	(%2-BUFBLOCK_size)/%1 ; number of entries per block
		dd	NULL		; reserved block (NULL=none)
%endmacro
