; =============================================================================
;
;                               Litos - Swap cache
;
; =============================================================================

; ------------- Swap header (Linux compatible)
; Bad pages can be used for pages which overlaps boundaries of file clusters.

SWAPUUID_SIZE	EQU	16		; UUID size
SWAPVOL_SIZE	EQU	16		; volume size
SWAPBADPAGES	EQU	637		; max. number of bad pages
SWAPMAGIC_SIZE	EQU	10		; size of magic

struc		SWAPHEAD

		resb	400h		; reserved for boot loader (disk label)
SWH_Version:	resd	1		; 400h: version (only ver. 1 supported)
SWH_MaxPages:	resd	1		; 404h: total number of page slots
SWH_BadPageNum:	resd	1		; 408h: number of bad pages
SWH_UUID:	resb	SWAPUUID_SIZE	; 40Ch: UUID
SWH_Volume:	resb	SWAPVOL_SIZE	; 41Ch: volume
		resd	117		; 42Ch: ...padding
SWH_BadPages:	resd	SWAPBADPAGES	; 600h: bad pages
		resb	2		; 0FF4h: ...padding
SWH_Magic:	resb	SWAPMAGIC_SIZE	; 0FF6h: magic SWAP_SPACE or SWAPSPACE2

endstruc				; size 4 KB

; "SWAP-SPACE" magic means version 1 format, only SWH_Magic entry is valid.
; "SWAPSPACE2" magic means version 2 format, all entries are valid.

; ------------- Swap area descriptor
; List of pages = array of addresses of pages.

struc		SWAPAREA

		resb	LIST_size	; 0: list of areas
					;	- SwapAreaList
					;	- SwapAreaUnList
SWA_Flags:	resb	1		; 8: flags (see below)
SWA_Index:	resb	1		; 9: area index
SWA_Priority:	resw	1		; 0Ah: priority (signed number,0=norm.)
SWA_Map:	resd	1		; 0Ch: pointer to swap page slot map
SWA_ClustNum:	resd	1		; 10h: number of clusters
SWA_LastClust:	resd	1		; 14h: last searched cluster index
SWA_NextPage:	resd	1		; 18h: next page index to search
SWA_TotalPages:	resd	1		; 1Ch: number of total page slots
SWA_FreePages:	resd	1		; 20h: number of free page slots
SWA_FileHandle:	resd	1		; 24h: swap device handle
		align	8, resb 1
endstruc				; size 28h = 40 bytes

; ------------- Swap area flags

SWA_WRITE_BIT	EQU	0		; write is enabled
SWA_WRITE	EQU	1 << SWA_WRITE_BIT ; write is enabled

; ------------- Swap entry
; Swap entry is used in page entry (PTE) to point to swap page slot.
; Bit 0 (PE_PRESENT), bit 6 (PE_FILE) and bit 7 (PE_NOPROT) must be clear.
; Page slot 0 is not used (it is used for swap info header).

SWE_AREA_SHIFT	EQU	1		; shifts of swap area index
SWE_AREA_MUL	EQU	1<<SWE_AREA_SHIFT ; multiple of swap area index
SWE_AREA_MASK	EQU	B1+B2+B3+B4+B5	; mask swap area index
SWE_SLOT_SHIFT	EQU	8		; shifts of page slot index
SWE_SLOT_MASK	EQU	0ffffff00h	; page slot index mask
SWE_SLOT_MAX	EQU	(SWE_SLOT_MASK >> SWE_SLOT_SHIFT)+1 ; max. page slots
SWE_SLOT_BITS	EQU	24		; number of bits per page slot index

SWAPAREAS	EQU	(SWE_AREA_MASK>>SWE_AREA_SHIFT)+1; number of swap areas

; ------------- Swap page slot map
; Swap page slot map is used as array of SWAPMAP structures. Each structure
; describes one swap cluster. Each cluster contains 2048 (4096) dword pointers
; to one PTE or to array of PTE pointers (0=slot is free, 1=bad). One cluster
; describes 8 (16) MB of swap file, therefore swap file should be multiple
; of 8 (16) MB. Maximal memory block size is 64 (32) KB and thus swap file can
; have 64 GB max. It corresponds to maximal slot index in swap entry (16 M 
; pages).

; Slot pointer uses bit 31 as flag:
;  B31: 1=used as pointer to array of pointers to PTE, last entry is NULL
;	0=contains one PTE pointer (offset in system memory) or special flag

struc		SWAPMAP

SWM_Cluster:	resd	1		; 0: pointer to swap cluster table
SWM_Free:	resd	1		; 4: number of free slots in cluster

endstruc				; size 8 bytes (partially hardcoded)

SWAPMAP_SIZEBIT	EQU	3		; SWAMPAM_size in bits

SWM_CLUST_SHIFT	EQU	SWE_SLOT_BITS-MAXMEMBITS+SWAPMAP_SIZEBIT ; cluster
SWM_CLUST_NUM	EQU	1<<SWM_CLUST_SHIFT ; number of slots in swap cluster
SWM_CLUST_MASK	EQU	SWM_CLUST_NUM-1	; mask slot index in cluster
SWM_CLUST_SIZE	EQU	SWM_CLUST_NUM*4	; size of swap cluster array (4096 B)

SWAPMAP_FREE	EQU	0		; page slot is free (hardcoded)
SWAPMAP_BAD	EQU	1		; reserved (bad) page slot (hardcoded)
