; =============================================================================
;
;                                Litos - Signals
;
; =============================================================================

SIG_TOTAL	EQU	64		; total number of signals

; ------------- Signal info (partialy hardcoded, must be DWORD aligned)

struc		SIGINFO

SI_SignalDW:				; signal byte parameters as DWORD
SI_Signal:	resb	1		; 0: signal number (see below)
SI_Reason:	resb	1		; 1: signal reason (see below)
SI_Error:	resb	1		; 2: error code (see below, 0=no error)
SI_Type:	resb	1		; 3: signal format type (see below)

SI_Sender:	resd	1		; 4: sender (task address)

SI_TrapAddr:				; trap: instruction address
SI_TimerID:				; timer: timer identifier
SI_PollFile:				; poll: file descriptor
SI_RTValue:				; real-time signal: signal value
SI_Param1:	resd	1		; 8: first parameter

SI_TrapNum:				; trap: trap number
SI_TimerOver:				; timer: overrun count
SI_Param2:	resd	1		; 0Ch: second parameter

SI_TrapErr:				; trap: trap error code
SI_Param3:	resd	1		; 10h: third parameter

SI_Param4:	resd	1		; 14: fourth parameter

endstruc				; size 18h = 24 bytes

; ------------- Signal reason

;SIR_USER	EQU	0		; sent by kill(), sigsend(), raise()
;SIR_KERNEL	EQU	1		; sent by kernel, software (1 to 127)
SIR_TRAP	EQU	256-1		; sent by trap
;SIR_QUEUE	EQU	256-2		; sent by sigqueue()
;SIR_TIMER	EQU	256-3		; sent by timer
;SIR_MESG	EQU	256-4		; sent by message queue
;SIR_ASYNC	EQU	256-5		; sent by AIO completed
;SIR_SIGIO	EQU	256-6		; sent by queued SIGIO
;SIR_TKILL	EQU	256-7		; sent by tkill() or tgkill()
;SIR_DETHREAD	EQU	256-8		; sent by execve()

; ------------- Signal format type

;SIT_GENERAL	EQU	0		; undefined
SIT_TRAP	EQU	1		; trap
;SIT_KILL	EQU	2		; kill
;SIT_TIMER	EQU	3		; timer
;SIT_POLL	EQU	4		; poll
;SIT_CHLD	EQU	5		; child
;SIT_RT		EQU	6		; real-time signal
;SIT_MESQ	EQU	7		; message queue

; ------------- SIGILL error codes

ILL_CODE	EQU	1		; illegal opcode
;ILL_OPER	EQU	2		; illegal operand
;ILL_ADDR	EQU	3		; illegal addressing mode
;ILL_TRAP	EQU	4		; illegal trap
;ILL_PCODE	EQU	5		; privileged opcode
;ILL_PREG	EQU	6		; privileged register
;ILL_FPU	EQU	7		; coprcessor error
;ILL_STACK	EQU	8		; internal stack error

;ILL_MAX		EQU	8		; last SIGILL error code

; ------------- SIGTRAP error codes

TRAP_BREAK	EQU	1		; process breakpoint
TRAP_TRACE	EQU	2		; process trace trap

;TRAP_MAX	EQU	2		; last SIGTRAP error code

; ------------- SIGFPE error codes

FPE_NO		EQU	1		; no math coprocessor or emulator
FPE_IDIV	EQU	2		; integer divide by zero
FPE_SEGM	EQU	3		; coprocessor segment overrun
;FPE_IOVF	EQU	4		; integer overflow
;FPE_FDIV	EQU	5		; floating point divide by zero
;FPE_FOVF	EQU	6		; floating point overflow
;FPE_FUND	EQU	7		; floating point underflow
;FPE_FRES	EQU	8		; floating point inexact result
;FPE_FOPER	EQU	9		; floating point invalid operand
;FPE_FSUB	EQU	10		; subscript out of range

;FPE_MAX		EQU	10		; last SIGFPE error code

; ------------- SIGSEGV error codes

SEGV_OVER	EQU	1		; overflow (INTO instruction)
SEGV_BOUND	EQU	2		; bound range exceeded (BOUND instr.)
SEGV_TSS	EQU	3		; invalid TSS
SEGV_IRET	EQU	4		; IRET exception error
;SEGV_MAPERR	EQU	5		; address not mapped
;SEGV_ACCESS	EQU	6		; invalid access rights

;SEGV_MAX	EQU	6		; last SIGSEGV error code

; ------------- SIGBUS error codes

BUS_SEGM	EQU	1		; segment not present
BUS_STACK	EQU	2		; stack segment fault
BUS_ALIGN	EQU	3		; invalid address alignment
;BUS_EXIST	EQU	4		; non-exist physical address
;BUS_HARDW	EQU	5		; hardware error

;BUS_MAX		EQU	5		; last SIGBUS error code

; ------------- SIGCHLD error codes

;CHLD_EXIT	EQU	1		; child has exited
;CHLD_KILL	EQU	2		; child was killed
;CHLD_DUMP	EQU	3		; child terminated abnormally
;CHLD_TRAP	EQU	4		; traced child has trapped
;CHLD_STOP	EQU	5		; child has stopped
;CHLD_CONT	EQU	6		; child has continued

;CHLD_MAX	EQU	6		; last SIGCHLD error code

; ------------- SIGPOLL error codes

;POLL_IN	EQU	1		; data input available
;POLL_OUT	EQU	2		; output buffer available
;POLL_MSG	EQU	3		; input message available
;POLL_ERR	EQU	4		; I/O error
;POLL_HIGH	EQU	5		; high priority input available
;POLL_HUP	EQU	6		; device disconnected (hang up)

;POLL_MAX	EQU	6		; last SIGPOLL error code

; ------------- Signal queue item

struc		SIGNAL

		resb	LIST_size	; 0: list of signals
SIGNAL_Info:	resb	SIGINFO_size	; 8: signal info
 
endstruc                                ; size 20h = 32 bytes

; ------------- Signal action (size hardcoded in SignalSetAction,SignalTestIgn)

struc		SIGACT

SA_Handler:	resd	1		; 0: signal handler (see below)
					;  input parameter without SIGINFO:
					;	- signal number
					;  input parameters with SIGINFO:
					;	- signal number
					;	- pointer to SIGINFO
					;	- user data
SA_Flags:	resd	1		; 4: flags (see below)
SA_Mask:	resd	2		; 8: signal action mask

endstruc				; size 10h = 16 bytes

; ------------- Special signal handler (hardcoded in DoSignal)

SA_ERR		EQU	-1		; error return from signal
SA_DEF		EQU	0		; default signal handling (hardcoded)
SA_IGN		EQU	1		; ignore signal (hardcoded)
SA_TERM		EQU	2		; terminate the process
SA_DUMP		EQU	3		; terminate the process and dump core
SA_STOP		EQU	4		; stop the task
SA_PAR		EQU	5		; use parent's signal action handler

; ------------- Signal action flags

SA_NOCHILD	EQU	B0		; don't generate SIGCHLD when stop
SA_NOWAIT	EQU	B1		; don't create zombies when stop
SA_SIGINFO	EQU	B2		; use handler with SIGINFO
SA_RESTART	EQU	B28		; get restarting signals
SA_NOBLOCK	EQU	B30		; don't block signal in the handler
SA_RESET	EQU	B31		; reset handler to default after event

; ------------- Shared table of signal actions
; Table contains signals 1 to 63, signal 0 is not used.
; Offset of signal action in the table can be computed as "signal_number * 16".

struc		SIGTAB

		resb	SPINLOCK_size	; 0: table lock
ST_Ref:		resd	1		; 4: reference counter of table
		resd	2		; 8: ...padding
ST_Action:	resb	SIGACT_size * (SIG_TOTAL-1) ; 10h: table of signals

endstruc				; size 400h = 1024 bytes

; ------------- Signal numbers

SIGNULL		EQU	0		; unused signal (invalid, reserved)
; TODO: should we use this signal as SIGCONT? (it need not to store into queue)

SIGHUP		EQU	1		; hang up controlling terminal
					; (serial line was dropped, lost DCD)
					; new usage: re-read configuration
					; default action: terminate
SIGINT		EQU	2		; interrupt from keyboard (Ctrl+C)
					; default action: terminate
SIGQUIT		EQU	3		; quit from keyboard (Ctrl+\, SysRq)
                                        ; default action: terminate + dump
SIGILL		EQU	4		; illegal instruction
                                        ; default action: terminate + dump
SIGTRAP		EQU	5		; trace/breakpoint trap (debugging)
                                        ; default action: terminate + dump
SIGABRT		EQU	6		; abort, abnormal termination
                                        ; default action: terminate + dump
SIGIOT		EQU	SIGABRT
SIGBUS		EQU	7		; bus error
                                        ; default action: terminate + dump
SIGFPE		EQU	8		; floating-point exception
                                        ; default action: terminate + dump
SIGKILL         EQU     9               ; kill, forced-process termination
					; (cannot be caught or ignored)
					; default action: terminate
SIGUSR1		EQU	10		; user defined signal 1
					; default action: terminate
SIGSEGV		EQU	11		; invalid memory reference
                                        ; default action: terminate + dump
SIGUSR2		EQU	12		; user defined signal 2
					; default action: terminate
SIGPIPE		EQU	13		; write to pipe with no readers
					; default action: terminate
SIGALRM		EQU	14		; real timer expired (uses real time)
					; default action: terminate
SIGTERM		EQU	15		; request process termination
					; (unlike SIGKILL it can be ignored)
					; default action: terminate
SIGSTKFLT	EQU	16		; coprocessor stack error
					; default action: terminate
SIGCHLD		EQU     17		; child process stopped or terminated
					; (if ignored it creates zombie
					; waiting for "wait" system call)
					; default action: ignore
SIGCLD		EQU     SIGCHLD
SIGCONT		EQU	18		; resume execution, if stopped
					; (cannot be caught or ignored),
                                        ; default action: continue
SIGSTOP		EQU	19		; pause process execution
					; (cannot be caught or ignored),
					; default action: stop
SIGTSTP		EQU	20		; suspend request from tty (Ctrl+Z)
					; default action: stop
SIGTTIN		EQU	21		; tty input for background process
					; default action: stop
SIGTTOU		EQU	22		; tty output for background process
					; default action: stop
SIGURG		EQU	23		; urgent condition on socket
					; default action: ignore
SIGXCPU		EQU	24		; CPU time limit exceeded
                                        ; default action: terminate + dump
SIGXFSZ		EQU	25		; file size limit exceeded
                                        ; default action: terminate + dump
SIGVTALRM	EQU	26		; virtual timer expired (computes
					; only time spent in process)
					; default action: terminate
SIGPROF		EQU	27		; profiling timer expired (computes
					; time spent in process and system)
					; default action: terminate
SIGWINCH	EQU	28		; window (or terminal) resizing
					; default action: ignore
SIGIO		EQU	29		; input or output becomes possible
SIGPOLL		EQU	SIGIO		; Pollable event
					; default action: terminate
SIGPWR		EQU	30		; power supply failure
					; default action: terminate
SIGSYS		EQU	31		; bad system call (bad argument)
                                        ; default action: terminate + dump
SIGUNUSED	EQU	31		; unused signal

; ------------- Signal context

struc		SIGCONTEXT

SC_EIP:		resd	1		; 0: EIP register
SC_CS:		resw	2		; 4: CS register
SC_Flags:	resd	1		; 8: Flags
SC_Trap:	resd	1		; 0Ch: trap number
SC_ESP:		resd	1		; 10h: ESP register
SC_SS:		resw	2		; 14h: SS register
SC_CR2:		resd	1		; 18h: CR2 register
SC_Error:	resd	1		; 1Ch: error code
SC_SEG:		resb	SEGSTACK_size	; 20h: segments in stack
SC_REG:		resb	REGSTACK_size	; 30h: registers in stack
SC_Mask:	resd	2		; 50h: old signal mask
		resd	2		; 58h: ...reserved
SIGC_FPU:	resb	FPUSTATE_size	; 60h: FPU state

endstruc				; size 0D0h = 208 bytes

; ------------- Signal frame

struc		SIGFRAME

SF_Return:	resd	1		; 0: pointer to return code SF_RetCode
SF_Signal:	resd	1		; 4: signal number
SF_Context:	resb	SIGCONTEXT_size	; 8: signal context
SF_RetCode:	resb	8		; 0D8h: return code

endstruc				; size 0E0h = 224 bytes
