; =============================================================================
;
;                              Litos - User
;
; =============================================================================

; ------------- User

struc		USER

		resb	LIST_size	; 0: list of users
USER_Hash:	resb	HASHE_size	; 8: hash list of users
USER_ProcList:	resb	LIST_size	; 10h: header of user's process list
USER_Flags:	resd	1		; 18h: flags (see below)
USER_ID:	resd	1		; 1Ch: user's ID
USER_National:	resd	1		; 20h: pointer to NATIONAL

endstruc				; size 24h = 36 bytes

; ------------- User flags

USER_ADMIN	EQU	B0		; user has admin rights

ROOTUSER_ID	EQU	0		; ID of root user

; ------------- Macro - Initialized user structure
; %1 = link to next user, %2 = link to previous user, %3 = flags,
; %4 = user's ID, %5 = pointer to default nationality descriptor

%macro		USERINI	5

		LINKEDLIST %1,%2	; list of users
		LISTHEAD		; hash list of users
		LISTHEAD		; header of user's process list
		dd	%3		; flags
		dd	%4		; user's ID
		dd	%5		; default nationality descriptor
%endmacro

; ------------- Hash list of users

USERHASH_BITS	EQU	8		; number of bits of hash key
USERHASH_NUM	EQU	1 << USERHASH_BITS ; number of hash entries
USERHASH_MASK	EQU	USERHASH_NUM-1	; mask of hash key

; ------------- Macro - get current user (%1 = register)

%macro		CURRENT_USER 1

		CURRENT_PROC %1		; get current process
		mov	%1,[%1+PROC_User] ; get current user
%endmacro
