; =============================================================================
;
;                             Litos - Task lock
;
; =============================================================================

; ------------- Task lock

struc		TASKLOCK

		resb	LIST_size	; 0: task list
TLOCK_Lock:	resb	SPINLOCK_size	; 8: lock of task list

endstruc				; size 0Ch = 12 bytes

; ------------- Task lock with lockable data

struc		TASKLOCKD

		resb	TASKLOCK_size	; task lock
TLOCK_Data:	resd	1		; 0Ch: pointer to lockable data

endstruc				; size 10h = 16 bytes

; ------------- Task lock with integer variable
; Notes: Only lower part of TLOCK_Ref and TLOCK_Set need to be initialized
; with variables of lower operand size.

struc		TASKLOCKV

		resb	TASKLOCKD_size	; task lock with lockable data
TLOCK_Ref:	resd	2		; 10h: reference value to compare
TLOCK_Set:	resd	2		; 18h: value to set

endstruc				; size 20h = 32 bytes

; ------------- Callback function flags for integer variable
; Notes: Floating point variable is not supported - it could raise exception.

TLOCK_BYTE	EQU	0		; operand size - byte
TLOCK_WORD	EQU	1		; operand size - word
TLOCK_DWORD	EQU	2		; operand size - double word
TLOCK_QWORD	EQU	3		; operand size - quadruple word

TLOCK_SIGNED	EQU	0 << 2		; operand signification - signed
TLOCK_UNSIGNED	EQU	1 << 2		; operand signification - unsigned

TLOCK_NOP	EQU	0 << 3		; operation - do nothing
TLOCK_SET	EQU	1 << 3		; operation - set value
TLOCK_INC	EQU	2 << 3		; operation - increment
TLOCK_DEC	EQU	3 << 3		; operation - decrement

TLOCK_FALSE	EQU	0 << 5		; test - not suitable
TLOCK_TRUE	EQU	1 << 5		; test - suitable
TLOCK_EQ	EQU	2 << 5		; test - equal "="
TLOCK_NEQ	EQU	3 << 5		; test - not-equal "!="
TLOCK_LT	EQU	4 << 5		; test - less than "<"
TLOCK_LE	EQU	5 << 5		; test - less or equal "<="
TLOCK_GT	EQU	6 << 5		; test - greater than ">"
TLOCK_GE	EQU	7 << 5		; test - greater or equal ">="

; ------------- Callback function flags for bit variable

TLOCK_BIT0	EQU	0		; bit number 0
TLOCK_BIT1	EQU	1		; bit number 1
TLOCK_BIT2	EQU	2		; bit number 2
TLOCK_BIT3	EQU	3		; bit number 3
TLOCK_BIT4	EQU	4		; bit number 4
TLOCK_BIT5	EQU	5		; bit number 5
TLOCK_BIT6	EQU	6		; bit number 6
TLOCK_BIT7	EQU	7		; bit number 7

TLOCK_BITNOP	EQU	0 << 3		; bit operation - do nothing
TLOCK_BITSET	EQU	1 << 3		; bit operation - set bit
TLOCK_BITRES	EQU	2 << 3		; bit operation - reset bit
TLOCK_BITCOM	EQU	3 << 3		; bit operation - complement bit

TLOCK_BITFALSE	EQU	0 << 5		; bit test - not suitable
TLOCK_BITTRUE	EQU	1 << 5		; bit test - suitable
TLOCK_BITWASSET	EQU	2 << 5		; bit test - bit was set
TLOCK_BITWASRES	EQU	3 << 5		; bit test - bit was reset

TLOCK_BITEXT	EQU	B7		; ...reserved
