; =============================================================================
;
;                               Litos - Task (thread)
;
; =============================================================================
; TODO: Support FXSAVE/FXRSTOR save state

%ifdef MINI
IOBITMAP_MAX	EQU	400h		; max I/O address space (1 KB)
%else
IOBITMAP_MAX	EQU	10000h		; max I/O address space (64 KB)
%endif
IOBITMAP_SIZE	EQU	IOBITMAP_MAX/8	; size of I/O bit map (8 KB or 128 B)

%ifdef MINI
TASK_SIZE	EQU	1000h		; task-state segment size (4 KB)
TASK_SHIFT	EQU	14		; number of bits of task-state segment
%else
TASK_SIZE	EQU	4000h		; task-state segment size (16 KB)
TASK_SHIFT	EQU	14		; number of bits of task-state segment
%endif

TASK_MASK	EQU	~(TASK_SIZE-1)	; mask of task address

; If TASK_MAX > 252 than 2-byte swap page counter will be used, else 1-byte.
; (255=bad page, 254=permanent page, 253=reserve for swap cache, 252=max. val.)

%ifdef MINI
TASK_MAX	EQU	250		; maximal number of tasks
TASK_ADMIN	EQU	20		; number of tasks reserved for admin
%else
TASK_MAX	EQU	4090		; maximal number of tasks
					; (don't increase it above 4090,
					; it is limit due to GDT table size)
TASK_ADMIN	EQU	50		; number of tasks reserved for admin
%endif

; ------------- Macro - reschedule run-queue (%1 = run-queue)

%macro		RESCHEDULE 1
		and	dword [%1+RUNQ_NextSched],byte 0 ; schedule request
%endmacro

; ------------- Resource limits

RL_STACKMAX	EQU	1000000h	; default maximal size of stack (16 MB)
RL_VMREGMAX	EQU	2048		; default maximal number of regions
RL_PAGESMAX	EQU	10000		; default max. number of pages (40 MB)

struc		RESLIM

RL_StackSize:	resd	1		; maximal size of stack
RL_VirtMemReg:	resd	1		; maximal regions of virtual memory
RL_PagesUsed:	resd	1		; maximal number of physical pages

endstruc

; ------------- Task

struc		TASK
;		resb	OBJECT_size	; 0: task object head

				; === hardware hardcoded part (TSS, size 208Ch)
		alignb	4,resb 1
TASK_TSS:
TASK_Back:	resw	1		; +0: back link (selector of prev.task)
		resw	1
TASK_ESP0:	resd	1		; +4: ESP of privilege level 0
TASK_SS0:	resw	1		; +8: SS of privilege level 0
		resw	1
TASK_ESP1:	resd	1		; +0Ch: ESP of privilege level 1
TASK_SS1:	resw	1		; +10h: SS of privilege level 1
		resw	1
TASK_ESP2:	resd	1		; +14h: ESP of privilege level 2
TASK_SS2:	resw	1		; +18h: SS of privilege level 2
		resw	1
TASK_CR3:	resd	1		; +1Ch: CR3 (PDE base physical address)
TASK_EIP:	resd	1		; +20h: EIP
TASK_EFlags:	resd	1		; +24h: EFLAGS
TASK_EAX:	resd	1		; +28h: EAX
TASK_ECX:	resd	1		; +2Ch: ECX
TASK_EDX:	resd	1		; +30h: EDX
TASK_EBX:	resd	1		; +34h: EBX
TASK_ESP:	resd	1		; +38h: ESP
TASK_EBP:	resd	1		; +3Ch: EBP
TASK_ESI:	resd	1		; +40h: ESI
TASK_EDI:	resd	1		; +44h: EDI
TASK_ES:	resw	1		; +48h: ES
		resw	1
TASK_CS:	resw	1		; +4Ch: CS
		resw	1
TASK_SS:	resw	1		; +50h: SS
		resw	1
TASK_DS:	resw	1		; +54h: DS
		resw	1
TASK_FS:	resw	1		; +58h: FS
		resw	1
TASK_GS:	resw	1		; +5Ch: GS
		resw	1
TASK_LDT:	resw	1		; +60: LDT segment selector
		resw	1
TASK_Trace:	resb	1		; +64h: Debug trace flag (see below)
		resb	1
TASK_IOBase:	resw	1		; +66h: offset of I/O permiss. bit map
TASK_Redirect:	resb	32		; +68h: sw interrupt redirect. bit map
					;	0=interrupt redirected back
					;	1=interrupt handled protected
TASK_IOBitmap:	resb	IOBITMAP_SIZE	; +88h: I/O permission bit map
					;	0=access to port is allowed
					;	1=access denied, #GP signaled
TASK_IOTerm:	resd	1		; +2088h: I/O bit map terminator (= -1)
				; === hardware hardcoded part (FPU, size 70h)
; TODO: Buffer 512 bytes for FXSAVE/FXRSTOR instructions
		alignb	4,resb 1
TASK_FPU:
TASK_CWD:	resd	1		; +0: FPU register CWD
TASK_SWD:	resd	1		; +4: FPU register SWD
TASK_TWD:	resd	1		; +8: FPU register TWD
TASK_FIP:	resd	1		; +0Ch: FPU register FIP
TASK_FCS:	resd	1		; +10h: FPU register FCS
TASK_FOO:	resd	1		; +14h: FPU register FOO
TASK_FOS:	resd	1		; +18h: FPU register FOS
TASK_FPUData:	resb	8*10		; +1Ch: FPU data registers
TASK_FPUStatus:	resd	1		; +6Ch: FPU software status
				; === variable part
		alignb	4,resb 1
TASK_TR:	resd	1		; task register (to switch task)
TASK_TSSIndex:	resd	1		; TSS index
TASK_Link:	resb	TREE_size	; tree link to other tasks
TASK_State:	resb	1		; current task state (see below)
TASK_Type:	resb	1		; task type (see below)
TASK_CPU:	resb	1		; index of current/last CPU
TASK_Process:	resd	1		; pointer to parent process
TASK_ProcList:	resb	LIST_size	; list of tasks in process
TASK_Flags:	resd	1		; task flags (see below)

		alignb	4,resb 1
TASK_CPUMask:	resd	1		; mask of allowed CPUs
TASK_ExitCode:	resd	1		; exit code
		alignb	8,resb 1
TASK_Alarm:	resb	ALARM_size	; alarm to wake-up sleeping task
TASK_ConOutMask:resd	1		; mask of output consoles
TASK_ConInMask:	resd	1		; mask of input consoles
				; --- priority
TASK_AbsPrio:	resb	1		; absolute priority (0 to 31,see below)
TASK_RelPrio:	resb	1		; relative priority (-31 to +31)
TASK_AddPrio:	resb	1		; temporary increment priority (max.20)
TASK_MaxPrio:	resb	1		; maximal priority (0, 31 or 24)
TASK_Priority:	resb	1		; current priority
TASK_Focus:	resb	1		; bool flag, <> 0 task with user focus
				; --- statistik
		alignb	4,resb 1
TASK_StartTime:	resd	2		; time of task start
TASK_RunTime:	resd	2		; running time of task
				; --- run-queue
		alignb	4,resb 1
TASK_Queue:	resb	LIST_size	; link to task queue list
TASK_QueueLev:	resd	1		; current level in task/wait queue
TASK_RunQueue:	resd	1		; pointer to current/last run-queue
TASK_TaskQueue:	resd	1		; pointer to current task queue
TASK_Remaining:	resd	1		; remaining time quantum (in 100-ns)
;TASK_LockSem:	resd	1		; pointer to locked semaphore
;TASK_ValSem:	resd	1		; value for locked semaphore
TASK_TaskList:	resb	LIST_size	; task lock list entry
TASK_TaskLock:	resd	1		; pointer to TASKLOCK (NULL=none)
				; --- Signals (0..31:regular, 32..63:real-time)
		alignb	4,resb 1
TASK_SigMask:	resd	2		; signal mask (1=enabled)
TASK_Signal:	resd	2		; signals (1=ON)
TASK_SigLock:	resb	SPINLOCK_size	; signal queue list lock
TASK_SigQueue:	resb	LIST_size	; link to signal queue list
TASK_SigMax:	resd	1		; max. number of signals in queue
TASK_SigNum:	resd	1		; number of signals in signal queue
TASK_SigRTNum:	resb	32		; number of real-time signals
TASK_SigAction:	resd	1		; pointer to table of signal actions
TASK_SigRes:	resd	1		; reserve signal entry for SIGKILL
				; --- Traps
		alignb	4,resb 1
TASK_TrapNum:	resd	1		; last trap number
TASK_TrapErr:	resd	1		; last error code
				; --- Resource limits
		alignb	4, resb 1
TASK_ResLim:	resb	RESLIM_size	; current resource limits
;TASK_PagesUsed:	resd	1		; number of used physical pages

				; === stack
TASK_Stack0:	resb	TASK_SIZE-4-TASK_Stack0 ; stack (nearly 8 KB or 4 KB)
TASK_Stack:				; 4000h-4 or 1000h-4: end of stack
		resd	1		; reserve for disable reaching boundary
endstruc				; size 4000h = 16 KB (or 1000h = 4 KB)

; ------------- Debug trace flag

PTRACED		EQU	B0		; trace flag - task is traced

; ------------- Task state

TASK_RUNNING	EQU	0		; task is running
TASK_FALLASLEEP	EQU	1		; task is falling asleep
TASK_SLEEP	EQU	2		; task sleeps
TASK_WAKEUP	EQU	3		; task is waking-up
TASK_PAUSE	EQU	4		; task is paused
;TASK_LOCKED	EQU	6		; task is locked (semaphore)

;TASK_SWAPPING	EQU	5		; task is swapping
;TASK_DEAD	EQU	6		; task is dead

; ------------- Task type (TASK_Type)

TASK_IDLE	EQU	0		; idle task
TASK_INIT	EQU	1		; init system task
TASK_DAEMON	EQU	2		; system daemon
TASK_DEVICE	EQU	3		; device task
TASK_USER	EQU	4		; user task

; ------------- Task absolute priority (0 to 31)

PRIORITY_MAXDRV	EQU	31		; maximal priority - drivers
PRIORITY_MAXUSR	EQU	24		; maximal priority - user

PRIORITY_REAL	EQU	26		; real-time priority (only drivers)
PRIORITY_HIGH	EQU	20		; high priority
PRIORITY_NORMAL	EQU	14		; normal priority (middle priority)
PRIORITY_LOW	EQU	8		; low priority
PRIORITY_IDLE	EQU	2		; idle priority

PRIORITY_MIN	EQU	0		; minimal priority

; ------------- Task flags (TASK_Flags)

TASK_ISADMIN	EQU	B0		; user has admin rights

; ------------- Task queue

QUEUE_LISTS	EQU	32		; number of lists in task queue

struc		QUEUE

QUEUE_Total:	resd	1		; 0: total number of tasks in queue
QUEUE_Mask:	resd	1		; 4: mask of non-empty lists
QUEUE_List:	resb	LIST_size*QUEUE_LISTS ; 8: lists of TASKs

endstruc				; size 108h = 264 bytes

; ------------- Task run-queue (it is accessed only by 1 CPU, no lock required)
; Hash index = priority 0 to 31, time is in 100-nanosecs

struc		RUNQ

RUNQ_Current:	resd	1		; 0: pointer to current task queue
RUNQ_Expired:	resd	1		; 4: pointer to expired task queue
RUNQ_NextSched:	resd	1		; 8: 100-ns time to next scheduling
RUNQ_Elapsed:	resd	1		; 0Ch: elapsed 100-ns time
RUNQ_Total:	resd	1		; 10h: total number of running tasks
RUNQ_Idle:	resd	1		; 14h: idle task
RUNQ_Flags:	resd	1		; 18h: flags
					;	B0: 1=memory error signaled
					;	B1: 1=I/O error signaled
					;	B2: 1=watchdog signaled
					;	B3: 1=memory,I/O check disabled
					;	B4: 1=watchdog check disabled
RUNQ_CountMem:	resd	1		; 1Ch: 100-ns timer for mem.,I/O check
RUNQ_CountDog:	resd	1		; 20h: 100-ns timer for watchdog check
		resd	1		; 24h: padding

;RUNQ_RunTime:	resd	2		; 10h: running time accumulator
;RUNQ_IdleTime:	resd	2		; 18h: idle time accumulator
;RUNQ_Running:	resd	1		; 1Ch: pointer to running task

endstruc				; size 28h = 40 bytes

; ------------- Delays for new NMI checks (in seconds, max. 215)

NMI_DELAYMEM	EQU	15		; delay for new memory or I/O check
NMI_DELAYDOG	EQU	5		; delay for new watchdog check

; ------------- Macro - get current task (%1 = destination register)

%macro		CURRENT 1
		mov	%1,TASK_MASK	; prepare mask
		and	%1,esp		; get thread info
%endmacro

; ------------- Create task flags

TASKCREATE_ADMIN	EQU	B0	; allow admin reserve
