; =============================================================================
;
;                        Litos - Semaphore and mutex
;
; =============================================================================

; ------------- Semaphore

struc		SEM

		resb	TASKLOCK_size	; 0: task lock
SEM_Count:	resd	1		; 0Ch: lock counter, > 0 unlocked
SEM_Sleepers:	resd	1		; 10h: 1=some task is waiting (else 0)

endstruc				; size 14h = 20 bytes

; ------------- Mutex

struc		MUT

		resb	SEM_size	; 0: semaphore
SEM_Owner:	resd	1		; 14h: owner
SEM_Recursion:	resd	1		; 18h: recursion counter

endstruc				; size 1Ch = 28 bytes

; ------------- Semaphore counter value

SEM_UNLOCKED	EQU	1		; semaphore is unlocked (hardcoded)
SEM_LOCKED	EQU	0		; semaphore is locked (hardcoded)

; ------------- Macro - initialized semaphore (%1 = counter, usually 1)

%macro		SEMAPHORE 1

		TLOCK			; task lock
		dd	%1		; counter
		dd	0		; no sleepers
%endmacro

; ------------- Macro - initialized mutex

%macro		MUTEX	0

		SEMAPHORE SEM_UNLOCKED	; semaphore
		dd	0		; owner
		dd	0		; recursion counter
%endmacro

; ------------- Macro - initialize semaphore (%1=pointer, %2=counter)

%macro		SEM_Init 2

		TLOCK_Init %1		; initialize task lock
		mov	dword [%1+SEM_Count],%2 ; set counter
		and	dword [%1+SEM_Sleepers],byte 0 ; clear sleepers flag
%endmacro

; ------------- Macro - initialize mutex (%1=pointer)

%macro		MUTEX_Init 1

		push	eax		; push EAX
		xor	eax,eax		; EAX <- 0
		mov	[%1+SEM_Sleepers],eax ; clear sleepers flag
		mov	[%1+SEM_Owner],eax ; clear owner
		mov	[%1+SEM_Recursion],eax ; recursion counter
		inc	eax		; EAX <- 1
		mov	dword [%1+SEM_Count],eax ; set counter to 1
		TLOCK_Init %1		; initialize task lock
		pop	eax		; pop EAX
%endmacro
