; =============================================================================
;
;                               Litos - Process
;
; =============================================================================

; ------------- Process descriptor

struc		PROCESS

		resb	RBROOT_size	; 0: RB-tree root of memory regions
PROC_TaskNum:	resd	1		; 14h: number of tasks in process
PROC_TaskList:	resb	LIST_size	; 18h: list of tasks in process
PROC_ProcLink:	resb	TREE_size	; 20h: tree link to other processes
PROC_VMMutex:	resb	MUT_size	; 30h: virtual memory mutex-lock
PROC_VMLock:	resb	SPINLOCK_size	; 4Ch: virtual memory spin-lock
PROC_UserProc:	resb	LIST_size	; 50h: user's process list
PROC_PGDir:	resd	1		; 58h: global page directory (0=kernel)
PROC_VMCache:	resd	1		; 5Ch: cache, last used region (0=none)
PROC_Pages:	resd	1		; 60h: counter of allocated pages
PROC_HeapStart:	resd	1		; 64h: start address of the heap
PROC_HeapEnd:	resd	1		; 68h: address behind end of the heap
PROC_User:	resd	1		; 6Ch: pointer to current user USER
PROC_UserID:	resd	1		; 70h: current user's ID
PROC_Flags:	resd	1		; 74h: process flags (see below)

endstruc				; size 78h = 120 bytes

PROC_RegNum:	EQU	RBR_Count	; number of regions (Read-Only!)

; ------------- Process flags

PROC_ADMIN	EQU	USER_ADMIN	; user has admin rights (=B0)

; ------------- Macro - Initialized process descriptor
; %1 = pointer to current user

%macro		PROCESSINI 1

		RBTREE			; RB-tree root of memory regions
		dd	0		; number of tasks in process
		LISTHEAD		; list of tasks in process
		TREEHEAD		; tree link to other processes
		MUTEX			; virtual memory mutex-lock
		SPINLOCK		; virtual memory spin-lock
		LISTHEAD		; user's process list
		dd	NULL		; page global directory (NULL=kernel)
		dd	NULL		; cache, last used region (NULL=none)
		dd	0		; counter of allocated pages
		dd	NULL		; start address of the heap
		dd	NULL		; address behind end of the heap
		dd	%1		; pointer to current user
		dd	0		; current user's ID
		dd	0		; process flags
%endmacro

; ------------- Macro - get current process descriptor (%1 = register)

%macro		CURRENT_PROC 1

		CURRENT	%1		; get current task
		mov	%1,[%1+TASK_Process] ; get current process
%endmacro
