; =============================================================================
;
;                         Litos - Interrupt descriptor
;
; =============================================================================

; ------------- Interrupt Descriptor Table, IDT

struc		IDT

IDT_Offset:	resw	1		; 0: offset in segment (bits 0 to 15)
IDT_Selector:	resw	1		; 2: target segment selector
IDT_Count:	resb	1		; 4: DWORD count, must be 0
					;     for call gate:
					;	B0-B4 = number of parameters
					;		to copy from calling
					;		procedure stack to the
;					;		new stack
IDT_Flags:	resb	1		; 5: flags
					;	B0-B3: entry type
					;		5 = task gate
					;			(uses TSS)
					;		12 = call gate
					;		14 = 386 interrupt gate
					;			(uses GDT)
					;		15 = 386 trap gate
					;			(uses LDT)
					;	B4: 0 (must always be zero)
					;	B5-B6: descr. privilege level
					;		0 = exceptions and
					;		    hardware interrupts
					;		3 = software interrupts
					;	B7: 1=present in memory
					;	(if it is not set a Not Preset
					;	#NP exception is generated)
IDT_Offset2:	resw	1		; 6: offset in segment (bits 16 to 31)

endstruc				; size 8 bytes

; -----------------------------------------------------------------------------
; Task gate
;	Includes the TSS selector of the process that must replace the current
;	one when an interrupt signal occurs.
; Call gate
;	Call gates facilitate controlled transfers of program control between
;	different privilege levels. A call-gate descriptor may reside in the
;	GDT or LDT, but not in IDT. Call gate can be accessed using CALL or
;	JMP instruction with segment selector identifying the call gate (offset
;	will be ignored). CPU uses destination code segment and offset from
;	the call gate to determine procedure entry point.
; Interrupt gate
;	Includes the Segment Selector and the offset inside the segment of an
;	interrupt or exception handler. While transferring control to the
;	proper segment, the processor clears the IF flag, thus disabling
;	further maskable interrupts.
; Trap gate
;	Similar to an interrupt gate, except that while transferring control to
;	the proper segment, the processor does not modify the IF flag.
; -----------------------------------------------------------------------------

; Error code (for exception handler):
;	B0: EXT (External event), 1=external (hw) event caused the exception
;	B1: IDT (Descriptor location), 1=index refers to IDT, 0=GDT or LDT
;	B2: TI (GDT/LDT, only if IDT=0), 1=index refers to LDT, 0=..to GDT
;	B3-B15: segment selector index
;	B16-B31: reserved

