; =============================================================================
;
;                       Litos - Global/local descriptor
;
; =============================================================================

; ------------- Global/Local Descriptor Table, GLDT

struc		GLDT

GLDT_Limit:	resw	1		; 0: segment limit (bits 0 to 15)
GLDT_Base:	resw	1		; 2: base address (bits 0 to 15)
GLDT_Base2:	resb	1		; 4: base address (bits 16 to 23)
GLDT_Access:	resb	1		; 5: access rights
					;    if code/data type decriptor (B4):
					;	B0: 1=segment accessed 
					;	if code segment (B3=1):
					;	  B1: 1=read, 0=no read
					;	  B2: 1=code segment may only
					;		be executed when CPL
					;	       (current privileg level)
					;		>= DPL (descriptor
					;		privileg level) and CPL
					;		remains unchanged
					;	if data segment (B3=0):
					;	   B1: 1=read/write,0=read only
					;	   B2: 1=expand down, 0=exp. up
					;	B3: 1=code, 0=data segment
					;    if system/gate type descriptor:
					;	B0-B3: segment type
					;		0 = ...reserved
					;		1 = available 286 TSS
					;		2 = LDT
					;		3 = busy 286 TSS
					;		4 = 286 call gate
					;		5 = task gate
					;		6 = 286 interrupt gate
					;		7 = 286 trap gate
					;		8 = ...reserved
					;		9 = available 386 TSS
					;		10 = ...reserved
					;		11 = busy 386 TSS
					;		12 = 386 call gate
					;		13 = ...reserved
					;		14 = 386 interrupt gate
					;		15 = 386 trap gate
					;    B4: descriptor type
					;		1=code or data
					;		0=system or gate
					;    B5-B6: descriptor privilege level
					;		0 = kernel
					;		1 = services
					;		2 = drivers
					;		3 = applications
					;    B7: 1=segment is present in memory
GLDT_Flags:	resb	1		; 6: flags
					;    B0-B3: segment limit (bits 16-19)
					;    B4: available for use of system
					;    B5: 0 (must always be zero)
					;    B6: operand size 
					;	   1=32 bits (use ESP)
					;	   0=16 bits (use SP)
					;    B7: size granularity 1=4KB, 0=1B
GLDT_Base3:	resb	1		; 7: base address (bits 24 to 31)

endstruc				; size 8 bytes

; ------------- Global descriptor table - indexes

SYSTEM_GDT_CS	EQU	1		; index of system 4GB code descriptor
SYSTEM_GDT_DS	EQU	2		; index of system 4GB data descriptor
USER_GDT_CS	EQU	3		; index of user 4GB code desriptor
USER_GDT_DS	EQU	4		; index of user 4GB data desriptor
PNP_GDT_CS	EQU	5		; index of PNP 64K 32b code desriptor
PNP_GDT_CS16	EQU	6		; index of PNP 64K 16b code desriptor
PNP_GDT_DS16	EQU	7		; index of PNP 64K 16b data desriptor
APM_GDT_CS	EQU	8		; index of APM 64K 32b code desriptor
APM_GDT_CS16	EQU	9		; index of APM 64K 16b code desriptor
APM_GDT_DS	EQU	10		; index of APM 64K 32b data desriptor
TASK_GDT_LDT	EQU	11		; base index of task LTD (4090 or 250)
TASK_GDT_TSS	EQU	TASK_GDT_LDT+TASK_MAX ; base index of task TSS

BOOT_GDT_NUM	EQU	11		; number of GDTs in boot GDT table
SYSTEM_GDT_NUM	EQU	TASK_GDT_TSS+TASK_MAX ; number of GDTs (8191 or 511)

; ------------- Global descriptor table - selectors

SYSTEM_CS	EQU	SYSTEM_GDT_CS*8	; system 4GB code selector
SYSTEM_DS	EQU	SYSTEM_GDT_DS*8	; system 4GB data selector
USER_CS		EQU	USER_GDT_CS*8	; user 4GB code selector
USER_DS		EQU	USER_GDT_DS*8	; user 4GB data selector
PNP_CS		EQU	PNP_GDT_CS*8	; PNP 64K 32b code selector
PNP_CS16	EQU	PNP_GDT_CS16*8	; PNP 64K 16b code selector
PNP_DS16	EQU	PNP_GDT_DS16*8	; PNP 64K 16b data selector
APM_CS		EQU	APM_GDT_CS*8	; APM 64K 32b code selector
APM_CS16	EQU	APM_GDT_CS16*8	; APM 64K 16b code selector
APM_DS		EQU	APM_GDT_DS*8	; APM 64K 32b data selector
TASK_FIRST_LDT	EQU	TASK_GDT_LDT*8	; task LTD (Local Descriptor Table)
TASK_FIRST_TSS	EQU	TASK_GDT_TSS*8	; task TSS (Task State Segment)
