; =============================================================================
;
;                              Litos - File system
;
; =============================================================================

; Packed path:
; ------------
; (2 bytes) root path identifier (current folder, root folder, ...)
; (2 bytes) number of subfolders in path
;	(2 bytes) length of name of one subfolder
;	(x bytes) folder name (empty = "upper folder", go UP)
;
; - Global system path, only admin can change it
;	("System", "Library", "Boot", "Programs", shared applications, ...)
; - User system path, only admin can change it
;	("Home", "Setup", "Data", ...)
; - User local path, user can change it
;	("Current", user applications, ...)
; - Program temporary path, not shared with other applications,
;       not named path - can use program own ID numbers
;
; Create path:
; - Path = packet path
; - PathScope = who can see it (everyone, group, user, program)
; - ScopeName = name of group, user, program
; - PathChange = who can change it (admin, group, user, program)
; - Overwrite = overwrite existing path (if user has rights to it)

; RegisterSystemPath(path string), returns path type identifier
; RegisterUserPath(path string, user ID), returns path type identifier
; RegisterLocalPath(path string), returns path type identifier
; GetPath(path identifier), returns packed path
; SetPath(path identifier, packed path)

; ------------- File path (beware to not align entries)

struc		FILEPATH

FILEPATH_Root:	resw	1		; 0: root path identifier
FILEPATH_SubNum:resw	1		; 2: number of subfolders
FILEPATH_Path:				; 4: start of path
					;   (2) length of subfolder (0="UP")
					;   (x) text of subfolder
endstruc

; ------------- Predefined root paths

ROOT_DEF	EQU	0		; default root path

; ------------- File system function block

struc		FILESYSF

FS_Mount:	resd	1		; mount filesystem
					;	INPUT:	EBX = file system
FS_UnMount:	resd	1		; unmount filesystem
FS_GetInfo:	resd	1		; get filesystem information block
FS_GetStat:	resd	1		; get filesystem statistics
FS_SearchDir:	resd	1		; search in directory
FS_Rename:	resd	1		; rename file or directory
FS_Link:	resd	1		; link path
FS_UnLink:	resd	1		; unlink path
FS_SetOwner:	resd	1		; set owner
FS_SetAttrib:	resd	1		; set attributes
FS_Open:	resd	1		; open file
FS_Close:	resd	1		; close file
FS_Create:	resd	1		; create file or directors
FS_Delete:	resd	1		; delete file or directory
FS_Read:	resd	1		; read from file
FS_Write:	resd	1		; write to file
FS_GetSize:	resd	1		; get file size
FS_SetSize:	resd	1		; set file size
FS_FileMap:	resd	1		; map file to memory
FS_FileUnMap:	resd	1		; unmap file
FS_Flush:	resd	1		; flush file cache

endstruc


; ------------- File system descriptor

struc		FILESYS

		resb	LIST_size	; list of file system descriptors
FILESYS_Func:	resd	1		; pointer to function block FILESYSF
FILESYS_Device:	resd	1		; pointer to device driver
FILESYS_Block:	resd	1		; block size
FILESYS_BlockB:	resd	1		; block size in bits
FILESYS_Flags:	resd	1		; flags (see below)
FILESYS_MaxSize:resd	2		; maximum size of file
FILESYS_Type:	resd	1		; filesystem type
FILESYS_Lock:	resb	MUT_size	; filesystem descriptor mutex lock

endstruc

; ------------- File system flags

FILESYS_MODI	EQU	B0		; modified flag
