; =============================================================================
;
;                               Litos - File
;
; =============================================================================


; ------------- File function block

struc		FILEF


FILEF_ReOpen:	resd	1		; reopen file
					;	INPUT:	EBX = file system
					;		ECX = flags
					;		EDX = packed path
					;	OUTPUT:	EAX = identifier
					;		CY = error
FILEF_Close:	resd	1		; close file
					;	INPUT:	EBX = driver
					;	OUTPUT:	CY = error
FILEF_Read:	resd	1		; read from file
					;	INPUT:	EDX:EAX = offset
					;		EBX = file system
					;		ECX = number of bytes
					;		ESI = data buffer
					;	OUTPUT:	CY = error
FILEF_Write:	resd	1		; write to file
					;	INPUT:	EDX:EAX = offset
					;		EBX = file system
					;		ECX = number of bytes
					;		ESI = data buffer
					;	OUTPUT:	CY = error
FILEF_GetSize:	resd	1		; get file size
					;	INPUT:	EBX = file system
					;	OUTPUT:	EDX:EAX = file size
					;		CY = error
endstruc

; ------------- File descriptor

struc		FILE

		resb	LIST_size	; 0: file list in file node

FILE_FileNode:	resd	1		; pointer to file node

FILE_Offset:	resd	2		; current seek position
FILE_Func:	resd	1		; pointer to file function block
FILE_Flags:	resd	1		; flags (see below)
FILE_Owner:	resd	1		; file owner
FILE_UID:	resd	1		; file user ID
FILE_GID:	resd	1		; file group ID

FILE_Path:	resd	1		; pointer to filepath

endstruc

; ------------- File flags

FILE_READ:	EQU	B0		; can read from file
FILE_WRITE:	EQU	B1		; can write to file
FILE_SHAREREAD:	EQU	B2		; can reopen for read
FILE_SHAREWRITE:EQU	B3		; can reopen for write

; ------------- File node

struc		FILENODE

FN_Files:	resb	LIST_size	; list of files for this file node
FN_FileSys:	resd	1		; pointer to file system descriptor

endstruc

; ------------- Directory function block

struc		DIRF


endstruc

; ------------- Directory descriptor

struc		DIR

		resb	LIST_size	; cache list of used/unused directories
DIR_Hash:	resb	HASHE_size	; hash list
DIR_Ref:	resd	1		; reference counter
DIR_FileNode:	resd	1		; pointer to file node
DIR_List:	resb	TREE_size	; list of directories
DIR_Func:	resd	1		; pointer to directory function block

endstruc
