; =============================================================================
;
;                               Litos - Exceptions
;
; =============================================================================

; ------------- Get data from user space with default value
; %1=register, %2=address, %3=default value

%macro		GET	3
%%L1:		mov	%1,[%2]
%%L2:
		FIX_SECTION
%%L3:		mov	%1,%3
		jmp	%%L2

		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%%L3

		CODE_SECTION
%endmacro

; ------------- Get data from user space with error
; %1=register, %2=address, %3=error handler

%macro		GET_ERR	3
%%L1:		mov	%1,[%2]

		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%3

		CODE_SECTION
%endmacro

; ------------- Put data to user space with ignore
; %1=address, %2=register

%macro		PUT	2
%%L1:		mov	[%1],%2
%%L2:
		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%%L2

		CODE_SECTION
%endmacro

; ------------- Put data to user space with error
; %1=address, %2=register, %3=error handler

%macro		PUT_ERR	3
%%L1:		mov	[%1],%2

		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%3

		CODE_SECTION
%endmacro

; ------------- Copy DWORD data to/from user space (%1 = error address)
; EDI=destination address, ESI=source address, ECX=data size

%macro		COPYDW	1
%%L1:		rep	movsd

		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%1

		CODE_SECTION
%endmacro

; ------------- Copy BYTE data to/from user space (%1 = error address)
; EDI=destination address, ESI=source address, ECX=data size

%macro		COPYB	1
%%L1:		rep	movsb

		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%1

		CODE_SECTION
%endmacro

; ------------- Scan not equal BYTE data in user space (%1 = error address)
; EDI=data address, ECX=max. data size

%macro		SCANNEB	1
%%L1:		repne	scasb

		EXC_SECTION
		dd	%%L1

		EXC2_SECTION
		dd	%1

		CODE_SECTION
%endmacro
