; =============================================================================
;
;                             Litos - Error codes
;
; =============================================================================

; ------------- Error categories

ERR_CATBIT	EQU	5		; error category bit position
ERR_CATBITS	EQU	3		; error category bits
ERR_CATMASK	EQU	0e0h		; error category mask

ERR_GENERAL	EQU	0 << ERR_CATBIT	; general error (OK or unspecified)
ERR_SYNTAX	EQU	1 << ERR_CATBIT	; syntax error
ERR_MATH	EQU	2 << ERR_CATBIT	; mathematic
ERR_KERNEL	EQU	3 << ERR_CATBIT	; kernel
ERR_MEMORY	EQU	4 << ERR_CATBIT	; memory
ERR_TASK	EQU	5 << ERR_CATBIT	; task or process
ERR_FILE	EQU	6 << ERR_CATBIT	; file system
ERR_DEVICE	EQU	7 << ERR_CATBIT	; device

; ------------- General error

ERR_OK		EQU	ERR_GENERAL+0	; operation OK (hardcoded 0)
;ERR_NOMORE	EQU	ERR_GENERAL+1	; no more item

; ------------- Syntax error

;ERR_NOTIMPL	EQU	ERR_SYNTAX+1	; function not implemented
;ERR_INVCODE	EQU	ERR_SYNTAX+2	; invalid function code
;ERR_INVARG	EQU	ERR_SYNTAX+3	; invalid argument
;ERR_PERMIT	EQU	ERR_SYNTAX+4	; operation not permitted
;ERR_TOOLONG	EQU	ERR_SYNTAX+5	; argument list too long
;ERR_EXECFORM	EQU	ERR_SYNTAX+6	; exec format error
;ERR_ADDRESS	EQU	ERR_SYNTAX+7	; bad address

; ------------- DATETIME structure entries

ERR_DT_NSEC	EQU	ERR_SYNTAX+10	; invalid "nanosecond" entry
ERR_DT_SEC	EQU	ERR_SYNTAX+11	; invalid "second" entry
ERR_DT_MIN	EQU	ERR_SYNTAX+12	; invalid "minute" entry
ERR_DT_HOUR	EQU	ERR_SYNTAX+13	; invalid "hour" entry
ERR_DT_DAY	EQU	ERR_SYNTAX+14	; invalid "day in month" entry
ERR_DT_MONTH	EQU	ERR_SYNTAX+15	; invalid "month" entry
ERR_DT_YEAR	EQU	ERR_SYNTAX+16	; invalid "year" entry

; ------------- Mathematic

;ERR_MATHARG	EQU	ERR_MATH+1	; math argument out of domain of func
;ERR_RANGE	EQU	ERR_MATH+2	; math result not representable
;ERR_DIVIDE	EQU	ERR_MATH+3	; divide zero

; ------------- Kernel

;ERR_INTCALL	EQU	ERR_KERNEL+1	; interrupted system call

; ------------- Memory

;ERR_NOMEM	EQU	ERR_MEMORY+1	; out of memory
;ERR_QUEUEFULL	EQU	ERR_MEMORY+2	; queue full
;ERR_INVMEM	EQU	ERR_MEMORY+3	; invalid memory (VMA error)

; ------------- Task and process

;ERR_NOPROC	EQU	ERR_TASK+1	; no such process
;ERR_NOCHILD	EQU	ERR_TASK+2	; no child processes

; ------------- File system

;ERR_NOFILE	EQU	ERR_FILE+1	; no such file or directory
;ERR_BADFILE	EQU	ERR_FILE+2	; bad file number
;ERR_ACCESS	EQU	ERR_FILE+3	; permission denied
;ERR_EXIST	EQU	ERR_FILE+4	; file already exists
;ERR_NOTDIR	EQU	ERR_FILE+5	; not a directory
;ERR_ISDIR	EQU	ERR_FILE+6	; is a directory
;ERR_FTABOVER	EQU	ERR_FILE+7	; file table overflow
;ERR_TOOFILES	EQU	ERR_FILE+8	; too many open files
;ERR_NOTTY	EQU	ERR_FILE+9	; not a typewriter
;ERR_TXTBUSY	EQU	ERR_FILE+10	; text file busy
;ERR_FILEBIG	EQU	ERR_FILE+11	; file too large
;ERR_READONLY	EQU	ERR_FILE+12	; read-only file system
;ERR_TOOLINKS	EQU	ERR_FILE+13	; too many links
;ERR_PIPE	EQU	ERR_FILE+14	; broken pipe
;ERR_NAMELONG	EQU	ERR_FILE+15	; file name too long
;ERR_NOLOCK	EQU	ERR_FILE+16	; no record locks available
;ERR_NOTEMPTY	EQU	ERR_FILE+17	; directory not empty
;ERR_TOOSYMB	EQU	ERR_FILE+18	; too many symbolic links encountered
;ERR_WDBLOCK	EQU	ERR_FILE+19	; operation would block
;ERR_IDREM	EQU	ERR_FILE+20	; identifier removed
;ERR_LNKRANGE	EQU	ERR_FILE+21	; link number out of range
;ERR_NOANODE	EQU	ERR_FILE+22	; no anode

; ------------- Device

;ERR_IOERR	EQU	ERR_DEVICE+1	; I/O error
;ERR_NOXIO	EQU	ERR_DEVICE+2	; no such device or address
;ERR_AGAIN	EQU	ERR_DEVICE+3	; try again
;ERR_NOTBLK	EQU	ERR_DEVICE+4	; block device required
;ERR_BUSY	EQU	ERR_DEVICE+5	; device or resource busy
;ERR_XDEV	EQU	ERR_DEVICE+6	; cross-device link
;ERR_NODEV	EQU	ERR_DEVICE+7	; no such device
;ERR_NOSPACE	EQU	ERR_DEVICE+8	; no space left on device
;ERR_SEEK	EQU	ERR_DEVICE+9	; illegal seek
;ERR_NOTATT	EQU	ERR_DEVICE+10	; protocol driver not attached
;ERR_NOCSI	EQU	ERR_DEVICE+11	; no CSI structure available
;ERR_XCHANGE	EQU	ERR_DEVICE+12	; invalid exchange
;ERR_XFULL	EQU	ERR_DEVICE+13	; exchange full
