; =============================================================================
;
;                        Litos - VT102 terminal emulator
;
; =============================================================================

VT_TABS		EQU	256		; number of tab stops
VT_PARAMS	EQU	16		; maximal number of parameters

; ------------- VT100 terminal interface

struc		VTERM

VT_Disp:	resd	1		; 0: display driver DDPB
VT_WKeyData:	resd	1		; 4: private data for write function
VT_WKeyFnc:	resd	1		; 8: function to write key into keyb.
					;	INPUT:	EAX = key code
					;		EBX = private data
VT_Addr:	resd	1		; 0Ch: videomemory address
VT_Dim:		resb	DIMENSION_size	; 10h: display dimension
VT_Pos:		resb	POSITION_size	; 18h: cursor position
VT_ScanLine:	resd	1		; 20h: bytes per scan line
VT_Current:	resd	1		; 24h: current cursor address
VT_CharsetG0:	resd	1		; 28h: pointer to G0 charset CHARSET
VT_CharsetG1:	resd	1		; 2Ch: pointer to G1 charset CHARSET
VT_PushG0:	resd	1		; 30h: pointer to saved G0 charset
VT_PushG1:	resd	1		; 34h: pointer to saved G1 charset
VT_CharSet:	resd	1		; 38h: pointer to current charset
VT_Esc:		resd	1		; 3Ch: Escape service address
VT_Flags:	resb	1		; 40h: flags (see below)
VT_Flags2:	resb	1		; 41h: flags 2 (see below)
VT_Attrib:	resb	1		; 42h: attribute flags (see below)
VT_PushAttrib:	resb	1		; 43h: saved attribute flags
VT_Color:	resb	1		; 44h: current color (77h max)
VT_ColorAttr:	resb	1		; 45h: current color with attributes
VT_PushColor:	resb	1		; 46h: saved color
VT_DefColor:	resb	1		; 47h: default color
VT_UnderColor:	resb	1		; 48h: underline color (0 to 15)
VT_DarkColor:	resb	1		; 49h: dark color (0 to 15)
VT_ParNum:	resb	1		; 4Ah: number of parameters
VT_UtfNum:	resb	1		; 4Bh: UTF code character counter
VT_UtfChar:	resd	1		; 4Ch: UTF character accumulator
VT_ClearChar:	resd	1		; 50h: 2 clearing characters with color
VT_PushAddr:	resd	1		; 54h: saved cursor address
VT_EndAddr:	resd	1		; 58h: end address of display
		resd	1		; 5Ch: ...padding
VT_PushPos:	resb	POSITION_size	; 60h: saved cursor position
VT_ScrollT:	resd	1		; 68h: top line of scrolling region
VT_ScrollB:	resd	1		; 6Ch: bottom line of scroll. region+1
VT_Tabs:	resb	VT_TABS/8	; 70h: tab stops
VT_Palettes:	resb	16*3		; 90h: palettes (16 RGB colors 0..63)
VT_Param:	resd	VT_PARAMS	; C0h: parameters

endstruc				; size 100h = 256 bytes

VT_DimW		EQU	VT_Dim+DIM_W	; display width
VT_DimH		EQU	VT_Dim+DIM_H	; display height
VT_PosX		EQU	VT_Pos+POS_X	; cursor X
VT_PosY		EQU	VT_Pos+POS_Y	; cursor Y
VT_PushPosX	EQU	VT_PushPos+POS_X ; saved cursor X
VT_PushPosY	EQU	VT_PushPos+POS_Y ; saved cursor Y

; ------------- VT100 flags

VT_CURSON	EQU	B0		; cursor is ON
VT_UPDATE_BIT	EQU	1		; update cursor
VT_UPDATE	EQU	1<<VT_UPDATE_BIT
VT_NEEDWRAP	EQU	B2		; wrap request
VT_AUTOCR	EQU	B3		; auto CR after LF
VT_CTRL		EQU	B4		; display control characters
VT_ALTCHAR	EQU	B5		; use alternate character set
VT_USESCROLL	EQU	B6		; use scroll window
VT_ESCQUES	EQU	B7		; escape sequence "ESC [ ?"

VT_DEFFLAGS	EQU	VT_CURSON+VT_AUTOCR ; default flags

; ------------- VT100 flags 2

VT_MONO		EQU	B0		; use monochromatic mode
VT_512CHAR	EQU	B1		; use 512-character display
VT_HIGHBG	EQU	B2		; use high intensity background
VT_USEUTF	EQU	B3		; use UTF character code
VT_ANSI		EQU	B4		; ANSI.SYS compatible

VT_DEFFLAGS2	EQU	VT_ANSI ;VT_USEUTF+VT_512CHAR ; default flags 2

; ------------- Attribute flags

VT_INVIS	EQU	B0		; invisible
VT_UNDER	EQU	B1		; underline
VT_INVERSE	EQU	B2		; inverse
VT_DARK		EQU	B3		; dark
VT_INTENS	EQU	B4		; intensity
VT_BGINTENS	EQU	B5		; background intensity
VT_BLINK	EQU	B6		; blinking

VT_CHARG1_BIT	EQU	7		; use G1 charset (else G0)
VT_CHARG1	EQU	1<<VT_CHARG1_BIT

VT_DEFATTR	EQU	0		; default attribute flags
VT_ATTRMASK	EQU	B0+B1+B2+B3+B4+B5+B6 ; attribute mask
