; =============================================================================
;
;                Litos - Programmable interval timer Intel 8254
;
; =============================================================================
; Ports 40h-43h, clock 1193182 Hz
;
; 40h - counter 0, system timer
; 41h - counter 1, RAM refresh counter (don't use it!)
; 42h - counter 2, speaker
; 43h - control (after write whole action must be done, else system may hang)

TIMER_FREQ	EQU	1193182		; TIMER frequency 1193181.8181 Hz
					;  = 1/3 of the NTSC color subcarrier

TIMER_IRQ	EQU	0		; TIMER IRQ number

; ------------- TIMER device descriptor

struc		DEVTIMER

		resb	DEV_size	; general device

DEVTIM_SetMode:	resd	1		; initialize counter
					;	INPUT:	EAX=mode (see below)
					;		EBX=device descriptor
					;		ECX=counter init. value
					;		EDX=counter index (0-2)
					;	OUTPUT:	CY=invalid arguments

DEVTIM_SetVal:	resd	1		; set new counter initial value
					;	INPUT:	EBX=device descriptor
					;		ECX=new counter value
					;		EDX=counter index (0-2)
					;	OUTPUT:	CY=invalid index

DEVTIM_GetVal:	resd	1		; get counter current value
					;	INPUT:	EBX=device descriptor
					;		EDX=counter index (0-2)
					;	OUTPUT:	EAX=counter cur. value
					;		CY=invalid index

DEVTIM_GetOut:	resd	1		; get counter output
					;	INPUT:	EBX=device descriptor
					;		EDX=counter index (0-2)
					;	OUTPUT:	EAX=counter OUT (0, 1)
					;		CY=invalid index

endstruc

%define DEV_TIMER_ID "TIM1"		; TIMER interface identifier

; ------------- Timer mode

DEVTIM_MODE_CNT	EQU	0		; mode 0: countdown
DEVTIM_MODE_SHT	EQU	1		; mode 1: hw retriggerable one-shot
DEVTIM_MODE_GEN	EQU	2		; mode 2(6): rate generator
DEVTIM_MODE_SQR	EQU	3		; mode 3(7): square wave
DEVTIM_MODE_SWS	EQU	4		; mode 4: sw triggered strobe
DEVTIM_MODE_HWS	EQU	5		; mode 5: hw triggered strobe

DEVTIM_MODE_MAX	EQU	7		; maximal mode number

; ------------- Initialized TIMER device descriptor
; %1 = flags, %2 = major version, %3 = minor version,
; %4 = build version, %5 = name prefix ###
;	###SetMode = initialize counter
;	###SetVal = set new counter initial value
;	###GetVal = get counter current value
;	###GetOut = get counter output

%macro		DEVICETIMER 5

		DEVICE	DEVCLASS_SYS,DEV_SYS_TIMER,0,%1,%2,%3,%4,%5

		dd	%5 %+ SetMode	; initialize counter
		dd	%5 %+ SetVal	; set new counter initial value
		dd	%5 %+ GetVal	; get counter current value
		dd	%5 %+ GetOut	; get counter output

%endmacro
