; =============================================================================
;
;                      Litos - Interrupt controller 8259A
;
; =============================================================================

; ------------- IRQ device descriptor

struc		DEVIRQ

		resb	DEV_size	; general device

DEVIRQ_Channels:resd	1		; number of IRQ channels
DEVIRQ_Base:	resd	1		; base interrupt (multiple of 8)
DEVIRQ_Cache:	resd	1		; interrupt mask cache (1=disabled)
DEVIRQ_Flags:	resd	1		; IRQ device flags (see below)
                                          
DEVIRQ_Info:	resd	1		; get IRQ channel info
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=invalid channel num.
					;		   (ECX and ESI valid)
					;		ECX=number of channels
					;		EDX=flags (see below)
					;		   (0=invalid channel)
					;		ESI=base interrupt

DEVIRQ_Remap:	resd	1		; remap base interrupt address
					;	INPUT:	EAX=new base interrupt
					;		EBX=device descriptor
					;	OUTPUT:	CY=error

DEVIRQ_Enable:	resd	1		; enable interrupt
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=invalid channel num.

DEVIRQ_Disable:	resd	1		; disable interrupt
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=invalid channel num.

DEVIRQ_Pending:	resd	1		; check if interrupt is pending
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=interrupt is pending

DEVIRQ_InServ:	resd	1		; check if interrupt is in-service
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=interrupt in-service

DEVIRQ_Ack:	resd	1		; acknowledge interrupt
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=invalid channel num.

endstruc

%define DEV_IRQ_ID "IRQ1"		; IRQ interface identifier

; ------------- IRQ device flags

DEVIRQ_InSrv1_b	EQU	0		; bit of DEVIRQ_InSrv1
DEVIRQ_InSrv1	EQU	(1 << DEVIRQ_InSrv1_b) ; ctrl 1 is in-service
DEVIRQ_InSrv2_b	EQU	1		; bit of DEVIRQ_InSrv1
DEVIRQ_InSrv2	EQU	(1 << DEVIRQ_InSrv2_b) ; ctrl 2 is in-service

; ------------- Channel info flags (0=invalid channel)

IRQINFO_VALID	EQU	B0		; channel is valid (else invalid)
IRQINFO_ENABLED	EQU	B1		; channel is enabled (else disabled)

; ------------- Initialized IRQ device descriptor
; %1 = device index, %2 = flags, %3 = major version, %4 = minor version,
; %5 = build version, %6 = number of channels, %7 = name prefix ###
;	###Info = get IRQ channel info
;	###Remap = remap base interrupt address
;	###Enable = enable IRQ channel
;	###Disable = disable IRQ channel
;	###Pending = check if IRQ is pending
;	###InServ = check if IRQ is in-service
;	###Ack = acknowledge IRQ

%macro		DEVICEIRQ 7

		DEVICE	DEVCLASS_SYS,DEV_SYS_IRQ,%1,%2,%3,%4,%5,%7

		dd	%6		; number of channels
		dd	INT_FIRST	; base interrupt
		dd	-1		; cache of interrupt mask
		dd	0		; IRQ device flags

		dd	%7 %+ Info	; get IRQ channel info
		dd	%7 %+ Remap	; remap base interrupt address
		dd	%7 %+ Enable	; enable IRQ channel
		dd	%7 %+ Disable	; disable IRQ channel
		dd	%7 %+ Pending	; check if IRQ is pending
		dd	%7 %+ InServ	; check if IRQ is in-service
		dd	%7 %+ Ack	; acknowledge (and disable) interrupt

%endmacro
