; =============================================================================
;
;                        Litos - DMA controller 8237A
;
; =============================================================================

; ------------- DMA direction (hardcoded in DMAModeTab)

DMADIR_READ	EQU	0		; read from device
DMADIR_WRITE	EQU	1		; write to device
DMADIR_VERIFY	EQU	2		; verify data from device

DMADIR_NUM	EQU	3		; number of DMA directions

; ------------- DMA device descriptor

struc		DEVDMA

		resb	DEV_size	; general device

DEVDMA_Channels:resd	1		; number of DMA channels
DEVDMA_Used:	resd	1		; mask of used channels (0=available)
DEVDMA_Running:	resd	1		; mask of running channels

DEVDMA_Info:	resd	1		; get DMA channel info
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=invalid channel num.
					;		  (ECX is valid)
					;		ECX=number of channels
					;		EDX=flags (see below)
					;		   (0=invalid channel)

DEVDMA_Alloc:	resd	1		; allocate DMA channel
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=cannot allocate

DEVDMA_Free:	resd	1		; free DMA channel
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=error

DEVDMA_Start:	resd	1		; start DMA transfer
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;		ECX=number of bytes
					;		EDX=system address
					;		ESI=DMA direction
					;	OUTPUT:	CY=invalid argument
					;	NOTES:	Cannot cross 64K
					;		boundary. Max. size 64K
					;		and address and size
					;		must be word aligned.
					;		Only lower 16MB of mem.

DEVDMA_Stop:	resd	1		; stop DMA transfer
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;		CY=error

DEVDMA_Remain:	resd	1		; get remaining transfer size
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	ECX=remaining bytes
					;		CY=error

DEVDMA_Check:	resd	1		; check if transfer is still running
					;	INPUT:	EAX=channel number
					;		EBX=device descriptor
					;	OUTPUT:	CY=error or not running
endstruc

%define DEV_DMA_ID "DMA1"		; DMA interface identifier

; ------------- Channel info flags (0=invalid channel)

DMAINFO_VALID	EQU	B0		; channel is valid (else invalid)
DMAINFO_USED	EQU	B1		; channel is used (else free)
DMAINFO_RUNNING	EQU	B2		; channel is running (else stopped)
DMAINFO_8BIT	EQU	B3		; channel is 8-bit (else 16-bit)
DMAINFO_BOUND	EQU	B4		; must not cross 64K boundary (or 128K)
DMAINFO_ALIGN	EQU	B5		; must be word aligned (or need not be)
DMAINFO_16M	EQU	B6		; limited to lower 16 MB of memory

DMAINFO_CH0_3	EQU	DMAINFO_VALID+DMAINFO_8BIT+DMAINFO_BOUND+\
				DMAINFO_ALIGN+DMAINFO_16M
DMAINFO_CH4_7	EQU	DMAINFO_VALID+DMAINFO_BOUND+DMAINFO_ALIGN+DMAINFO_16M

; ------------- Initialized DMA device descriptor
; %1 = device index, %2 = flags, %3 = major version, %4 = minor version,
; %5 = build version, %6 = number of channels, %7 = name prefix ###
;	###Info = get DMA channel info
;	###Alloc = allocate DMA channel
;	###Free = free DMA channel
;	###Start = start DMA transfer
;	###Stop = stop DMA transfer
;	###Remain = get remaining transfer size
;	###Check = check if transfer is still running

%macro		DEVICEDMA 7

		DEVICE	DEVCLASS_SYS,DEV_SYS_DMA,%1,%2,%3,%4,%5,%7

		dd	%6		; number of channels
		dd	-1		; mask of used channels
		dd	0		; mask of running channels

		dd	%7 %+ Info	; get DMA channel info
		dd	%7 %+ Alloc	; allocate DMA channel
		dd	%7 %+ Free	; free DMA channel
		dd	%7 %+ Start	; start DMA transfer
		dd	%7 %+ Stop	; stop DMA transfer
		dd	%7 %+ Remain	; get remaining transfer size
		dd	%7 %+ Check	; check if transfer is still running
%endmacro
