; =============================================================================
;
;                             Litos - Wall clock
;
; =============================================================================
;	Hardware clock generator: 1193182 Hz   1193181.8181
;		(i.e. one third of the NTSC color subcarrier frequency.)
; 	Timer divisor: 1193
;       Interrupt frequency: 1000.1525566 Hz (0.9998474667 ms)
;	Increment in 100-nanosecs: 9998.474666899
;	Low DWORD increment (decimal part): 2038678808 (7983C518h)
;	High DWORD increment: 9998
;	Clock ticks per day: 86413180.89

; ------------- Wall clock device descriptor

struc		DEVCLOCK

		resb	DEV_size	; general device

;DEVCLK_


endstruc

%define DEV_CLOCK_ID "CLK1"		; CLOCK interface identifier

; ------------- Initialized CLOCK device descriptor
; %1 = flags, %2 = major version, %3 = minor version,
; %4 = build version, %5 = name prefix ###
;	###SetMode = initialize counter
;	###SetVal = set new counter initial value
;	###GetVal = get counter current value

%macro		DEVICECLOCK 5

		DEVICE	DEVCLASS_SYS,DEV_SYS_CLOCK,0,%1,%2,%3,%4,%5

;		dd	TIMER_FREQ	; timer frequency
;		dd	TIMER_IRQ	; timer IRQ number
;		dd	B0+B1+B2	; mask of valid channels
;		dd	B0+B1		; mask of used channels

;		dd	%5 %+ SetMode	; initialize counter
;		dd	%5 %+ SetVal	; set new counter initial value
;		dd	%5 %+ GetVal	; get counter current value

%endmacro
