; =============================================================================
;
;                       Litos - Device interrupt service
;
; =============================================================================

INT_NUM		EQU	32		; total number of interrupt lines
INT_FIRST	EQU	20h		; first interrupt for IRQ
					; (must be multiple of 8)

; ------------- Interrupt descriptor

struc		INTDESC

		resb	LIST_size	; 0: list of IRQ handlers
INTDESC_IRQ:	resb	1		; 8: IRQ number
INTDESC_Flags:	resb	1		; 9: flags (see below)
INTDESC_HandNum:resb	1		; 0Ah: total number of handlers
INTDESC_Active:	resb	1		; 0Bh: number of active handlers
		resd	1		; 0Ch: ...padding

endstruc				; size 10h = 16 bytes

; ------------- Interrupt descriptor flags

INTDESC_VALID	EQU	B0		; interrupt is valid (usable)

; ------------- Interrupt handler

struc		INTHAND

		resb	LIST_size	; 0: link to list of IRQ handlers
INTHAND_IntDesc:resd	1		; 8: pointer to interrupt descriptor
INTHAND_Flags:	resb	1		; 0Ch: flags (see below, DWORD aligned)
		resb	1		; 0Dh: ...padding
INTHAND_IRQ:	resb	1		; 0Eh: current IRQ number
INTHAND_Best:	resb	1		; 0Fh: recommended IRQ number (-1=none)
INTHAND_IRQMask:resd	1		; 10h: mask of usable IRQs (1=enabled)
INTHAND_Data:	resd	1		; 14h: user data
INTHAND_Int:	resd	1		; 18h: interrupt handler function
					;	INPUT:	EAX = IRQ number
					;		EBX = user data
					;	Handler must save all registers!
					;      Private handler has no input.
		resd	1		; 1Ch: ...padding

endstruc				; size 20h = 32 bytes

; ------------- Interupt handler flags

INT_SHARE	EQU	B0		; IRQ can be shared
INT_PRIVATE	EQU	B1		; private handling (with own handler)
INT_ACTIVE_BIT	EQU	2		; (bit number of IRQ_ACTIVE flag)
INT_ACTIVE	EQU	(1 << INT_ACTIVE_BIT) ; handler is active (enabled)

; ------------- Initialized interrupt handler
; Parameters: %1 = flags, %2 = recommended IRQ number (-1=none),
; %3 = mask of usable IRQs (1=enabled), %4 = interrupt handler

%macro		INTHANDLER 4

%%L1:
		LISTHEAD		; link to list of IRQ handlers
		dd	NULL		; pointer to interrupt descriptor
		db	%1		; interrupt handler flags
		db	0		; ...padding
		db	-1		; current IRQ number
		db	%2		; recommended IRQ number (-1=none)
		dd	%3		; mask of usable IRQs (1=enabled)
		dd	%%L1		; user data
		dd	%4		; interrupt handler
		dd	0		; ...padding
%endmacro
