; =============================================================================
;
;                           Litos - Floppy disk
;
; =============================================================================
; This is very simplified version of the drive. It supports only 1 drive with
; one media format (1.44 MB).

; ------------- Floppy disk controller function block

struc		FDCF

;		resb	DFB_size	; 0: driver function block

endstruc				; size 14h = 20 bytes

; ------------- Floppy disk controller parameter block

FDBUFFSIZE	EQU	4000h		; DMA buffer size (18 sectors = 9K)

struc		FDC

		resb	DEV_size	; 0: driver parameter block
FDC_Flags:	resb	1		; 40h: flags (see below, DWORD aligned)
		resb	3
FDC_Buffer:	resd	1		; 44h: pointer to DMA buffer
FDC_IntLock:	resb	TASKLOCK_size	; 48h: task lock for interrupt
FDC_MotorLock:	resb	SPINLOCK_size	; 54h: motor lock
FDC_Mutex:	resb	MUT_size	; 58h: mutex to lock access to floppy

endstruc				; size 74h = 116 bytes

; ------------- Floppy disk controller flags

FDC_INTOK_BIT 	EQU	0		; interrupt occurs
FDC_INTOK	EQU	1 << FDC_INTOK_BIT

FDC_DEFFLAG	EQU	0		; default flags

; ------------- Floppy disk device function block

struc		FLOPPYF

		resb	DISKF_size	; 0: block device function block

endstruc				; size 5Ch = 92 bytes

; ------------- Floppy disk data device capabilities

FLOPPY_CAP1	EQU	DDEV_CANSEEK+DDEV_CANCHANGE+DDEV_CANALL+DDEV_CANHWWPROT
FLOPPY_CAP	EQU	FLOPPY_CAP1+DDEV_CANCACHE

; ------------- Floppy disk device parameter block

FLOP_REPMAX	EQU	7		; maximal number of replies

struc		FLOPPY

		resb	DISK_size	; 0: block device parameter block

FLOPPY_FDC:	resd	1		; 74h: pointer to controller FDC
FLOPPY_Flags:	resb	1		; 78h: flags (see below, DWORD aligned)
FLOPPY_Track:	resb	1		; 79h: current track number
FLOPPY_Head:	resb	1		; 7Ah: current head number
FLOPPY_LastErr:	resb	1		; 7Bh: last error code (see below)
FLOPPY_Buffer:	resd	1		; 7Ch: pointer to DMA buffer
FLOPPY_Alarm:	resb	ALARM_size	; 80h: motor OFF timer
FLOPPY_Reply:	resb	FLOP_REPMAX	; 0A0h: reply buffer
		resb	1		; 0AFh

endstruc				; size 0B0h = 176 bytes

FLOPPY_ST0	EQU	FLOPPY_Reply + 0 ; reply register 0
FLOPPY_ST1	EQU	FLOPPY_Reply + 1 ; reply register 1
FLOPPY_ST2	EQU	FLOPPY_Reply + 2 ; reply register 2
FLOPPY_ST3	EQU	FLOPPY_Reply + 0 ; reply register 3 (=result)

; ------------- Floppy disk device flags

FLOPPY_RESREQ	EQU	B0		; reset request
FLOPPY_SEEKREQ	EQU	B1		; seek request
FLOPPY_MOTORON	EQU	B2		; motor is ON

FLOPPY_DEFFLAG	EQU	FLOPPY_SEEKREQ+FLOPPY_RESREQ ; default flags

; ------------- Floppy disk error code

				; *** No error
FDERR_OK	EQU	00h		; no error
				; *** General errors
FDERR_UNKOWN	EQU	11h		; unknown error
				; *** FDC controller errors
FDERR_FDCERR	EQU	21h		; controller general error
FDERR_FDCRESET	EQU	22h		; controller reset error
FDERR_FDCREADY	EQU	23h		; controller not ready (FDC time-out)
FDERR_FDCWRITE	EQU	24h		; error writing command to controller
FDERR_FDCREAD	EQU	25h		; error receiving state from controller
FDERR_FDCOVER	EQU	26h		; result buffer overrun
FDERR_OVERRUN	EQU	27h		; data overrun (data lost, DMA error)
				; *** Drive error
FDERR_SEEKERR	EQU	31h		; seek error
FDERR_TIMEOUT	EQU	32h		; operation (interrupt) time-out
FDERR_DRVREADY	EQU	33h		; drive not ready
FDERR_ZEROTRACK	EQU	34h		; recalibrate error, track 0 not found
				; *** Media error
FDERR_ADDRFND	EQU	41h		; missing sector address mark
FDERR_WPROT	EQU	42h		; disk write-protected
FDERR_DATAFND	EQU	43h		; missing sector data
FDERR_CRC	EQU	44h		; bad CRC of sector
FDERR_SECTFND	EQU	45h		; sector not found
FDERR_BADHEAD	EQU	46h		; sector head does not correspomd

; ------------- Floppy disk track layout (one entry, used with format track)

struc		FTRACK

FTRACK_Cyl:	resb	1		; 0: cylinder number (0..79)
FTRACK_Head:	resb	1		; 1: head number (0..1)
FTRACK_Sect:	resb	1		; 2: sector number (1..)
FTRACK_Size:	resb	1		; 3: sector size (0=128,...)

endstruc				; size 4 bytes

; ------------- Main status register

FDS_BUSYMASK	EQU	B0+B1+B2+B3	; busy mask (drive 0..3 seeks)
FDS_BUSY	EQU	B4		; controller busy (command in progress)
FDS_NONDMA	EQU	B5		; non-DMA mode (SPECIFY is executed)
FDS_DIRREAD	EQU	B6		; data direction 1=FDC->CPU, 0=CPU->FDC
FDS_READY	EQU	B7		; data register ready (to transfer)

; ------------- Digital output register (DOR)

FDDOR_SELMASK	EQU	B0+B1		; drive select mask (0..3)
FDDOR_FDCENABLE	EQU	B2		; FDC enable (0=controller reset)
FDDOR_DMAENABLE	EQU	B3		; DMA enable
FDDOR_MOTOR0	EQU	B4		; drive 0 motor enable
FDDOR_MOTOR1	EQU	B5		; drive 1 motor enable
FDDOR_MOTOR2	EQU	B6		; drive 2 motor enable
FDDOR_MOTOR3	EQU	B7		; drive 3 motor enable

FDDOR_MOTMASK	EQU	B4+B5+B6+B7	; drive motors mask

; ------------- Status register ST0

FDST0_DRVMASK	EQU	B0+B1		; drive unit at interrupt
FDST0_HEAD	EQU	B2		; head state at interrupt
FDST0_NREADY	EQU	B3		; not ready (drive is not ready with
					; R/W command or access to side 1
					; required on single side drive)
FDST0_EQERR	EQU	B4		; equipment check error, fault signal
					; received or track 0 not found
FDST0_SEEKEND	EQU	B5		; seek completed
FDST0_INTMASK0	EQU	B6		; interrupt code mask (low bit)
FDST0_INTMASK1	EQU	B7		; interrupt code mask (high bit)
FDST0_INTMASK	EQU	B6+B7		; interrupt code mask
					;  00 = normal termination
					;  01 = abnormal termination, command
					;	was started but was not
					;	successfully completed
					;  10 = invalid command, command
					;	was never started
					;  11 = abnormal termination, ready
					;	signal changed state

; ------------- Status register ST1

FDST1_MISADDR	EQU	B0		; missing address mark
FDST1_WP	EQU	B1		; write protect (during write)
FDST1_NDATA	EQU	B2		; no data (sector not found)
FDST1_OVERRUN	EQU	B4		; overrun (FDC is not serviced by the
					; host system during data transfer)
FDST1_CRC	EQU	B5		; CRC error in data or head
FDST1_EOC	EQU	B7		; end of cylinder (FDC tries to access
					; sector after last sector of cylinder)

; ------------- Status register ST2

FDST2_MISADDR	EQU	B0		; missing address mark in data field
FDST2_BADCYL	EQU	B1		; bad cylinder (different cylinder)
FDST2_SCANERR	EQU	B2		; scan not satisfied (cannot find
					; sector during scan command)
FDST2_SCANEQU	EQU	B3		; scan equal hit
FDST2_WRONGCYL	EQU	B4		; wrong cylinder
FDST2_CRC	EQU	B5		; CRC error in data
FDST2_CTRLMARK	EQU	B6		; control mark

; ------------- Status register ST3

FDST3_HEAD	EQU	B2		; head
FDST3_DS	EQU	B3		; drive us double-sided
FDST3_TRACK0	EQU	B4		; track zero signal
FDST3_READY	EQU	B5		; drive is ready
FDST3_WP	EQU	B6		; write protect
FDST3_FAULT	EQU	B7		; drive fault

; ------------- Floppy disk commands
; Recalibrate:
;     W - DS drive select (B0+B1)

; Read/write data:
;     W - HDS+DS head select (B2) + drive select (B0+B1)
; 	- C cylinder (for sector ID information, starting 0)
; 	- H head (for sector ID information, 0 or 1)
;	- R sector number (for sector ID information. starting 1)
;	- N sector size (for sector ID information, 0=128 B...)
;	- EOT end of track (final sector number of a cylinder)
;	- GPL gap 3 length (spacing between sector excl. VCO sync field)
;	- DTL data length when N is 0
;     R	- ST0
;	- ST1
;	- ST2
; 	- C cylinder
; 	- H head
;	- R sector number
;	- N sector size
;
; Format a track:
;     W - HDS+DS head select (B2) + drive select (B0+B1)
;	- N sector size (for sector ID information, 0=128 B...)
;	- SC sectors/track
;	- GPL gap 3 length (spacing between sector excl. VCO sync field)
;	- D filler byte
;     R	- ST0
;	- ST1
;	- ST2
; 	- C cylinder
; 	- H head
;	- R sector number
;	- N sector size
;
; Sense interrupt status:
;     R	- ST0
;	- PCN present cylinder number
;
; Specify:
;     W - SRT+HUT step rate time (B4..B7) + head uload time (B0..B3)
;	- HLT+ND head load time (B1..B7) + non-DMA mode (B0)
;
; Semse drive status:
;     W - HDS+DS head select (B2) + drive select (B0+B1)
;     R	- ST3
;
; Seek:
;     W - HDS+DS head select (B2) + drive select (B0+B1)
;     W	- NCN new cylinder number
;
; Invalid command:
;     R - ST0 with 80h

FD_SPECIFY	EQU	3		; specify

FD_STATUS	EQU	4		; sense drive status (read ST3)

FD_WRITE	EQU	5+B6		; write (without multi-track, with MFM)

FD_READ		EQU	6+B5+B6		; read (without multi-track, with MFM,
					;	with skip deleted data)

FD_RECALIB	EQU	7		; recalibrate (move to track 0)

FD_SENSE	EQU	8		; sense interrupt status

FD_FORMAT	EQU	0dh+B6		; format track (with MFM)

FD_SEEK		EQU	0fh		; seek
