; =============================================================================
;
;                         Litos - General display
;
; =============================================================================

; ------------- Standard PC colors

COL_BLACK	EQU	0		; black
COL_BLUE	EQU	1		; blue
COL_GREEN	EQU	2		; green
COL_CYAN	EQU	3		; cyan
COL_RED		EQU	4		; red
COL_MAGENTA	EQU	5		; magenta
COL_YELLOW	EQU	6		; yellow (brown)
COL_WHITE	EQU	7		; white
COL_LBLACK	EQU	8		; light black (gray)
COL_LBLUE	EQU	9		; light blue
COL_LGREEN	EQU	10		; light green
COL_LCYAN	EQU	11		; light cyan
COL_LRED	EQU	12		; light red
COL_LMAGENTA	EQU	13		; light magenta
COL_LYELLOW	EQU	14		; light yellow
COL_LWHITE	EQU	15		; light white

COL_BROWN	EQU	COL_YELLOW	; brown (dark yellow)
COL_GRAY	EQU	COL_LBLACK	; gray (light black)

; ------------- Monochrome attributes

COL_INVIS	EQU	00h		; invisible
COL_UNDER	EQU	01h		; underline
COL_NORMAL	EQU	07h		; normal
COL_INTENS	EQU	0fh		; intensity
COL_INVERSE	EQU	70h		; inverse
COL_DARK	EQU	08h		; dark

; ------------- Color attributes

COL_FGINT	EQU	B3		; foreground intensity bit
COL_CHAR2	EQU	COL_FGINT	; alternate charset
COL_BLINK	EQU	B7		; blinking bit
COL_BGINT	EQU	COL_BLINK	; background intensity bit

; ------------- Position

struc		POSITION

POS_X:		resd	1		; 0: horizontal position
POS_Y:		resd	1		; 4: vertical position

endstruc				; size 8 bytes

; ------------- Dimension

struc		DIMENSION

DIM_W:		resd	1		; 0: width
DIM_H:		resd	1		; 4: height

endstruc				; size 8 bytes

; ------------- Area

struc		AREA

AREA_Pos:	resb	POSITION_size	; 0: area position
AREA_Dim:	resb	DIMENSION_size	; 8: area dimension

endstruc				; size 16 bytes

AREA_X		EQU	AREA_Pos+POS_X	; area left
AREA_Y		EQU	AREA_Pos+POS_Y	; area top
AREA_W		EQU	AREA_Dim+DIM_W	; area width
AREA_H		EQU	AREA_Dim+DIM_H	; area height

; ------------- Extended area

struc		AREAX

		resb	AREA_size	; 0: area position and dimension
AREA_End:	resb	POSITION_size	; 10h: area end position + 1
					; (end = position + dimension)

endstruc				; size 18h = 24 bytes

AREA_X2		EQU	AREA_End+POS_X	; area right+1
AREA_Y2		EQU	AREA_End+POS_Y	; area bottom+1

; ------------- Videomode

struc		VMODE

VMODE_VirtDim:	resb	DIMENSION_size	; 0: virtual dimension (0=auto)
VMODE_DispDim:	resb	DIMENSION_size	; 8: display dimension (0=auto)
VMODE_FontDim:	resb	DIMENSION_size	; 10h: text font dimension (0=auto)
VMODE_Freq:	resd	1		; 18h: vertical frequency [Hz] (0=auto)
VMODE_MemMode:	resb	1		; 1Ch: memory mode (see below, 0=auto)
VMODE_BitsPoint:resb	1		; 1Dh: total bits per point
VMODE_BitsPlane:resb	1		; 1Eh: bits per point in one plane
VMODE_Planes:	resb	1		; 1Fh: color planes
VMODE_BaseAddr:	resd	1		; 20h: videomemory base address
VMODE_DispSize:	resd	1		; 24h: size of display page
VMODE_MaxOff:	resd	1		; 28h: maximal offset of display page
VMODE_ScanLine:	resd	1		; 2Ch: bytes per scan line
VMODE_PlaneSize:resd	1		; 30h: size of one plane (bytes)
VMODE_Port:	resd	1		; 34h: control port (+1=data port)

endstruc				; size 38h = 56 bytes

VMODE_VirtW	EQU	VMODE_VirtDim+DIM_W ; virtual width
VMODE_VirtH	EQU	VMODE_VirtDim+DIM_H ; virtual height
VMODE_W		EQU	VMODE_DispDim+DIM_W ; display width
VMODE_H		EQU	VMODE_DispDim+DIM_H ; display heigh
VMODE_FontW	EQU	VMODE_FontDim+DIM_W ; text font width
VMODE_FontH	EQU	VMODE_FontDim+DIM_H ; text font height

; ------------- Memory mode

VMODE_TEXT	EQU	1		; simple text (1 byte, without color)
VMODE_TEXTMONO	EQU	2		; monochrome text mode (2 bytes)
VMODE_TEXTCOLOR	EQU	3		; color text mode (2 bytes)
VMODE_1BIT	EQU	4		; 2 colors, 1 bit
VMODE_2BIT	EQU	5		; 4 colors, 2 bits
VMODE_2BITN	EQU	6		; 4 colors, 1 bit, 2 planes (no-stand.)
VMODE_3BITN	EQU	7		; 8 colors, 1 bit, 3 planes (no-stand.)
VMODE_4BIT	EQU	8		; 16 colors, 1 bit, 4 planes
VMODE_4BITN	EQU	9		; 16 colors, 4 bit (no-stand.)
VMODE_8BIT	EQU	10		; 256 colors, 8 bits
VMODE_8BITN	EQU	11		; 256 colors, 1 byt, 8 planes (no-std.)
VMODE_15BIT	EQU	12		; 32K colors, 2 bytes (B5, G5, R5)
VMODE_15BITA	EQU	13		; 32K colors, 2 bytes (B5, G5, R5, A1)
VMODE_16BIT	EQU	14		; 64K colors, 2 bytes (B5, G6, R5)
VMODE_24BIT	EQU	15		; True-Color, 3 bytes (B8, G8, R8)
VMODE_32BIT	EQU	16		; True-Color, 4 bytes (B8, G8, R8)
VMODE_32BITA	EQU	17		; True-Color, 4 bytes (B8, G8, R8, A8)

; ------------- Display driver function block
; Driver may modify entries after setting videomode.

struc		DDFB

DDFB_EnumMode:	resd	1		; 14h: function - enumerate videomodes
					;	INPUT:	EAX = index (0...)
					;		EBX = display driver
					;		EDX = videomode struc.,
					;		      NULL=not used
					;	OUTPUT:	CY = invalid index,
					;		     EAX = max. index
					;		NC = videomode struc.
					;		     is filled up
					;		EAX = index/max.index

DDFB_TestMode:	resd	1		; 18h: function - test videomode
					;	INPUT:	EBX = display driver
					;		EDX = videomode struc.
					;		 (full dim., disp.dim.,
					;		 font dimension, freq.
					;		 and mem. mode can be
					;		 set or 0=auto)
					;	OUTPUT:	CY = invalid mode
					;		NC = videomode struc.
					;		     is filled up

DDFB_SetMode:	resd	1		; 1Ch: function - set videomode
					;	INPUT:	EBX = display driver
					;		EDX = videomode struc.
					;		 (full dim., disp.dim.,
					;		 font dimension, freq.
					;		 and mem. mode can be
					;		 set or 0=auto)
					;	OUTPUT:	CY = invalid mode
					;		NC = videomode struc.
					;		     is filled up

DDFB_Clear:	resd	1		; 20h: function - clear screen+reset
					;	INPUT:	EBX = display driver

DDFB_SetOffset:	resd	1		; 24h: function - set display offset
					;	INPUT:	EBX = display driver
					;		ECX = display X coord.
					;		EDX = display Y coord.

DDFB_SetCursor:	resd	1		; 28h: function - set cursor position
					;	INPUT:	EBX = display driver
					;		ECX = cursor column
					;		EDX = cursor row

DDFB_SetCurSize:resd	1		; 2Ch: function - set cursor size
					;	INPUT:	EBX = display driver
					;		ECX = top scan line
					;		EDX = bottom scan line

DDFB_SetVisible:resd	1		; 30h: function - set cursor visible
					;	INPUT:	AL = 0 off,1 on,2 flip
					;		EBX = display driver

DDFB_LoadFont:	resd	1		; 34h: function - load text font
					;	INPUT:	AL = bank (0...)
					;		AH = font height(0=def)
					;		EBX = display driver
					;		CL = first index
					;		DL = last index
					;		ESI = font

DDFB_SetFont:	resd	1		; 38h: function - set font bank
					;	INPUT:	EBX = display driver
					;		CL = bank for attr3=0
					;		DL = bank for attr3=1

DDFB_SetBorder:	resd	1		; 3Ch: function - set border color
					;	INPUT:	AL = border color
					;		EBX = display driver

DDFB_SetPalCGA:	resd	1		; 40h: function - set CGA palette
					;	INPUT:	AL = CGA palette
					;			0 = blue off
					;			1 = blue on
					;		EBX = display driver

DDFB_SetPalEGA:	resd	1		; 44h: function - set EGA palette
					;	INPUT:	AL = start index 0..16
					;		EBX = display driver
					;		CL = stop index 0..16
					;		EDX = EGA palettes

DDFB_SetPalVGA:	resd	1		; 48h: function - set VGA palette
					;	INPUT:	AL = start index
					;		EBX = display driver
					;		CL = stop index
					;		EDX = VGA palette

DDFB_SetPalInx:	resd	1		; 4Ch: function - set indexed palette
					;	INPUT:	EAX = index table
					;		EBX = display driver
					;		ECX = number of entries
					;		EDX = VGA palette

DDFB_FillUp:	resd	1		; 50h: function - fill-up region
					;	INPUT:	AL = color or character
					;		AH = color (text mode)
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top

DDFB_Move:	resd	1		; 54h: function - move region
					;	INPUT:	EAX = dest. offset
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top

DDFB_BufferSize:resd	1		; 58h: function - get buffer size
					;	INPUT:	EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;	OUTPUT:	EAX = buffer size

DDFB_GetRegion:	resd	1		; 5Ch: function - get region
					;	INPUT:	EAX = dest. buffer
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top

DDFB_SetRegion:	resd	1		; 60h: function - set region
					;	INPUT:	EAX = source buffer
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top

DDFB_SetRegCol:	resd	1		; 64h: function - set region with color
					;	INPUT:	EAX = source buffer
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top
					;		EBP = color

DDFB_SetColMask:resd	1		; 68h: function - set reg.with col.mask
					;	INPUT:	EAX = buffer
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top
					;		EBP = transparent color

DDFB_SetMasked:	resd	1		; 6Ch: function - set region with mask
					;	INPUT:	EAX = buffer + bit mask
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top

DDFB_SetAlpha:	resd	1		; 70h: function - set region with alpha
					;	INPUT:	EAX = buffer + alpha
					;		EBX = display driver
					;		ECX = region width
					;		EDX = region height
					;		ESI = region left
					;		EDI = region top

		align	8, resb 1
endstruc				; size 78h = 120 bytes

; ------------- Display driver parameter block

DISPMAXREG	EQU	30h		; maximal number of display registers

struc		DDPB

		resb	DEV_size	; 0: driver descriptor

DDPB_Flags:	resd	1		; 40h: flags (see below)
DDPB_MemSize:	resd	1		; 44h: total videomemory size
DDPB_CurPos:	resb	POSITION_size	; 48h: text cursor position X
DDPB_CurSizeT:	resd	1		; 50h: cursor size - top scan line
DDPB_CurSizeB:	resd	1		; 54h: cursor size - bottom scan line
DDPB_Offset:	resb	POSITION_size	; 58h: current display offset
DDPB_Addr:	resd	1		; 60h: current display address
DDPB_FromUni:	resd	1		; 64h: mapping table from Unicode
DDPB_FontBuff:	resd	1		; 68h: font buffer (128*32 = 4 KB)
		resd	1		; 6Ch: ...padding
DDPB_VMode:	resb	VMODE_size	; 70h: current videomode
DDPB_Regs:	resb	DISPMAXREG	; 0A8h: cache of display registers

endstruc				; size 0D8h = 216 bytes

DDPB_CurPosX	EQU	DDPB_CurPos+POS_X ; cursor position X
DDPB_CurPosY	EQU	DDPB_CurPos+POS_Y ; cursor position Y
DDPB_OffX	EQU	DDPB_Offset+POS_X ; display offset X
DDPB_OffY	EQU	DDPB_Offset+POS_Y ; display offset Y
DDPB_VirtW	EQU	DDPB_VMode+VMODE_VirtW ; virtual width (0=auto)
DDPB_VirtH	EQU	DDPB_VMode+VMODE_VirtH ; virtual height (0=auto)
DDPB_W		EQU	DDPB_VMode+VMODE_W ; display width (0=auto)
DDPB_H		EQU	DDPB_VMode+VMODE_H ; display height (0=auto)
DDPB_FontW	EQU	DDPB_VMode+VMODE_FontW ; text font width (0=auto)
DDPB_FontH	EQU	DDPB_VMode+VMODE_FontH ; text font height (0=auto)
DDPB_Freq	EQU	DDPB_VMode+VMODE_Freq ; vert. frequency [Hz] (0=auto)
DDPB_MemMode	EQU	DDPB_VMode+VMODE_MemMode ; memory mode
DDPB_BitsPoint	EQU	DDPB_VMode+VMODE_BitsPoint ; total bits per point
DDPB_BitsPlane	EQU	DDPB_VMode+VMODE_BitsPlane ; bits per point in 1 plane
DDPB_Planes	EQU	DDPB_VMode+VMODE_Planes ; color planes
DDPB_BaseAddr	EQU	DDPB_VMode+VMODE_BaseAddr ; videomemory base address
DDPB_DispSize	EQU	DDPB_VMode+VMODE_DispSize ; size of display page
DDPB_MaxOff	EQU	DDPB_VMode+VMODE_MaxOff ; maximal offset of disp. page
DDPB_ScanLine	EQU	DDPB_VMode+VMODE_ScanLine ; bytes per scan line
DDPB_PlaneSize	EQU	DDPB_VMode+VMODE_PlaneSize ; size of one plane
DDPB_Port	EQU	DDPB_VMode+VMODE_Port ; control port

; ------------- Display driver flags

DDPB_CURON	EQU	B0		; cursor is on
DDPB_CANTEXT	EQU	B1		; can use text videomodes
DDPB_CANGRAPH	EQU	B2		; can use graphic videomodes
DDPB_CANFONT	EQU	B3		; can set fonts
DDFB_VGA	EQU	B4		; card is VGA compatible

; ------------- Fixed font

struc		FIXFONT

FIXFONT_Width:	resd	1		; 0: character width
FIXFONT_Height:	resd	1		; 4: character height
FIXFONT_Map:	resd	1		; 8: mapping from Unicode to address
FIXFONT_Invalid:resd	1		; 0Ch: pointer to invalid character
FIXFONT_End:	resd	1		; 10h: end of font data
FIXFONT_Data:				; 14h: start of font data
					;	- (1) number of Unicode codes
					;	- N*(2) Unicode code
					;	- font data  

endstruc				; size 20 bytes

FIXFONT_MASK	EQU	B0+B1+B2+B3+B4	; mask of number of Unicode codes
FIXFONT_VGRAPHT	EQU	B5		; expand vertical graphics top
FIXFONT_VGRAPHB	EQU	B6		; expand vertical graphics bottom
