; =============================================================================
;
;                             Litos - Block device
;
; =============================================================================

; ------------- Block device function block

struc		DISKF

		resb	DATADEVF_size	; 0: data device function block

DISKF_ReadTrk:	resd	1		; 48h: read sectors from track
					;	INPUT:	EAX=start sector (1...)
					;		EBX=block device
					;		ECX=number of sectors
					;		EDX=data buffer
					;		ESI=head (0...)
					;		EDI=cylinder (0...)
					;	OUTPUT:	EAX=sectors OK read
					;		CY=error

DISKF_WriteTrk:	resd	1		; 4Ch: write sectors to track
					;	INPUT:	EAX=start sector (1...)
					;		EBX=block device
					;		ECX=number of sectors
					;		EDX=data buffer
					;		ESI=head (0...)
					;		EDI=cylinder (0...)
					;	OUTPUT:	EAX=sectors OK written
					;		CY=error

DISKF_VerifyTrk:resd	1		; 50h: verify sectors from track
					;	INPUT:	EAX=start sector (1...)
					;		EBX=block device
					;		ECX=number of sectors
					;		ESI=head (0...)
					;		EDI=cylinder (0...)
					;	OUTPUT:	EAX=sectors OK verified
					;		CY=error

DISKF_CompTrk:	resd	1		; 54h: compare sectors from track
					;	INPUT:	EAX=start sector (1...)
					;		EBX=block device
					;		ECX=number of sectors
					;		EDX=data buffer
					;		ESI=head (0...)
					;		EDI=cylinder (0...)
					;	OUTPUT:	EAX=sectors OK compared
					;		CY=error

DISKF_FormatTrk:resd	1		; 58h: format track
					;	INPUT:	AL=filler byte
					;		EBX=block device
					;		ESI=head (0...)
					;		EDI=cylinder (0...)
					;	OUTPUT:	CY=error

endstruc				; size 5Ch = 92 bytes

; ------------- Block device parameter block

struc		DISK

		resb	DATADEV_size	; 0: driver parameter block
DISK_SectNum:	resd	2		; 60h: total number of sectors
DISK_TrackSect:	resd	1		; 68h: number of sectors per track
DISK_Heads:	resd	1		; 6Ch: number of heads
DISK_Tracks:	resd	1		; 70h: number of cylinders

endstruc				; size 74h = 116 bytes

DISK_SectSize	EQU	DDEV_GranSize	; sector size (bytes)

; ------------- Block device logical media (partition) descriptor

;struc		PARTITION
;
;PART_Size:	resd	2		; 0: media size (bytes)
;PART_SectNum:	resd	2		; 8: total number of sectors
;PART_StrtSect:	resd	2		; 10h: first sector
;PART_StrtHead:	resd	1		; 18h: head of first sector
;PART_StrtTrck:	resd	1		; 1Ch: track of first sector
;PART_EndSect:	resd	2		; 20h: last sector (size=last-first+1)
;PART_EndHead:	resd	1		; 28h: head of last sector
;PART_EndTrck:	resd	1		; 2Ch: track of last sector
;
;endstruc				; size 30h = 48 bytes

;DISK_LMedia:	resb	LMEDIA_size	; 70h: primary partition descriptor

;DISK_PartSize	EQU	DISK_LMedia+LMEDIA_Size ; partition size (bytes)
;DISK_PartSectN	EQU	DISK_LMedia+LMEDIA_SectNum ; partition sectors
;DISK_StrtSect	EQU	DISK_LMedia+LMEDIA_StrtSect ; first sector
;DISK_StrtHead	EQU	DISK_LMedia+LMEDIA_StrtHead ; head of first sector
;DISK_StrtTrck	EQU	DISK_LMedia+LMEDIA_StrtTrck ; track of first sector
;DISK_EndSect	EQU	DISK_LMedia+LMEDIA_EndSect ; last sector
;DISK_EndHead	EQU	DISK_LMedia+LMEDIA_EndHead ; head of last sector
;DISK_EndTrck	EQU	DISK_LMedia+LMEDIA_EndTrck ; track of last sector

