; =============================================================================
;
;                           Litos - Data device
;
; =============================================================================

; ------------- Data device function block

struc		DATADEVF

DDEV_Open:	resd	1		; 14h: open data device
					;	OUTPUT:	CY=error

DDEV_Close:	resd	1		; 18h: close data device
					;	OUTPUT: CY=error

DDEV_Read:	resd	1		; 1Ch: read data from device
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ECX=data length
					;		ESI=data buffer
					;	OUTPUT:	EAX=bytes OK read
					;		CY=error

DDEV_Write:	resd	1		; 20h: write data to device
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ECX=data length
					;		ESI=data buffer
					;	OUTPUT:	EAX=bytes OK written
					;		CY=error

DDEV_Verify:	resd	1		; 24h: verify data from device
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ECX=data length
					;	OUTPUT:	EAX=bytes OK verified
					;		CY=error

DDEV_Compare:	resd	1		; 28h: compare data from device
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ECX=data length
					;		ESI=data buffer
					;	OUTPUT:	EAX=bytes OK compared
					;		CY=error

DDEV_LockDoor:	resd	1		; 2Ch: lock door
					;	INPUT:	AL=0 unlock, <>0 lock
					;	OUTPUT:	CY=error

DDEV_GetOpen:	resd	1		; 30h: get door open status
					;	OUTPUT:	CY=error
					;		EAX=0 open, 1 close
					;		+empty, 2 close+media

DDEV_SetOpen:	resd	1		; 34h: set door open status
					;	INPUT:	AL=0 open, <>0 close
					;	OUTPUT:	CY=error

DDEV_Changed:	resd	1		; 38h: test media change
					;	OUTPUT:	EAX=0 not, <>0 changed
					;		CY=error

DDEV_CacheRead:	resd	1		; 3Ch: read cached data from device
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ECX=data length
					;		ESI=data buffer
					;	OUTPUT:	EAX=bytes OK read
					;		CY=error

DDEV_CacheWrite:resd	1		; 40h: write cached data to device
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ECX=data length
					;		ESI=data buffer
					;	OUTPUT:	EAX=bytes OK written
					;		CY=error

DDEV_CacheFlush:resd	1		; 44h: flush write cache
					;	INPUT:	EDX:EAX=data offset
					;		EBX=data device
					;		ESI:ECX=data length
					;	OUTPUT:	CY=error

endstruc				; size 48h = 72 bytes

; ------------- Data device parameter block
; Granularity = sector size (on block device) or byte (on character device)

struc		DATADEV

		resb	DEV_size	; 0: driver descriptor
DDEV_Flags:	resd	1		; 40h: flags (see below)
DDEV_Caps:	resd	1		; 44h: capabilities (see below)
		resb	3		; 48h
DDEV_GranBits:	resb	1		; 4Bh: granularity bits (0=1 byte,...)
DDEV_GranSize:	resd	1		; 4Ch: granularity size (1, 2, 4, ...)
DDEV_GranMask:	resd	1		; 50h: granularity inverse mask
DDEV_FileName:	resd	1		; 54h: device file name STEXT
DDEV_Size:	resd	2		; 58h: media size (bytes)
DDEV_CurPos:	resd	2		; 60h: current position

endstruc				; size 68h = 104 bytes

DDEV_MAX_GRAN	EQU	CACHE_BUFSIZE	; maximal granularity of data device

; ------------- Data device flags

DDEV_CHARDEV	EQU	B0		; character device
DDEV_OPENED	EQU	B1		; data device is opened
DDEV_LOCKED	EQU	B2		; door is locked
DDEV_WRITEVER	EQU	B3		; write with verify or compare
DDEV_USECOMP	EQU	B4		; use compare instead verify
DDEV_HWWPROT	EQU	B5		; hardware write-protected
DDEV_SWWPROT	EQU	B6		; software write-protected

; ------------- Data device capabilities

DDEV_CANSEEK	EQU	B0		; can seek (and has size)
DDEV_CANLOCK	EQU	B1		; can lock door
DDEV_CANGETOPEN EQU	B2		; can get door open
DDEV_CANSETOPEN EQU	B3		; can set door open
DDEV_CANCHANGE	EQU	B4		; can detect media change
DDEV_CHANGESAFE EQU	B5		; can detect media change safely
DDEV_VOLATILE	EQU	B6		; data volatile (cannot verify, cache)
DDEV_CANREAD	EQU	B7		; can read
DDEV_CANWRITE	EQU	B8		; can write
DDEV_CANVERIFY	EQU	B9		; can verify
DDEV_CANCOMPARE	EQU	B10		; can compare
DDEV_CANWRIVER	EQU	B11		; can write with verify
DDEV_CANWRICOMP EQU	B12		; can write with compare
DDEV_CANHWWPROT EQU	B13		; can hardware write-protect
DDEV_CANCACHE	EQU	B14		; can cache

DDEV_CANALLR	EQU	DDEV_CANREAD+DDEV_CANVERIFY+DDEV_CANCOMPARE
DDEV_CANALLW	EQU	DDEV_CANWRITE+DDEV_CANWRIVER+DDEV_CANWRICOMP
DDEV_CANALL	EQU	DDEV_CANALLR+DDEV_CANALLW
